set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7711518';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '2301343',
      0.087396,
      1.259794,
      NULL,
      NULL,
      '1211',
      1.733443,
      1,
      NULL,
      NULL,
      ' 7- 7-1998',
      62,
      NULL,
      2.571319,
      NULL,
      0,
      '10-12-1976',
      NULL,
      1,
      NULL,
      56.436088,
      3,
      NULL,
      NULL,
      ' 8- 1-1977',
      NULL,
      NULL,
      NULL,
      1.655563,
      0,
      1.639135,
      1.552215,
      1,
      NULL,
      NULL,
      3,
      10,
      9.804759,
      19.856244,
      17.546840,
      2.681553,
      7,
      5.466534,
      2,
      6.283734,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.680034,
      NULL,
      3,
      0.590982,
      1.667979,
      1.891219,
      1.913080,
      1.678328,
      0.443305,
      0,
      0.908653,
      NULL,
      0.671883,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.045961,
      1.035916,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.477561,
      5,
      1.480888,
      1,
      3.239736,
      0,
      1.319141,
      NULL,
      0.359732,
      0.373693,
      1.736751,
      1,
      2.607567,
      0.112508,
      0,
      1,
      1,
      0,
      NULL,
      1.270849,
      0.519658,
      0.718404,
      NULL,
      0.740111,
      0,
      0.152030,
      1.663193,
      1.233121,
      1,
      2,
      1,
      0,
      1.197466,
      2.041644,
      1.704454,
      2.172685,
      1.256132,
      4,
      1,
      4.209122,
      3,
      2,
      1.228716,
      NULL,
      4.070211,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.607946,
      1,
      0,
      0.553842,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.731324,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.172310,
      1.241892,
      4.744261,
      0.435841,
      3,
      1.789241,
      0.447739,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.991892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.245535,
      0.704758,
      NULL,
      NULL,
      NULL,
      1,
      1.995321,
      0,
      NULL,
      1,
      0,
      NULL,
      1511,
      955,
      0.572466,
      1,
      1,
      3,
      NULL,
      0.000842,
      0.620357,
      3.575768,
      2.880175,
      2.643903,
      3.868593,
      2.805021,
      3.555762,
      2.800388,
      2.262642,
      0,
      4.168544,
      1.267718,
      1,
      0.098353,
      0,
      1,
      NULL,
      1.297273,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.052746,
      0.507228,
      6,
      10,
      5,
      1,
      NULL,
      1.604955,
      5,
      1.025744,
      7.072430,
      2.118645,
      2.337570,
      0.357215,
      49.167892,
      3.188252,
      1.852426,
      122,
      NULL,
      NULL,
      NULL,
      0,
      1.624626,
      NULL,
      '04314',
      '',
      NULL,
      0.561693,
      '',
      NULL,
      '',
      2,
      '42312',
      '04114',
      '',
      1.288607,
      4.623119,
      NULL,
      3,
      2.060860,
      39.299968,
      6,
      93.481259,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.790707,
      2.896767,
      3,
      2.590027,
      3.612466,
      0,
      0.290577,
      NULL,
      NULL,
      0.469536,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.046225,
      NULL,
      NULL,
      4.342613,
      NULL,
      0,
      1,
      0.374103,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.421303,
      NULL,
      NULL,
      0.064263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.341049,
      2,
      0,
      1,
      1,
      NULL,
      1,
      4.481948,
      2,
      4.412552,
      3.529598,
      2,
      2,
      0.787451,
      NULL,
      NULL,
      4.639484,
      6,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.639754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.020973,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.112958,
      NULL,
      0.582580,
      5.406832,
      3,
      0,
      5.347472,
      5.706259,
      4,
      6.842241,
      1.325836,
      5,
      0.383066,
      NULL,
      NULL,
      3,
      3.798722,
      2,
      2.830987,
      NULL,
      0.283071,
      NULL,
      3.984791,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3.593648,
      0,
      0.851965,
      3.244972,
      2,
      3,
      2,
      1,
      6,
      NULL,
      2,
      4.033551,
      NULL,
      5,
      0.680043,
      0,
      2.823525,
      1,
      1,
      1,
      1.083082,
      0.367200,
      1.660337,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.321359,
      NULL,
      NULL,
      0.671266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.607353,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1.157206,
      3,
      1,
      4,
      NULL,
      0.921204,
      4,
      4.234702,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.723658,
      NULL,
      NULL,
      0.873837,
      0,
      NULL,
      0,
      2.235188,
      0.166773,
      NULL,
      NULL,
      0.153702,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.345896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.757612,
      0,
      NULL,
      1,
      1.184568,
      1,
      NULL,
      0,
      0.618107,
      NULL,
      NULL,
      1.458819,
      0.037321,
      1,
      NULL,
      3,
      0.863104,
      1.094145,
      NULL,
      1.903428,
      1.725383,
      1.870104,
      NULL,
      0,
      0,
      3,
      NULL,
      1.841473,
      1.457218,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0.436030,
      NULL,
      1.217386,
      NULL,
      NULL,
      120,
      0.424488,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      97,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      453,
      0.195765,
      533,
      5.378096,
      1.999501,
      0.051560,
      0,
      1.090197,
      1.744026,
      2.264825,
      1,
      0.686084,
      0.838895,
      2.501234,
      1,
      NULL,
      0,
      NULL,
      0.462570,
      0,
      NULL,
      3.143418,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.110528,
      NULL,
      1,
      NULL,
      3,
      NULL,
      81,
      NULL,
      NULL,
      15,
      17,
      1,
      NULL,
      NULL,
      NULL,
      1.052514,
      NULL,
      NULL,
      NULL,
      0.169775,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.323894,
      NULL,
      2,
      NULL,
      3.573282,
      NULL,
      NULL,
      NULL,
      0.513839,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.544975,
      NULL,
      1.105360,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.839940,
      0.211097,
      NULL,
      2,
      1.966325,
      1.299109,
      NULL,
      1.695254,
      1.197133,
      2,
      1,
      1.284106,
      0,
      NULL,
      NULL,
      1.372391,
      1,
      NULL,
      0,
      0,
      1.666872,
      1.080746,
      0,
      0,
      NULL,
      0,
      NULL,
      3.203283,
      1,
      2,
      3,
      1,
      1.716455,
      0,
      NULL,
      1,
      2,
      1.170293,
      0.925888,
      0.967247,
      1.817044,
      1,
      1.385182,
      2,
      2.779653,
      0.753607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.609706,
      0.822484,
      NULL,
      0.761232,
      NULL,
      0.831376,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.840232,
      NULL,
      2.270146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.204873,
      NULL,
      0,
      NULL,
      1.034781,
      19.278695,
      3,
      NULL,
      1.068705,
      NULL,
      0,
      NULL,
      0.293750,
      0,
      5.850328,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987862,
      0.952267,
      2.125673,
      '03004',
      '20143',
      '',
      NULL,
      '',
      '',
      '',
      2.181893,
      '24420',
      NULL,
      '');
commit;
end;
/


