set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9001593';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '2203440',
      0.861000,
      1.092468,
      3,
      NULL,
      '3244',
      3.285609,
      1.417877,
      NULL,
      NULL,
      ' 5- 5-1978',
      42,
      NULL,
      3,
      0,
      1.646430,
      ' 9-22-2001',
      24.710364,
      0.070387,
      76.173969,
      NULL,
      0,
      NULL,
      ' 9-12-1998',
      ' 3-11-1993',
      0.397990,
      0,
      0,
      3.192004,
      1,
      1.299463,
      3,
      0,
      1,
      185,
      5,
      9,
      3.786136,
      1,
      19.807553,
      7.975798,
      6.265920,
      1,
      0.449546,
      NULL,
      NULL,
      0.991267,
      0.519514,
      1.518679,
      NULL,
      NULL,
      1.973766,
      1,
      0,
      NULL,
      1,
      3,
      1,
      0,
      NULL,
      0.081626,
      0.496646,
      1,
      1,
      1.784418,
      1.083211,
      NULL,
      NULL,
      1.018237,
      1,
      NULL,
      1.368143,
      3.947430,
      1,
      2.401134,
      1.602502,
      3.650187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.724165,
      NULL,
      2,
      1,
      0,
      3,
      3.162792,
      3,
      1.293244,
      3,
      NULL,
      1,
      3,
      0,
      1.471975,
      NULL,
      3,
      0.175038,
      NULL,
      0,
      0,
      NULL,
      1.915373,
      3.396111,
      2,
      1,
      NULL,
      NULL,
      0.190720,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.168034,
      5,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.508740,
      1.546114,
      0,
      0.583192,
      1.863671,
      NULL,
      NULL,
      0.538795,
      1,
      1.150579,
      NULL,
      NULL,
      5.780529,
      0,
      0,
      0.299724,
      NULL,
      1.804701,
      2.776727,
      2,
      0.036312,
      NULL,
      3.829464,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.989927,
      0.124817,
      1,
      3,
      ' 3-19-2001',
      20,
      '11- 9-1994',
      31,
      1,
      1,
      1,
      1.376920,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.160594,
      1,
      NULL,
      0.728433,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.958938,
      1.144902,
      0,
      1.844357,
      2,
      9.019545,
      7.682148,
      NULL,
      NULL,
      1.848332,
      1,
      0,
      1.268144,
      1.218116,
      1.063260,
      6,
      1.919190,
      4,
      1,
      NULL,
      NULL,
      NULL,
      0.377961,
      4,
      0.027266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.994272,
      1.950996,
      0,
      1,
      NULL,
      0.850822,
      1,
      NULL,
      100,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.139599,
      0.165850,
      3.748040,
      3,
      3.604184,
      0.301853,
      2.763641,
      2,
      1.705358,
      2.113973,
      NULL,
      NULL,
      1.614987,
      NULL,
      3.735211,
      NULL,
      0,
      1,
      NULL,
      0.779909,
      NULL,
      0.001092,
      0,
      1,
      0.918420,
      NULL,
      1,
      0,
      0,
      1.686585,
      3.226936,
      1.548870,
      4,
      8.239507,
      NULL,
      10.424855,
      NULL,
      4.751963,
      0,
      0.705944,
      7.440027,
      3,
      2,
      3,
      0.250237,
      NULL,
      1,
      NULL,
      66.533891,
      7.177164,
      83.702375,
      3.925033,
      0,
      0,
      '11310',
      '',
      '',
      NULL,
      '21402',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      0,
      55,
      0.279717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.637609,
      2.078201,
      0.460742,
      NULL,
      NULL,
      1.064407,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.659885,
      NULL,
      NULL,
      1.121014,
      NULL,
      NULL,
      0.731390,
      NULL,
      NULL,
      1.191931,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.884575,
      NULL,
      NULL,
      3.035591,
      1.981776,
      2,
      1,
      1.060866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306457,
      NULL,
      NULL,
      NULL,
      1.529615,
      NULL,
      0,
      0.033015,
      1.046404,
      2,
      1.195125,
      NULL,
      2,
      2.481470,
      NULL,
      3.304926,
      1.656774,
      1.005148,
      0.108212,
      2.079013,
      NULL,
      NULL,
      1,
      NULL,
      3.067054,
      2,
      0.660670,
      3,
      0.438411,
      2.077075,
      1,
      1.718458,
      3,
      1.290928,
      8,
      NULL,
      8,
      1,
      0.154210,
      NULL,
      NULL,
      NULL,
      1.822896,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.136932,
      0.390969,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.202854,
      1.123133,
      0.652853,
      NULL,
      NULL,
      1.276280,
      NULL,
      NULL,
      1.210484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.249997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2.059370,
      0.899986,
      1.726069,
      NULL,
      NULL,
      1,
      4,
      NULL,
      4,
      4,
      0,
      1.046681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.304371,
      1.941834,
      NULL,
      NULL,
      3.582102,
      5,
      2,
      1,
      NULL,
      NULL,
      1,
      2,
      0.141710,
      0,
      NULL,
      NULL,
      0.266449,
      1.720647,
      3,
      NULL,
      6.638178,
      1.474540,
      6.232574,
      6.928117,
      0,
      0.242563,
      NULL,
      6.289435,
      1,
      0.025833,
      0,
      0.914835,
      1.049773,
      3.224940,
      NULL,
      NULL,
      0.392755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.370457,
      NULL,
      NULL,
      1.505610,
      NULL,
      NULL,
      1.484457,
      NULL,
      NULL,
      1.027015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.454919,
      NULL,
      NULL,
      3.306144,
      NULL,
      NULL,
      1,
      NULL,
      0.221736,
      0.973026,
      NULL,
      NULL,
      0.879535,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.084176,
      NULL,
      NULL,
      NULL,
      2.499184,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698614,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.967405,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870732,
      0,
      NULL,
      NULL,
      0.627659,
      0,
      NULL,
      NULL,
      0.699236,
      0.662282,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.117838,
      NULL,
      NULL,
      NULL,
      1.624808,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.944424,
      NULL,
      NULL,
      NULL,
      3,
      2.867600,
      4.224932,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.430744,
      NULL,
      NULL,
      1.473567,
      NULL,
      NULL,
      0.308048,
      NULL,
      NULL,
      1,
      NULL,
      0,
      247.373024,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0.441556,
      0.339463,
      0.959887,
      0.125613,
      1.456009,
      1,
      0.822286,
      1.855893,
      1,
      1,
      1.970248,
      0.395202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.932630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.817581,
      2.294699,
      0,
      1,
      1,
      NULL,
      6,
      0,
      0.707948,
      0,
      1,
      0,
      NULL,
      0,
      1.513438,
      1.093421,
      1.799793,
      0.093625,
      1.767464,
      0,
      1,
      1.714811,
      NULL,
      1,
      NULL,
      0,
      1,
      0.883523,
      3.988118,
      1.851518,
      2,
      1,
      2,
      NULL,
      0,
      1.744553,
      0.700058,
      0.291227,
      NULL,
      0,
      1.757315,
      0.352111,
      0,
      3,
      1.958587,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.373483,
      0.798892,
      1,
      0,
      1,
      1,
      2,
      1.285364,
      NULL,
      NULL,
      NULL,
      NULL,
      55,
      37.326417,
      0.746091,
      0.471980,
      0.624167,
      '40021',
      NULL,
      '',
      NULL,
      '44023',
      '',
      '',
      0.685156,
      NULL,
      '',
      '');
commit;
end;
/


