set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7808199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      3.257362,
      0.520395,
      3,
      1,
      3.363505,
      NULL,
      2.890224,
      '30',
      NULL,
      39,
      13.348768,
      '0023202',
      1.766212,
      0.431260,
      4,
      3,
      '1224',
      0,
      0,
      NULL,
      NULL,
      NULL,
      4,
      150.025235,
      NULL,
      1.591081,
      1,
      ' 5-21-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-13-1996',
      NULL,
      0,
      1.902581,
      NULL,
      0.739496,
      0.931499,
      3,
      2.939562,
      1.857737,
      0.575305,
      13,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.020951,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      5.958280,
      1.621412,
      1,
      NULL,
      6.564273,
      1.140956,
      9.361528,
      0,
      1,
      1.507653,
      1.111340,
      1.549745,
      3.793578,
      0,
      3.536810,
      NULL,
      4.540803,
      1.679816,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.571258,
      0.577711,
      0.938214,
      3,
      2.193638,
      0.293168,
      1,
      0,
      2,
      1.490925,
      1,
      2.352611,
      NULL,
      1,
      0.117140,
      2.284682,
      3.870127,
      3,
      1.554704,
      0,
      NULL,
      NULL,
      11,
      0.154297,
      1,
      1.139237,
      0.687555,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.900771,
      2,
      0,
      0.276711,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.554189,
      1.237258,
      NULL,
      NULL,
      1,
      1.401318,
      0,
      0.432765,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.688150,
      2.380677,
      1.308995,
      NULL,
      4.832931,
      NULL,
      0.852395,
      9,
      4,
      4,
      NULL,
      1,
      1,
      7,
      2.339405,
      6,
      2,
      11.072191,
      NULL,
      NULL,
      7.846640,
      NULL,
      1.500149,
      1,
      3,
      ' 9-19-1985',
      178,
      ' 3-25-1995',
      369.806385,
      1,
      0,
      1.113395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      1,
      NULL,
      5.185486,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.253879,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.494172,
      NULL,
      8,
      1.232684,
      1.732966,
      1.713600,
      1.405026,
      NULL,
      NULL,
      NULL,
      1.378324,
      NULL,
      1.801623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.509970,
      0.924090,
      0.794383,
      0.688912,
      0.333848,
      NULL,
      1.272207,
      NULL,
      9.979759,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.602055,
      2,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.686619,
      3,
      1.173263,
      0,
      0.974586,
      NULL,
      0.003676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6,
      NULL,
      4.961338,
      9,
      2,
      4.991609,
      0,
      4,
      NULL,
      3.933812,
      2,
      NULL,
      0.935294,
      0,
      NULL,
      NULL,
      NULL,
      27,
      5.320062,
      0.376536,
      0.265270,
      '41144',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0.969055,
      NULL,
      NULL,
      1,
      2.502044,
      2,
      1.343110,
      1,
      2.880086,
      2.956919,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      3.066551,
      0,
      2.984819,
      0,
      0.265789,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.005639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.187363,
      0.091197,
      1,
      0,
      NULL,
      NULL,
      6,
      7,
      5.117595,
      0,
      0.547755,
      NULL,
      NULL,
      NULL,
      1.954368,
      NULL,
      NULL,
      NULL,
      3.480011,
      2.272476,
      2.891643,
      0,
      NULL,
      NULL,
      1.972188,
      NULL,
      NULL,
      0.437870,
      NULL,
      1.263752,
      1.620882,
      1.250141,
      NULL,
      1.411027,
      1.283789,
      2.248675,
      0,
      1,
      NULL,
      2,
      2,
      2,
      NULL,
      0.829780,
      NULL,
      NULL,
      0.968338,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4.123171,
      7.821412,
      0,
      0.767934,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.727081,
      NULL,
      NULL,
      0,
      3.255648,
      0,
      1.357306,
      1.321775,
      2.600296,
      3,
      3.896563,
      3,
      1,
      0.688862,
      1.468652,
      0.735457,
      2.514983,
      1,
      0.510010,
      NULL,
      NULL,
      4,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.370082,
      NULL,
      NULL,
      0.268649,
      NULL,
      NULL,
      1.499310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.742470,
      5.134407,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.800527,
      3,
      3.285159,
      1.830433,
      1.062843,
      3.988548,
      2.477426,
      NULL,
      1,
      0.638013,
      2,
      NULL,
      NULL,
      0.557506,
      3,
      NULL,
      NULL,
      0.942423,
      1.887615,
      NULL,
      1.064946,
      2,
      NULL,
      NULL,
      2.153132,
      NULL,
      NULL,
      0.381697,
      2.153002,
      5,
      0.710243,
      1,
      NULL,
      NULL,
      0,
      1.812345,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.899980,
      NULL,
      NULL,
      0.414496,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769289,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.718500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.622561,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.529618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.839241,
      3.610108,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.888094,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770370,
      NULL,
      1,
      NULL,
      1.822083,
      NULL,
      1.774041,
      1.105853,
      NULL,
      0.408490,
      0.603828,
      NULL,
      1.811044,
      1,
      NULL,
      0.144269,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.484642,
      1,
      NULL,
      0,
      1.823667,
      NULL,
      0,
      0,
      NULL,
      0.381649,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.071536,
      NULL,
      0.293965,
      NULL,
      1,
      NULL,
      1.090630,
      7.360269,
      5,
      NULL,
      0,
      0,
      30,
      70,
      0.398605,
      NULL,
      3,
      NULL,
      '',
      '',
      0.978726,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


