set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7607063';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01',
      NULL,
      NULL,
      37,
      NULL,
      2.902125,
      1.257306,
      1,
      1,
      '1200',
      5.581910,
      0,
      NULL,
      NULL,
      '11-21-1999',
      NULL,
      152,
      NULL,
      NULL,
      1.538477,
      '10-28-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      1.468638,
      NULL,
      NULL,
      ' 9-11-2001',
      NULL,
      1.448269,
      1.347766,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.689476,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4.779586,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9,
      1.613393,
      2.131455,
      0.493383,
      NULL,
      4.257204,
      0.214445,
      4,
      NULL,
      1.386208,
      0.174060,
      0.429013,
      NULL,
      1.985119,
      4.297037,
      1.402839,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.534078,
      NULL,
      0.498302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.857824,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248530,
      0.331092,
      0.501736,
      6,
      NULL,
      5,
      2,
      1,
      NULL,
      0.317036,
      0,
      1.440700,
      0,
      4.536138,
      0.309328,
      1.086374,
      1.281182,
      0.270361,
      1.455044,
      NULL,
      NULL,
      0,
      5.234238,
      0,
      4.661943,
      1.461845,
      1,
      3.223349,
      0.302172,
      3,
      7.555072,
      9.960444,
      NULL,
      3.160791,
      0.299082,
      4.031310,
      7,
      0,
      NULL,
      0.532104,
      8.413759,
      1,
      1.501666,
      7,
      0,
      2,
      3,
      0,
      NULL,
      72.919421,
      ' 3-21-1975',
      372,
      1,
      1.710154,
      NULL,
      3.668027,
      1.279911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.260132,
      1.092962,
      1,
      0,
      1,
      2,
      3.655406,
      NULL,
      0.634393,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.948290,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.617038,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499057,
      0.252683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425871,
      0.358705,
      NULL,
      0.972709,
      0,
      0.595960,
      NULL,
      NULL,
      NULL,
      2.664496,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751038,
      0.587468,
      1.042239,
      0,
      1,
      NULL,
      1,
      2,
      3.459503,
      3.804474,
      NULL,
      2.171478,
      1.719015,
      1,
      0.779074,
      3.828111,
      0.077911,
      3.290447,
      0,
      0,
      NULL,
      0.863165,
      0.473248,
      1,
      NULL,
      1.774682,
      1.871852,
      1.843272,
      NULL,
      NULL,
      1,
      0,
      10.265037,
      0,
      7.037018,
      7.232653,
      3,
      1,
      NULL,
      1,
      5.546193,
      1,
      2.256413,
      2.095390,
      14,
      2.446381,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.496860,
      NULL,
      '',
      '',
      2,
      '04423',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      NULL,
      601.083014,
      2.361980,
      1.733117,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0.509670,
      NULL,
      NULL,
      0.545156,
      NULL,
      NULL,
      1.575542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3.436102,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.520663,
      0.694856,
      2,
      1.982933,
      0,
      2.886451,
      1.355877,
      0.933870,
      5.965537,
      2.775571,
      3.224743,
      1.755753,
      0.424480,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.454470,
      1.673004,
      1,
      0.990593,
      NULL,
      NULL,
      0.151676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421430,
      NULL,
      NULL,
      2.083432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.701923,
      2,
      0,
      1.147000,
      1,
      NULL,
      NULL,
      2,
      0.632103,
      1,
      6.902063,
      NULL,
      0.056083,
      1.582674,
      1,
      0.004711,
      1.859542,
      NULL,
      NULL,
      6.848594,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793595,
      NULL,
      NULL,
      2.213696,
      3,
      2.405944,
      0,
      2.627717,
      NULL,
      4.215145,
      2.217616,
      NULL,
      5.564629,
      0.056063,
      4,
      1.142717,
      NULL,
      NULL,
      3.797190,
      3.831353,
      1.288959,
      1,
      NULL,
      0.623082,
      2.308655,
      2,
      2.785266,
      6.799889,
      0,
      2.263137,
      0.774763,
      NULL,
      2.928569,
      2,
      3,
      0.562107,
      3.590173,
      NULL,
      2.854244,
      2,
      1,
      0,
      7,
      5,
      NULL,
      1.515977,
      0.626277,
      0.995268,
      NULL,
      NULL,
      NULL,
      1.316546,
      0.634850,
      0.063016,
      0.077252,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.141611,
      NULL,
      NULL,
      1.065890,
      NULL,
      NULL,
      1.218761,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.829785,
      1.651109,
      0,
      3.423434,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.805402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.160269,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.755836,
      NULL,
      NULL,
      NULL,
      2.056288,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.710997,
      NULL,
      NULL,
      NULL,
      3,
      0.837583,
      0,
      0,
      NULL,
      NULL,
      1.293644,
      NULL,
      NULL,
      1.306638,
      NULL,
      NULL,
      1.063208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.911880,
      0.508387,
      1.677588,
      1.131831,
      1.909918,
      0,
      0,
      0.228596,
      NULL,
      NULL,
      0.432791,
      0.023359,
      0,
      NULL,
      1.355745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.936613,
      2,
      0.312746,
      2,
      3,
      2.701387,
      2,
      NULL,
      1.202526,
      0.593246,
      1.490238,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.674928,
      NULL,
      1,
      1.677413,
      NULL,
      0,
      1,
      NULL,
      0.170878,
      1.064326,
      NULL,
      NULL,
      2,
      NULL,
      0.658282,
      0.772407,
      NULL,
      NULL,
      0.927114,
      NULL,
      3.715537,
      2.860535,
      NULL,
      NULL,
      2.513528,
      NULL,
      0.913615,
      1.575931,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.597024,
      NULL,
      1.125900,
      NULL,
      1,
      NULL,
      7.142415,
      0.524283,
      9.873393,
      0,
      NULL,
      NULL,
      37,
      NULL,
      3,
      3.875706,
      2.799468,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.629759,
      '',
      '',
      NULL);
commit;
end;
/


