set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-6-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '4041120',
      0,
      1,
      4,
      NULL,
      '3301',
      0,
      1,
      NULL,
      NULL,
      ' 4-23-1985',
      32.350398,
      NULL,
      0,
      3.868625,
      NULL,
      ' 8-14-1994',
      25,
      1,
      NULL,
      28,
      NULL,
      '11-21-1997',
      ' 2-14-1994',
      '11-24-1999',
      3.181898,
      1,
      3.703023,
      1.205697,
      1.659104,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      7,
      25,
      25.559999,
      0,
      10,
      NULL,
      NULL,
      3,
      3.412913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.911257,
      NULL,
      1,
      10.458490,
      0,
      7,
      9.308311,
      NULL,
      2,
      10,
      3.675501,
      NULL,
      1.858275,
      6.464646,
      6,
      NULL,
      1,
      NULL,
      3.275507,
      3.287284,
      NULL,
      NULL,
      NULL,
      1.832261,
      NULL,
      NULL,
      9.572681,
      NULL,
      5,
      3,
      3,
      3,
      0.958338,
      1.806276,
      1,
      0.319906,
      NULL,
      2.876081,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.955351,
      6.435913,
      NULL,
      1.430124,
      11.244790,
      0.618183,
      NULL,
      2.346739,
      1.969765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.210650,
      0,
      3.511747,
      NULL,
      NULL,
      5.625900,
      1,
      0.616514,
      0,
      NULL,
      4,
      1.300866,
      3.976641,
      1,
      1,
      NULL,
      1.962451,
      0,
      NULL,
      1,
      NULL,
      1.232710,
      3,
      0.827800,
      0,
      7.000711,
      NULL,
      1.698518,
      0.355752,
      4.825688,
      9,
      7.673738,
      10,
      NULL,
      1.866831,
      9,
      1,
      6.819089,
      6.860587,
      2.788257,
      NULL,
      4.683895,
      1.222466,
      3,
      9.045565,
      5,
      2.047217,
      ' 5-20-1982',
      6.528481,
      ' 9-11-1979',
      17,
      2.377046,
      NULL,
      0.937198,
      1.683023,
      0.998551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.468379,
      1,
      0.186218,
      1.680276,
      1.388099,
      1.332917,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.972615,
      6,
      NULL,
      3,
      NULL,
      2.446095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.677492,
      6.758431,
      5.809747,
      6.700458,
      7.238921,
      0.798637,
      0,
      2.764598,
      4.680413,
      1,
      5.328466,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.051218,
      0,
      0,
      1.732878,
      0.841836,
      0,
      1,
      2.722390,
      51.822554,
      1,
      1.707734,
      NULL,
      NULL,
      NULL,
      3,
      0.881968,
      3,
      1,
      3.627867,
      3,
      1,
      2,
      1,
      1,
      1.934027,
      3,
      1.163201,
      1,
      0.223711,
      1.259407,
      45.704799,
      127,
      NULL,
      2,
      NULL,
      0,
      1.879937,
      0,
      1.486245,
      1,
      0,
      0,
      0.481138,
      0,
      NULL,
      1,
      9.222442,
      9.227004,
      7.662885,
      0.367566,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      2.641086,
      NULL,
      36,
      NULL,
      30,
      NULL,
      0,
      2.425415,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.234125,
      '',
      NULL,
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.652912,
      5.534419,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.328724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      23.658673,
      1,
      0,
      NULL,
      0.885179,
      1.618280,
      0,
      NULL,
      NULL,
      1.959242,
      0.032361,
      1.107313,
      1.600613,
      0,
      1,
      0,
      NULL,
      NULL,
      1.807435,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.916772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3.926227,
      4,
      11.312558,
      5,
      2.287994,
      1.562520,
      5,
      2,
      2.903129,
      2.509592,
      0,
      NULL,
      2.652738,
      NULL,
      0,
      1,
      NULL,
      1.845305,
      1.156016,
      NULL,
      1,
      0.950843,
      NULL,
      2,
      3,
      NULL,
      3.058008,
      3.846690,
      NULL,
      2.974418,
      2,
      NULL,
      1.072116,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.094410,
      NULL,
      1,
      1.646172,
      NULL,
      NULL,
      0.502783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.875325,
      NULL,
      3.850163,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.627719,
      NULL,
      1.891449,
      NULL,
      3.112113,
      NULL,
      NULL,
      2,
      NULL,
      1.546544,
      NULL,
      2.774776,
      NULL,
      1,
      NULL,
      0.995141,
      7,
      5.351294,
      1.585335,
      NULL,
      NULL,
      84.953692,
      89,
      3,
      NULL,
      2.905147,
      '13314',
      '',
      '',
      1.114990,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


