set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9883245';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      0.963024,
      0.041774,
      3.019770,
      2.219355,
      0,
      0.226137,
      0.231174,
      NULL,
      '20004402',
      11.624484,
      NULL,
      NULL,
      3,
      1,
      2,
      0,
      '4243',
      1,
      0.278638,
      NULL,
      NULL,
      ' 8-14-1994',
      26,
      NULL,
      NULL,
      2.197072,
      1.380184,
      '11-17-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-24-1982',
      ' 5-26-1975',
      1,
      0.643157,
      2.526934,
      2.269987,
      1.921392,
      2,
      NULL,
      NULL,
      NULL,
      25.739658,
      8.636784,
      9.763253,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0.415276,
      2.158177,
      NULL,
      1,
      1.877088,
      1.309333,
      0,
      0.997346,
      0,
      0,
      0.786196,
      0,
      NULL,
      0.547901,
      1.912198,
      2,
      1,
      1.235556,
      NULL,
      0,
      0,
      1.724045,
      NULL,
      NULL,
      NULL,
      0.988017,
      1.069307,
      NULL,
      1,
      1.723440,
      4.429692,
      0.463804,
      0,
      0.118037,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.224754,
      5.636974,
      4,
      2.046411,
      0.743104,
      1,
      NULL,
      1.490898,
      NULL,
      1.340346,
      3,
      NULL,
      0,
      1.530778,
      2.729517,
      0,
      2.570978,
      1.202648,
      NULL,
      1,
      0.740334,
      NULL,
      NULL,
      NULL,
      2.442539,
      1,
      NULL,
      NULL,
      NULL,
      1.768886,
      NULL,
      NULL,
      0.261991,
      4.900039,
      0,
      0,
      5,
      1,
      1,
      NULL,
      NULL,
      0.058003,
      1.999745,
      1,
      NULL,
      0,
      0.679831,
      NULL,
      1,
      1,
      1.669006,
      NULL,
      0.892397,
      0.095902,
      1.320525,
      1.893824,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1.028765,
      0,
      0,
      1,
      1,
      0.311966,
      2,
      0,
      5,
      1.491357,
      3.614573,
      1,
      2.838927,
      4.555676,
      2.410256,
      3.994247,
      NULL,
      2,
      '11-22-2003',
      NULL,
      ' 0- 2-1978',
      68,
      2.486305,
      1,
      0,
      8.931082,
      1.225824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.381456,
      0.720012,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      12,
      2,
      NULL,
      1.578053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1.111798,
      NULL,
      NULL,
      NULL,
      0.014508,
      0,
      1.592619,
      7.511211,
      1,
      6,
      6.643190,
      0.034691,
      NULL,
      NULL,
      0.649278,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.274708,
      0,
      1.585836,
      1.338321,
      0,
      0,
      0,
      3.379278,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051045,
      NULL,
      3,
      3,
      0.740034,
      2.399742,
      2.824333,
      3.556503,
      0.430222,
      2.228035,
      2.081667,
      1.268122,
      NULL,
      3,
      2,
      0,
      1,
      NULL,
      0.980561,
      0.529264,
      0,
      0,
      1.117902,
      1.154226,
      1.844007,
      1,
      0.289236,
      1.788194,
      2,
      1.535267,
      10.271034,
      6.277916,
      0.684103,
      3,
      9,
      3.475574,
      5,
      1.904466,
      NULL,
      NULL,
      1.655414,
      2,
      28,
      NULL,
      NULL,
      16.629613,
      NULL,
      47,
      51.354198,
      1,
      NULL,
      2,
      '14434',
      '',
      '',
      0.321098,
      '',
      '',
      '',
      NULL,
      '13422',
      NULL,
      '',
      NULL,
      10,
      29,
      4,
      NULL,
      36,
      NULL,
      7.239944,
      NULL,
      NULL,
      2.927740,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.359695,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.874714,
      NULL,
      NULL,
      3.259585,
      3.348486,
      0.273679,
      1,
      NULL,
      NULL,
      1.543055,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.500025,
      NULL,
      NULL,
      1.049249,
      0.445964,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3.647708,
      0.833509,
      NULL,
      1.325908,
      1,
      1,
      0,
      1.194470,
      3.350427,
      1.324516,
      NULL,
      3,
      0,
      2,
      NULL,
      1.230922,
      0,
      3,
      1,
      NULL,
      0.731888,
      1,
      NULL,
      2.330685,
      1.727627,
      0,
      3,
      3,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.616002,
      3,
      6.104149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345166,
      0,
      NULL,
      2,
      1.414639,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      6.426249,
      NULL,
      0.209561,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.453726,
      NULL,
      NULL,
      0.413138,
      NULL,
      NULL,
      1.018507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.857209,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807328,
      NULL,
      NULL,
      0.948295,
      NULL,
      NULL,
      1.836799,
      NULL,
      NULL,
      2.571032,
      5.385239,
      1,
      0.140866,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.451627,
      1,
      3,
      1,
      NULL,
      NULL,
      6,
      2.100333,
      1,
      1,
      0.712481,
      0.214602,
      0.082063,
      1,
      1.874562,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      7.205726,
      NULL,
      NULL,
      6.884160,
      2,
      0,
      NULL,
      0,
      4.292858,
      0.811436,
      1.985534,
      1,
      NULL,
      0.965317,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.043317,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      3.402549,
      3.003846,
      NULL,
      4.982197,
      NULL,
      2.859305,
      NULL,
      NULL,
      6.304634,
      219,
      NULL,
      3,
      2,
      1,
      NULL,
      NULL,
      3.160657,
      NULL,
      NULL,
      1,
      0.012819,
      0.307877,
      NULL,
      0.749655,
      NULL,
      NULL,
      NULL,
      3.340305,
      NULL,
      NULL,
      NULL,
      NULL,
      1.147227,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      2.824244,
      1,
      NULL,
      NULL,
      1.333554,
      1.153485,
      0,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0.784848,
      0.294643,
      1.729645,
      NULL,
      1.903901,
      0.236971,
      NULL,
      NULL,
      NULL,
      2.505925,
      1,
      NULL,
      0.396062,
      1,
      1.025957,
      NULL,
      0,
      0.711975,
      0,
      NULL,
      NULL,
      0,
      1.338560,
      NULL,
      1,
      NULL,
      3.621755,
      NULL,
      4,
      8,
      9.995274,
      NULL,
      2.732920,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3.553322,
      29,
      16,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.472006,
      1,
      0.822288,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.241625,
      0.093499,
      NULL,
      NULL,
      NULL,
      0,
      1.870217,
      1.798173,
      NULL,
      NULL,
      0.937034,
      0.953557,
      1,
      1,
      1.496517,
      0,
      0.806944,
      1,
      1.063782,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.216517,
      1.565613,
      1,
      0.317085,
      NULL,
      0.228341,
      2,
      0.925159,
      NULL,
      NULL,
      0.973194,
      NULL,
      1,
      0.208958,
      NULL,
      1,
      1.361914,
      NULL,
      0.279036,
      0.896780,
      NULL,
      0.490384,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.459994,
      NULL,
      0.458025,
      NULL,
      NULL,
      1.004044,
      0,
      NULL,
      1,
      0,
      NULL,
      0.646238,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.616128,
      NULL,
      0.968035,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.398499,
      1.878205,
      NULL,
      NULL,
      67,
      29.152426,
      1,
      2,
      1,
      '31332',
      '',
      '',
      1,
      '',
      '',
      '',
      1.938664,
      '03134',
      '',
      '');
commit;
end;
/


