set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8914693';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '1032040',
      0.202823,
      0,
      1,
      NULL,
      NULL,
      3,
      0.409087,
      NULL,
      NULL,
      ' 8- 9-2002',
      28,
      NULL,
      NULL,
      2,
      0.229691,
      ' 9- 5-1986',
      37.665922,
      2,
      1137,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-11-1994',
      0,
      1,
      2.048024,
      1.252380,
      1.829757,
      2.986028,
      3,
      1.420226,
      1.525105,
      133,
      1,
      NULL,
      7.189665,
      NULL,
      7,
      3.486622,
      NULL,
      4.340107,
      2.632701,
      NULL,
      0,
      0,
      0.613235,
      1,
      NULL,
      1.175866,
      NULL,
      0.987455,
      NULL,
      1.534266,
      60,
      9.342992,
      0,
      5,
      1,
      1,
      NULL,
      0,
      1.235853,
      1,
      0.715044,
      0.367702,
      0,
      0,
      NULL,
      0.370837,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.960300,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.498391,
      0.417991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.379957,
      3,
      1.573426,
      0,
      1.952539,
      NULL,
      0.187044,
      1,
      1.476813,
      0,
      0,
      1.473076,
      NULL,
      0,
      0.435489,
      0.608975,
      NULL,
      1,
      4.167247,
      1,
      1,
      6,
      0,
      6.284779,
      5.142837,
      0.611375,
      NULL,
      NULL,
      1.249522,
      0.779248,
      3,
      0.177217,
      0,
      NULL,
      0,
      5.072907,
      NULL,
      4.933022,
      6,
      0.227850,
      7,
      6,
      NULL,
      0.477083,
      3.589718,
      ' 7-26-2000',
      1851.275391,
      ' 0- 4-1999',
      1176.109405,
      1,
      0,
      1.123788,
      1.986640,
      1.797562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.629846,
      1,
      2.887809,
      0,
      1.819261,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.082951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.467859,
      NULL,
      1.708142,
      2.778190,
      2.222250,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431867,
      NULL,
      1.201448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0.618453,
      0.919193,
      4939,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      31.863914,
      35.525975,
      3,
      0,
      1,
      '10404',
      '03434',
      NULL,
      0,
      '',
      '',
      NULL,
      1,
      '3143',
      '0040',
      '0001',
      2,
      14,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.832718,
      2.793838,
      NULL,
      1,
      NULL,
      NULL,
      1.644314,
      NULL,
      NULL,
      NULL,
      0,
      1.375924,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.049607,
      NULL,
      NULL,
      2.050670,
      0.171748,
      0,
      0.957207,
      NULL,
      NULL,
      1.872502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.940824,
      2.922799,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149368,
      0,
      NULL,
      0,
      1.377968,
      0.985932,
      NULL,
      NULL,
      0,
      0.227097,
      1.479794,
      1,
      0,
      0.708907,
      NULL,
      1,
      1,
      1.771966,
      2.373311,
      0.373656,
      1.572659,
      NULL,
      0.724071,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      3,
      0,
      3.561289,
      NULL,
      2.417094,
      NULL,
      NULL,
      NULL,
      NULL,
      9.201790,
      1,
      2,
      NULL,
      NULL,
      2.883750,
      2,
      0,
      NULL,
      7.725009,
      2,
      0,
      NULL,
      NULL,
      1.736848,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.008194,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      1,
      2.110880,
      3.222894,
      0,
      8.173943,
      9.622233,
      2.317246,
      2,
      4.468383,
      NULL,
      3.214925,
      6.456600,
      1.783915,
      0.440603,
      2,
      2,
      1,
      NULL,
      0,
      3,
      NULL,
      1.056066,
      NULL,
      NULL,
      8,
      2,
      0.798403,
      1,
      0,
      NULL,
      0,
      1.980786,
      1.211536,
      1.605155,
      0.043953,
      NULL,
      1.158706,
      1.143816,
      9.156870,
      NULL,
      9,
      9,
      7,
      3,
      3,
      7.666119,
      NULL,
      NULL,
      0,
      NULL,
      1.015958,
      1,
      NULL,
      NULL,
      3.966859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647775,
      NULL,
      NULL,
      3.880360,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      0.008350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.250348,
      NULL,
      NULL,
      NULL,
      2.113574,
      NULL,
      NULL,
      NULL,
      0.446649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.211639,
      NULL,
      NULL,
      NULL,
      0.883187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      1.025953,
      1.738301,
      804.282213,
      147,
      NULL,
      NULL,
      NULL,
      0.679421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3,
      3.135610,
      178,
      NULL,
      14122,
      23.349687,
      1.861174,
      0.935541,
      1,
      1.140367,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.418682,
      1.822800,
      1.973084,
      1.297158,
      1.333600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.055600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.107291,
      1.999182,
      4,
      NULL,
      5.539479,
      4,
      10.273873,
      3,
      3,
      0.805064,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.241198,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2.511692,
      NULL,
      0.291779,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.511823,
      3.295727,
      NULL,
      3.557339,
      2.716678,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.727730,
      NULL,
      3.813933,
      13,
      11.635557,
      0.259397,
      2,
      2.357910,
      25,
      16.934605,
      2.779321,
      1,
      2,
      '01244',
      '22244',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '4110',
      NULL,
      '3001');
commit;
end;
/


