set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3375557';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      2,
      1.346158,
      1.213688,
      NULL,
      2,
      1.745193,
      0,
      '340',
      '31443144',
      59.961722,
      13,
      '1221224',
      1,
      0.369983,
      4,
      2,
      '3032',
      6,
      0.173467,
      NULL,
      NULL,
      NULL,
      20.587907,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.863597,
      ' 1- 0-2003',
      NULL,
      ' 5- 5-1985',
      1.779482,
      0,
      1.506611,
      NULL,
      1.761547,
      NULL,
      2.289382,
      1.067005,
      NULL,
      NULL,
      NULL,
      3.805153,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859519,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.501176,
      0.090910,
      0,
      1,
      0,
      5,
      1.395129,
      NULL,
      1,
      2.365015,
      NULL,
      0.776018,
      1,
      5.868198,
      1.963957,
      5.170231,
      1,
      0.585953,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      3,
      1.281013,
      0.415017,
      NULL,
      0.804928,
      1.580924,
      NULL,
      NULL,
      NULL,
      0,
      0.695889,
      NULL,
      NULL,
      NULL,
      NULL,
      0.176042,
      0,
      NULL,
      NULL,
      1.590172,
      NULL,
      2.120054,
      1,
      1.988368,
      3.068263,
      1,
      NULL,
      NULL,
      0.714423,
      NULL,
      NULL,
      2.764870,
      NULL,
      NULL,
      0,
      NULL,
      0,
      4,
      1.057852,
      NULL,
      1.285761,
      0.150368,
      NULL,
      0.004229,
      6.000465,
      1.514560,
      1.048497,
      1.409717,
      1.099961,
      1.120611,
      NULL,
      1.022477,
      NULL,
      NULL,
      1.680527,
      1,
      1.429677,
      3.541651,
      0.259302,
      9,
      5,
      2,
      7.844603,
      3.133292,
      4.239215,
      1,
      2,
      4,
      7.562901,
      6.319971,
      7,
      0.880733,
      1.934453,
      5,
      2,
      1,
      0.337029,
      4.084265,
      2.574381,
      ' 5-10-1989',
      6,
      ' 8-24-1998',
      8.841651,
      1.221904,
      0,
      0,
      6.554428,
      0.697486,
      3,
      NULL,
      NULL,
      1,
      3,
      0.247069,
      1,
      8,
      9,
      1.064861,
      4,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.231608,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.888359,
      0.413660,
      0.411953,
      NULL,
      NULL,
      NULL,
      0.891006,
      3,
      NULL,
      3,
      NULL,
      1.471265,
      4,
      1.986425,
      NULL,
      NULL,
      NULL,
      9.334765,
      0.974306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.534288,
      0,
      1.116957,
      1.754818,
      0.239186,
      1,
      0.776497,
      3,
      49.744043,
      1,
      1.995287,
      NULL,
      NULL,
      NULL,
      0,
      1.363561,
      0.257300,
      2,
      2,
      NULL,
      2,
      NULL,
      2.870278,
      NULL,
      2.240216,
      3.552214,
      0.639912,
      2.321045,
      3.813788,
      0.991314,
      2,
      NULL,
      0.619450,
      NULL,
      0,
      1,
      0,
      1.468632,
      1.524917,
      0,
      0,
      1.902793,
      1,
      1.607343,
      NULL,
      0.534457,
      2,
      3.772623,
      NULL,
      NULL,
      10.990900,
      NULL,
      5,
      2,
      3,
      3,
      3,
      2,
      56.960490,
      NULL,
      1,
      NULL,
      NULL,
      39.305936,
      81.139004,
      5.213651,
      4.066316,
      NULL,
      '34311',
      NULL,
      '20321',
      NULL,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      0.452295,
      31,
      1.082522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.824098,
      0,
      NULL,
      NULL,
      1.456208,
      NULL,
      NULL,
      NULL,
      0,
      1.045951,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.085643,
      0.411865,
      1.039436,
      1.002426,
      1.878493,
      NULL,
      NULL,
      NULL,
      1,
      0.632073,
      NULL,
      1,
      0,
      1.049048,
      0.956715,
      NULL,
      1,
      NULL,
      0.069851,
      NULL,
      0.768119,
      NULL,
      1,
      NULL,
      1.379677,
      NULL,
      10.013542,
      NULL,
      1,
      NULL,
      7.598930,
      NULL,
      1,
      1,
      NULL,
      0.908684,
      NULL,
      NULL,
      NULL,
      1.012221,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.071270,
      NULL,
      1.878282,
      NULL,
      0,
      NULL,
      1.801414,
      NULL,
      0.311729,
      NULL,
      0,
      NULL,
      1.713482,
      NULL,
      1,
      NULL,
      2,
      1.215410,
      2.221581,
      NULL,
      0.950995,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.167659,
      NULL,
      NULL,
      1.543857,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.820246,
      NULL,
      0.673867,
      NULL,
      NULL,
      0.045490,
      3,
      1,
      1,
      NULL,
      0.730630,
      NULL,
      NULL,
      NULL,
      0,
      1.816137,
      0.085461,
      1,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      0.998959,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.184449,
      NULL,
      0.073281,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.782884,
      0.950287,
      2.414614,
      0,
      1,
      NULL,
      408.363809,
      0,
      NULL,
      0,
      0.715308,
      1,
      0.664128,
      2.511443,
      NULL,
      11,
      NULL,
      NULL,
      1.390020,
      1,
      NULL,
      1,
      0,
      1,
      3,
      3.204400,
      0,
      1.714634,
      0.373565,
      5.436852,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0.586010,
      NULL,
      0,
      1,
      NULL,
      0.506994,
      NULL,
      NULL,
      NULL,
      0.857587,
      NULL,
      1.767380,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371746,
      0,
      NULL,
      0.053422,
      1.933675,
      NULL,
      0.381452,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012112,
      NULL,
      1.951399,
      NULL,
      NULL,
      NULL,
      2.370986,
      5.263461,
      0.987585,
      0,
      NULL,
      NULL,
      83,
      131.311315,
      1.735772,
      5.416654,
      NULL,
      '44014',
      '31341',
      '42204',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


