set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9763902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.052591,
      NULL,
      0.870335,
      1,
      0.373487,
      NULL,
      NULL,
      NULL,
      '403',
      '01032422',
      44.671668,
      8.279946,
      '4224310',
      1.182208,
      1,
      4,
      NULL,
      '3142',
      0.052843,
      NULL,
      NULL,
      NULL,
      ' 5-28-1974',
      11.188027,
      40,
      NULL,
      0,
      NULL,
      ' 6-16-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 9-13-1980',
      ' 7-16-1995',
      ' 7- 6-1986',
      2,
      2.898195,
      3,
      NULL,
      0.958137,
      3,
      2.574400,
      2,
      NULL,
      NULL,
      NULL,
      3.129851,
      1.487761,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.101590,
      NULL,
      1.148923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      7.092013,
      NULL,
      0,
      NULL,
      0,
      3,
      4,
      1,
      NULL,
      0.213571,
      0.338348,
      0.206564,
      NULL,
      1.632196,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.624746,
      4.126989,
      0,
      1,
      3.745803,
      3,
      NULL,
      0.866081,
      0.965117,
      NULL,
      0.683148,
      0.922583,
      1,
      0,
      0.058100,
      1.595658,
      3,
      0,
      NULL,
      0,
      3.910726,
      2.987344,
      NULL,
      0.991390,
      0,
      6,
      1,
      4.500450,
      1.063251,
      1.479161,
      NULL,
      NULL,
      3.275279,
      4.454660,
      0,
      1,
      1,
      NULL,
      0.778857,
      1,
      0.438218,
      NULL,
      NULL,
      1.911177,
      0.204510,
      1.086486,
      1,
      0,
      0.794018,
      0,
      2,
      1.147076,
      0,
      1,
      NULL,
      2.159912,
      NULL,
      0.930029,
      1,
      4,
      0.997203,
      2,
      5.964430,
      4.336449,
      3.705840,
      7.910438,
      0.581697,
      0.773905,
      1,
      1.335910,
      6,
      3.090937,
      7,
      1.283458,
      6.142538,
      6.938787,
      5.287139,
      2.223849,
      8,
      0,
      3.557068,
      4.997425,
      2.631157,
      ' 1- 6-1983',
      NULL,
      '10-15-1981',
      NULL,
      NULL,
      0.769384,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188138,
      1.611599,
      0,
      NULL,
      0.201854,
      1,
      0,
      0.739781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5,
      1,
      3,
      NULL,
      1,
      1,
      3.602164,
      1,
      NULL,
      NULL,
      0,
      1,
      1.482715,
      1,
      3.202103,
      2.131197,
      3.730981,
      4,
      3,
      4,
      2.025027,
      4,
      0,
      NULL,
      NULL,
      3,
      9,
      2,
      0,
      4.703278,
      3.083917,
      NULL,
      ' 5-20-1985',
      20,
      ' 0-27-1992',
      6.099370,
      0.361961,
      0,
      1.127115,
      NULL,
      NULL,
      0.794689,
      0,
      1,
      0,
      1,
      NULL,
      25,
      0.755479,
      1.232605,
      NULL,
      NULL,
      NULL,
      3.352342,
      NULL,
      1.195156,
      2,
      1,
      0.405354,
      0.395168,
      NULL,
      1.846295,
      0,
      3,
      NULL,
      0,
      0.915409,
      2.795780,
      1.504031,
      2.211981,
      1.035658,
      1,
      1,
      NULL,
      0.553294,
      1,
      NULL,
      0,
      0,
      0.406677,
      0.324252,
      1,
      1,
      3.315962,
      0,
      NULL,
      4.959074,
      0,
      2.422278,
      NULL,
      5.711020,
      NULL,
      1.417341,
      2.442922,
      1.547265,
      NULL,
      0.777794,
      9,
      2,
      3.607530,
      24.982043,
      NULL,
      41,
      24,
      1.024318,
      NULL,
      3,
      '13313',
      '',
      '',
      1.891331,
      NULL,
      '',
      '',
      0.853369,
      '',
      NULL,
      NULL,
      1.809651,
      40.059891,
      52,
      50,
      1.846857,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.326220,
      NULL,
      NULL,
      1.762328,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.043161,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579441,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.336170,
      NULL,
      NULL,
      0.332922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.459452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.174040,
      NULL,
      NULL,
      1.037868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.977108,
      NULL,
      NULL,
      0.077463,
      NULL,
      NULL,
      1.665897,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.764762,
      NULL,
      NULL,
      0.958352,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.133202,
      NULL,
      NULL,
      1.307666,
      NULL,
      NULL,
      1.795125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.097751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.111596,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.687662,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.458649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.427527,
      1.284944,
      NULL,
      0.679724,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.387089,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.361045,
      NULL,
      NULL,
      NULL,
      1.121813,
      NULL,
      NULL,
      NULL,
      3.339001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.778945,
      NULL,
      NULL,
      NULL,
      1.634460,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.649676,
      NULL,
      NULL,
      NULL,
      1.984506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.628052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      0.531801,
      NULL,
      0.165873,
      NULL,
      NULL,
      NULL,
      3,
      1.971943,
      0.549608,
      NULL,
      1,
      NULL,
      0.568658,
      NULL,
      NULL,
      1.139271,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      0.390276,
      0.315308,
      1.303039,
      0,
      NULL,
      1,
      0.788501,
      1.492938,
      0.652523,
      0.088437,
      0.372760,
      0,
      NULL,
      0.245482,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3.050896,
      NULL,
      3,
      NULL,
      0.533281,
      4,
      6.172701,
      2.772315,
      2.715919,
      2,
      0.042862,
      NULL,
      NULL,
      1.915193,
      1.083716,
      NULL,
      0.586371,
      NULL,
      1,
      1.699612,
      1,
      0.359505,
      NULL,
      0.886411,
      3,
      1,
      1,
      0,
      NULL,
      0.724003,
      2.115611,
      1.913897,
      1,
      0.768711,
      0.970033,
      0.090325,
      1.379910,
      NULL,
      1,
      0,
      0.783483,
      NULL,
      1.794445,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.593478,
      0,
      1,
      0,
      NULL,
      1,
      1.162663,
      0.697892,
      1.217306,
      0.314074,
      1.006728,
      0.907354,
      0.941807,
      NULL,
      2.656646,
      0,
      3.380084,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.115179,
      0,
      NULL,
      1.403511,
      0.246529,
      39.201740,
      0,
      NULL,
      NULL,
      0,
      1.099073,
      2,
      0,
      0.995564,
      2.479712,
      0.037947,
      4,
      1.107355,
      NULL,
      NULL,
      123.778201,
      9.824861,
      1.342971,
      2,
      NULL,
      '14300',
      '',
      '',
      1.309270,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


