set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9505188';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.861608,
      2.175518,
      2.087197,
      NULL,
      3,
      0.508004,
      3.172463,
      2.848506,
      '013',
      '22032213',
      NULL,
      NULL,
      '3323214',
      0,
      1.729006,
      2,
      NULL,
      '4042',
      0,
      1,
      NULL,
      NULL,
      '11-25-1998',
      70,
      38.040482,
      NULL,
      NULL,
      1.418050,
      ' 7-23-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-23-1989',
      2,
      NULL,
      3,
      NULL,
      1.967987,
      NULL,
      2.237504,
      0.396649,
      NULL,
      62.725365,
      4,
      6.454723,
      5.037757,
      NULL,
      NULL,
      NULL,
      NULL,
      2.348762,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      8,
      0.533987,
      3.224375,
      1,
      1,
      0,
      1,
      0.778965,
      0.795217,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.158176,
      0.212377,
      1.267069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569048,
      0.031183,
      1,
      0.758159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.149360,
      0,
      0.636861,
      0,
      NULL,
      NULL,
      1,
      0.072550,
      1,
      NULL,
      1,
      1.083125,
      NULL,
      NULL,
      NULL,
      2.580659,
      3,
      NULL,
      1,
      1,
      0.063186,
      0,
      1,
      0,
      0.453376,
      0,
      3.737496,
      1,
      NULL,
      0.972241,
      1,
      1.531403,
      3,
      1,
      0.619522,
      5.871503,
      3.583193,
      0.301368,
      0.622551,
      0.553671,
      0.474780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.293243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222318,
      NULL,
      NULL,
      1.120421,
      0,
      1,
      0.947579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.564112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641128,
      NULL,
      2.954658,
      NULL,
      0.791514,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.175513,
      NULL,
      0,
      0.930713,
      0.624691,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.918518,
      NULL,
      2,
      3,
      NULL,
      3.836594,
      2,
      1,
      0.307589,
      NULL,
      1,
      2.763864,
      NULL,
      2,
      0.950335,
      NULL,
      0.873795,
      0,
      NULL,
      1,
      NULL,
      1.689397,
      1.378991,
      1,
      0.825066,
      1.610496,
      NULL,
      1,
      1,
      2,
      0,
      4.875934,
      4.411861,
      NULL,
      6,
      9.130432,
      3,
      2.325458,
      0,
      1.527280,
      NULL,
      0.333135,
      2.986018,
      36.404486,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.615803,
      '10241',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.051193,
      24,
      134.165156,
      4.622720,
      3.283349,
      NULL,
      3.714945,
      1.981472,
      1,
      3.066184,
      3,
      0.185460,
      1.236480,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      0.044612,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.382799,
      NULL,
      3.694390,
      0.976099,
      1,
      1,
      0,
      0,
      0,
      3.622894,
      2,
      1,
      NULL,
      2,
      2,
      0,
      0.033996,
      0.544679,
      2,
      5.576950,
      4,
      0.193690,
      1.891568,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.581298,
      1,
      0.756324,
      NULL,
      0.273999,
      0.915404,
      3.863403,
      0.694821,
      0,
      0,
      1.343250,
      0.576107,
      2.643837,
      0.453631,
      2.796062,
      3,
      2.191217,
      2,
      2.704207,
      0,
      1.167033,
      0.231074,
      2.270962,
      NULL,
      0,
      0.160345,
      1.520341,
      0,
      2.830434,
      0.998157,
      NULL,
      2,
      NULL,
      1.598681,
      0,
      NULL,
      0,
      1.389580,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.296216,
      NULL,
      3,
      3.663232,
      1.498090,
      1.283073,
      NULL,
      NULL,
      1.027954,
      5,
      1.802132,
      NULL,
      NULL,
      3.484598,
      1.737082,
      1.373937,
      0,
      1.589454,
      1.471238,
      4.724204,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.406777,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.838976,
      NULL,
      1.757970,
      0,
      0,
      5.934004,
      3.982831,
      4.470515,
      NULL,
      0,
      4.551393,
      1.388472,
      NULL,
      NULL,
      1.804881,
      1,
      NULL,
      3,
      2.723547,
      NULL,
      2,
      1.592603,
      NULL,
      NULL,
      2.455690,
      3.314987,
      0,
      3,
      2,
      1.732045,
      2.532346,
      2,
      NULL,
      3,
      NULL,
      0.270215,
      NULL,
      2,
      NULL,
      3.926650,
      1,
      0.630567,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0.950597,
      NULL,
      3.261557,
      NULL,
      NULL,
      0.520796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.763061,
      NULL,
      NULL,
      0.286321,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.398157,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.653391,
      0.164947,
      NULL,
      1.786290,
      NULL,
      NULL,
      NULL,
      1.128791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.037399,
      NULL,
      NULL,
      NULL,
      2.096973,
      1.363681,
      NULL,
      NULL,
      0.967234,
      NULL,
      NULL,
      NULL,
      0.264550,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.785685,
      NULL,
      NULL,
      3.984195,
      1.760582,
      NULL,
      NULL,
      1.904334,
      NULL,
      NULL,
      NULL,
      1.398695,
      0,
      NULL,
      NULL,
      NULL,
      1.442257,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      4,
      6.335375,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.390869,
      126.683204,
      7,
      2.398619,
      NULL,
      8,
      1,
      NULL,
      NULL,
      1.885631,
      NULL,
      NULL,
      0.233178,
      NULL,
      NULL,
      0.605746,
      NULL,
      NULL,
      0.339263,
      NULL,
      0.939192,
      33,
      8,
      1.784205,
      0,
      0,
      0.733432,
      1.449567,
      1.080390,
      0.851554,
      1.633078,
      NULL,
      1,
      1,
      0,
      0,
      1.194410,
      0.783530,
      NULL,
      1,
      1.656767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.973192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.590990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.963474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.847210,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418490,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.039726,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.956680,
      NULL,
      NULL,
      NULL,
      1.150925,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.003351,
      4,
      NULL,
      NULL,
      3.500876,
      1.754117,
      1,
      3,
      NULL,
      0.442563,
      NULL,
      3,
      0,
      0.719300,
      NULL,
      0.390836,
      NULL,
      1.707585,
      0,
      2.292993,
      NULL,
      1,
      2.359699,
      1,
      NULL,
      1.190428,
      0,
      NULL,
      1.883473,
      1,
      2.329886,
      3,
      3.655625,
      1.385025,
      2.678603,
      1,
      0.482177,
      0.531774,
      NULL,
      1,
      NULL,
      0,
      0.072283,
      NULL,
      0.368991,
      0.427164,
      3.407309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.135585,
      1.525200,
      0,
      0,
      1.775547,
      3,
      1.658958,
      1.922220,
      0,
      NULL,
      NULL,
      31.289664,
      19,
      2.767991,
      NULL,
      2.512773,
      '11133',
      '',
      '',
      0.545403,
      '',
      NULL,
      '',
      1.336199,
      '',
      '',
      '');
commit;
end;
/


