set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8729166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-7-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '0320403',
      0,
      1.999823,
      NULL,
      1,
      '1002',
      2.097221,
      1.365076,
      NULL,
      NULL,
      ' 1-13-1989',
      8,
      NULL,
      3,
      1.847093,
      NULL,
      '11- 3-1988',
      NULL,
      1,
      11,
      1.541869,
      1.058974,
      NULL,
      ' 7- 3-1985',
      ' 6-13-1993',
      0,
      1,
      3.072514,
      NULL,
      0,
      1,
      NULL,
      3.671999,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      15.839303,
      NULL,
      6.719373,
      7.115822,
      5.951721,
      NULL,
      NULL,
      1.104899,
      3.996015,
      0,
      1,
      0.200137,
      0.499230,
      0,
      NULL,
      0,
      0.788225,
      0,
      2,
      2,
      2.372623,
      0,
      1.894773,
      0,
      NULL,
      3,
      0.205831,
      1,
      0,
      1,
      0.342816,
      NULL,
      0,
      0.221385,
      4.830506,
      0.782191,
      NULL,
      NULL,
      0.637987,
      1.032791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.471236,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432116,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.717112,
      0,
      1.661341,
      0,
      NULL,
      NULL,
      NULL,
      1.635297,
      0,
      0,
      0,
      1.857808,
      0.153384,
      0,
      0,
      1,
      0.930517,
      NULL,
      0.986578,
      5,
      1,
      1,
      1.901931,
      NULL,
      0,
      2.160614,
      2,
      1.277352,
      0,
      3.777194,
      1,
      1,
      NULL,
      1.421673,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      2,
      4,
      9.175706,
      0.194925,
      0.906583,
      NULL,
      0.496251,
      NULL,
      64.320330,
      ' 7-23-1981',
      13.890293,
      2.720550,
      0,
      NULL,
      0.914242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.763280,
      1.720973,
      0,
      1.532146,
      1.959589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121947,
      1.915354,
      0,
      1.366918,
      1.441256,
      1.778741,
      1,
      NULL,
      NULL,
      NULL,
      0.894417,
      1.450089,
      0.413524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.666531,
      0.626655,
      1,
      1,
      1,
      1,
      0,
      NULL,
      25.653899,
      3.098028,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      5.578504,
      2.497313,
      3,
      NULL,
      2.388746,
      NULL,
      NULL,
      NULL,
      NULL,
      5.156632,
      4.215914,
      NULL,
      18.772943,
      130,
      26,
      NULL,
      94.774798,
      0,
      1,
      1,
      1.152554,
      1,
      0,
      NULL,
      6,
      19,
      0.999723,
      2,
      0,
      2,
      NULL,
      4,
      5,
      0,
      2.916791,
      2,
      1,
      3.919152,
      NULL,
      NULL,
      1.755890,
      1,
      NULL,
      9,
      2,
      11.873967,
      1,
      0.353844,
      1,
      '12303',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      3.812951,
      46,
      29,
      1.842826,
      NULL,
      57,
      2.569316,
      2,
      NULL,
      NULL,
      3.148990,
      NULL,
      0.281479,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.808178,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.114101,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.457079,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.609467,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.151330,
      NULL,
      NULL,
      0.121630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.394578,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.257058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.152682,
      NULL,
      2.901236,
      3,
      NULL,
      0.379235,
      NULL,
      NULL,
      7,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1.731199,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.420580,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.688869,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.877067,
      NULL,
      0,
      NULL,
      NULL,
      2.406557,
      6.144794,
      1,
      3,
      3.087494,
      2,
      0.362382,
      NULL,
      NULL,
      0.476550,
      NULL,
      NULL,
      0.735334,
      NULL,
      0.758881,
      1.498728,
      NULL,
      NULL,
      7,
      0.823191,
      NULL,
      NULL,
      3.935348,
      2.293107,
      NULL,
      NULL,
      NULL,
      2.796894,
      NULL,
      2,
      NULL,
      1,
      2,
      5,
      8.844822,
      1.921857,
      0.814709,
      NULL,
      NULL,
      1,
      2.230463,
      NULL,
      1.337438,
      0.177235,
      1.429533,
      0,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.162190,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.508784,
      1,
      0,
      1.948973,
      0.336184,
      NULL,
      NULL,
      1.284117,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897327,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.971799,
      NULL,
      NULL,
      1,
      0.048429,
      NULL,
      NULL,
      0,
      1.601280,
      NULL,
      NULL,
      0.082141,
      0,
      NULL,
      NULL,
      1,
      1.546376,
      NULL,
      NULL,
      1,
      1.373529,
      NULL,
      NULL,
      NULL,
      1.379028,
      NULL,
      NULL,
      1,
      0.927117,
      NULL,
      NULL,
      1.703398,
      NULL,
      NULL,
      NULL,
      2.209766,
      7.494881,
      2,
      1,
      NULL,
      NULL,
      1.757107,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.465547,
      NULL,
      NULL,
      1.244021,
      NULL,
      NULL,
      1,
      NULL,
      0.922846,
      151.408758,
      163,
      NULL,
      0.540935,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.223205,
      NULL,
      0.088582,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.994164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.059530,
      0.456195,
      NULL,
      NULL,
      5.663462,
      5.723090,
      4,
      2.148056,
      NULL,
      2.678953,
      1.779387,
      2.430670,
      0,
      0.112090,
      0,
      NULL,
      1.144634,
      0.731912,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0.963975,
      NULL,
      0.608489,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.628912,
      NULL,
      0,
      0.216655,
      0,
      1.447302,
      NULL,
      0.272264,
      1,
      0.772267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.469492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.208384,
      NULL,
      1.789613,
      1,
      0,
      1,
      2,
      3,
      NULL,
      0,
      3.814139,
      3,
      13,
      51.881947,
      4.662137,
      NULL,
      2,
      '32204',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1.799054,
      '',
      '',
      '');
commit;
end;
/


