set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038596';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '4132422',
      2,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0.256321,
      NULL,
      NULL,
      ' 3-26-1983',
      34,
      NULL,
      6,
      1,
      1.802453,
      NULL,
      NULL,
      1.651496,
      315,
      48.351897,
      1,
      ' 0-20-1994',
      ' 9- 6-1983',
      NULL,
      0.787764,
      0,
      1.604747,
      NULL,
      NULL,
      0.444714,
      1.763451,
      1,
      1.663999,
      25.018572,
      3.646156,
      0,
      6,
      4.108714,
      7.446879,
      8,
      14,
      8.936663,
      0,
      7.247042,
      0,
      5.994297,
      NULL,
      1,
      1,
      1,
      0.397839,
      0.231414,
      1.464696,
      NULL,
      NULL,
      3,
      0,
      5.773222,
      2,
      NULL,
      0.425153,
      0.002732,
      5.294576,
      1.514458,
      5,
      NULL,
      0.190135,
      2.547209,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      3.412498,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.873810,
      NULL,
      3.971927,
      0,
      1.155445,
      0.591430,
      1.891088,
      NULL,
      1,
      1,
      NULL,
      1,
      0.062067,
      0.603948,
      0,
      1,
      0.396105,
      0,
      3.226017,
      NULL,
      3,
      7,
      1.058158,
      NULL,
      NULL,
      0.339109,
      NULL,
      NULL,
      0.121528,
      NULL,
      NULL,
      1.902527,
      1,
      0.180989,
      0,
      2,
      6.445190,
      9.905512,
      1.134360,
      0.548242,
      4,
      0.353020,
      1,
      1.767505,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850209,
      1.768031,
      NULL,
      1,
      NULL,
      7,
      0.219627,
      NULL,
      0,
      7.400080,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.206643,
      NULL,
      0,
      3.696968,
      5,
      9,
      6,
      9.780929,
      5,
      5,
      5.801116,
      2.362151,
      5,
      6.320336,
      1,
      ' 5- 9-1992',
      742,
      ' 1-12-1999',
      520,
      1,
      NULL,
      0,
      7.677076,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4.414943,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.466064,
      1.888238,
      9,
      3,
      1.975560,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1.873389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.794733,
      1,
      NULL,
      0.210862,
      0,
      1,
      1,
      1,
      96,
      NULL,
      1.714345,
      NULL,
      NULL,
      NULL,
      1.253826,
      0.272059,
      NULL,
      3.925180,
      1.959162,
      0,
      0.407936,
      3,
      0,
      1,
      1,
      3,
      NULL,
      1.827340,
      NULL,
      2,
      1.412421,
      0.790060,
      0,
      6,
      2,
      1,
      NULL,
      0.799801,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.360787,
      3,
      NULL,
      2,
      NULL,
      6.035434,
      2,
      1,
      2,
      19,
      1,
      0,
      NULL,
      NULL,
      19,
      69,
      NULL,
      0.057831,
      6,
      '04410',
      '13131',
      '14102',
      1.665161,
      '14121',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      8.402310,
      25.348985,
      5.418098,
      2.004593,
      6,
      5.854839,
      1.295152,
      1,
      3,
      0.700088,
      1.342646,
      1,
      NULL,
      NULL,
      1.956662,
      NULL,
      NULL,
      NULL,
      1.644746,
      1,
      1.664871,
      NULL,
      NULL,
      1.343480,
      0.998148,
      2.880026,
      2,
      2,
      0,
      1,
      NULL,
      NULL,
      0.528006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569962,
      NULL,
      NULL,
      0.005573,
      NULL,
      NULL,
      10,
      1.056284,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.577552,
      NULL,
      NULL,
      NULL,
      NULL,
      0.366901,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.384642,
      0.755870,
      1,
      1,
      1.392667,
      1.835920,
      1,
      NULL,
      1.227094,
      1,
      NULL,
      1.281367,
      0.590516,
      1,
      1.492609,
      0.917944,
      0,
      1,
      0.624938,
      0,
      NULL,
      NULL,
      1.044656,
      NULL,
      NULL,
      7.916788,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.647428,
      1,
      NULL,
      1.104838,
      1.358488,
      3,
      2.846976,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      9,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.818854,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.926401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.637028,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      2.532054,
      2,
      2.460443,
      7,
      NULL,
      NULL,
      0,
      4.053549,
      NULL,
      3.180743,
      3.575534,
      1.119199,
      NULL,
      2,
      2.223289,
      1,
      2.564471,
      1.289059,
      2,
      9.850452,
      5,
      NULL,
      0,
      3,
      2.306262,
      2.709150,
      3,
      NULL,
      0,
      2.162123,
      NULL,
      2,
      0.227342,
      NULL,
      9.447795,
      NULL,
      8.018017,
      NULL,
      NULL,
      1,
      3.713799,
      NULL,
      4,
      NULL,
      1,
      NULL,
      1,
      0.619172,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.761484,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.429118,
      NULL,
      NULL,
      1.265280,
      0,
      0,
      1.000539,
      0,
      NULL,
      1.403743,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.294172,
      NULL,
      NULL,
      NULL,
      0.782087,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.861947,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.669558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.858988,
      NULL,
      NULL,
      NULL,
      2.294716,
      2.510110,
      4,
      NULL,
      NULL,
      NULL,
      0.642377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.058602,
      NULL,
      1.328041,
      NULL,
      0.283022,
      NULL,
      0,
      0.908621,
      1.954479,
      1.112319,
      1,
      NULL,
      1,
      1,
      2,
      1.285378,
      1,
      1.291717,
      1,
      1.484502,
      1,
      0,
      1.309224,
      NULL,
      1.592464,
      NULL,
      0.831567,
      NULL,
      NULL,
      NULL,
      0.390625,
      NULL,
      0.052671,
      NULL,
      48.914811,
      NULL,
      NULL,
      39,
      22,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.087511,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.881601,
      NULL,
      0.138553,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.684827,
      NULL,
      0.227905,
      NULL,
      0.438658,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.889067,
      1.027289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168515,
      NULL,
      NULL,
      3,
      NULL,
      3.956047,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.716119,
      NULL,
      1.913791,
      NULL,
      1.697090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.469698,
      NULL,
      NULL,
      NULL,
      124,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      112.694461,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1.280973,
      0.606692,
      15,
      6,
      1.257764,
      NULL,
      NULL,
      NULL,
      4,
      6,
      3.876191,
      1.897790,
      2,
      0,
      0,
      NULL,
      8.092870,
      3.602413,
      1.032400,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.257649,
      NULL,
      0.560121,
      1.112419,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.816258,
      NULL,
      1.559701,
      1.876333,
      NULL,
      1.542213,
      2,
      NULL,
      0.263699,
      0,
      NULL,
      0,
      0.837755,
      NULL,
      NULL,
      0.090451,
      NULL,
      2.577406,
      0.404073,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.082578,
      NULL,
      0.173915,
      NULL,
      1,
      NULL,
      8.729459,
      6,
      NULL,
      2,
      0,
      0.869937,
      NULL,
      NULL,
      NULL,
      1.363099,
      6.015176,
      '01423',
      '40004',
      NULL,
      3,
      '04343',
      NULL,
      '',
      0.515982,
      NULL,
      NULL,
      '');
commit;
end;
/


