set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9537645';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-12-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '0044420',
      3,
      1.697851,
      3,
      1,
      '0013',
      0,
      NULL,
      NULL,
      NULL,
      ' 0-20-1994',
      36,
      NULL,
      0.350430,
      3,
      2.088396,
      NULL,
      18.245242,
      1.145349,
      21.423788,
      69,
      1.484958,
      ' 3-29-1975',
      ' 8- 5-1982',
      ' 4- 5-1998',
      NULL,
      1.787407,
      NULL,
      1.103550,
      1.925337,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      5.371668,
      9,
      4,
      NULL,
      0,
      7,
      1,
      4,
      6,
      0,
      1.835858,
      1.170297,
      1,
      1,
      0.362601,
      0,
      0,
      1,
      1.381645,
      1,
      2.705059,
      NULL,
      1.850178,
      3.136403,
      2,
      1.319688,
      NULL,
      1,
      0.222436,
      NULL,
      0,
      0.094851,
      NULL,
      1.868640,
      1.251017,
      1,
      4,
      NULL,
      3,
      0,
      0,
      1,
      NULL,
      NULL,
      1.706070,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.621106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.300842,
      NULL,
      0.884380,
      2.509459,
      3,
      0,
      2.956571,
      0.831150,
      2.153558,
      2.295646,
      5,
      1.724717,
      1,
      4.958138,
      0,
      0.440953,
      NULL,
      NULL,
      0.252100,
      NULL,
      NULL,
      2,
      3,
      NULL,
      1.162072,
      0,
      2,
      0.966877,
      0.007583,
      1.570690,
      1.538926,
      0,
      1,
      NULL,
      1.551152,
      0.650263,
      5,
      NULL,
      4,
      1.148558,
      NULL,
      0,
      NULL,
      1,
      4,
      1,
      2.605840,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.270086,
      3,
      5.865124,
      1,
      0.826707,
      NULL,
      0,
      3.829957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.101527,
      NULL,
      3.076915,
      0,
      1,
      1,
      1,
      1.488857,
      0.368941,
      1,
      0.629708,
      7.226033,
      0,
      1.937458,
      0,
      2,
      0.147029,
      5.925496,
      5,
      1,
      NULL,
      4.875385,
      0.801362,
      11.077820,
      1.715807,
      NULL,
      NULL,
      3.565625,
      12,
      NULL,
      0,
      4,
      4.779506,
      7,
      '11- 0-1993',
      25.097662,
      ' 0-10-2001',
      3.064479,
      1,
      NULL,
      0,
      1,
      2.289637,
      1.029796,
      0.159553,
      1,
      1.054061,
      1.678444,
      NULL,
      44.052686,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.696826,
      1,
      NULL,
      2.152786,
      2.731465,
      1.558949,
      2,
      3.362262,
      3.269085,
      1,
      1,
      1.495871,
      NULL,
      3,
      3,
      2.669164,
      0.700969,
      1,
      0,
      1.537299,
      0,
      0.146195,
      NULL,
      1.975794,
      1,
      0,
      1,
      0,
      0,
      1,
      1.899388,
      1.598450,
      7,
      6.124539,
      5,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.520785,
      0.546776,
      59,
      0,
      2,
      NULL,
      NULL,
      4.782137,
      101,
      0,
      NULL,
      2.309194,
      '33433',
      '04440',
      '',
      2,
      '3033',
      '',
      '',
      4,
      '2343',
      '10400',
      '',
      2,
      7.350818,
      7.382272,
      NULL,
      0.038644,
      NULL,
      NULL,
      NULL,
      NULL,
      1.734347,
      NULL,
      NULL,
      0.431031,
      NULL,
      NULL,
      1.167601,
      NULL,
      NULL,
      1.071850,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.991816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.179597,
      NULL,
      NULL,
      1.261477,
      NULL,
      NULL,
      0.381706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.432089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822065,
      NULL,
      NULL,
      1.467857,
      NULL,
      NULL,
      0.580676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2.631324,
      0.674448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.190944,
      NULL,
      NULL,
      0.935985,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.776682,
      NULL,
      NULL,
      1.718501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.280460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.460411,
      1.580655,
      3.338564,
      0,
      NULL,
      NULL,
      1.674578,
      3,
      0.312314,
      0.329010,
      NULL,
      NULL,
      0.522163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.960968,
      2,
      3,
      NULL,
      1.493330,
      NULL,
      3,
      NULL,
      NULL,
      1.122287,
      2.154049,
      3.216255,
      NULL,
      NULL,
      NULL,
      NULL,
      0.698241,
      1.106841,
      3.598700,
      NULL,
      NULL,
      5,
      3.537985,
      3,
      4,
      0.127075,
      3,
      1.007290,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.370293,
      0.666145,
      1.286237,
      0,
      1.150755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.619048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.849136,
      0,
      17.470848,
      0.528809,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.960897,
      0.528001,
      2,
      1.961372,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      166,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1.608443,
      0,
      0,
      1.965794,
      NULL,
      0,
      0,
      0.209371,
      0.467260,
      0,
      0.490166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.379439,
      1.788872,
      1,
      7.249569,
      5.785127,
      NULL,
      3.737663,
      1,
      6.970346,
      NULL,
      1.609805,
      3,
      0.465006,
      NULL,
      0.145310,
      0.419859,
      1.185617,
      0.299321,
      0.675568,
      NULL,
      NULL,
      2.181194,
      NULL,
      1.646103,
      0.168171,
      0.206759,
      3.097227,
      2,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      0,
      0,
      0.306423,
      2,
      1,
      0.746508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431594,
      2,
      NULL,
      0,
      NULL,
      1.487228,
      0,
      NULL,
      0,
      2.508118,
      0.042096,
      NULL,
      2.705075,
      1.335396,
      1.437715,
      0,
      0.672852,
      3,
      NULL,
      0,
      1.129963,
      2,
      1.027529,
      1.750979,
      0.475514,
      3.523654,
      1,
      21,
      0,
      NULL,
      0.177677,
      0.823462,
      0,
      1.789307,
      NULL,
      1,
      1,
      9.997076,
      6.616733,
      1,
      NULL,
      NULL,
      NULL,
      103.912639,
      4,
      NULL,
      3,
      NULL,
      NULL,
      '',
      0,
      '2044',
      '',
      '',
      NULL,
      NULL,
      '01411',
      NULL);
commit;
end;
/


