set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530250';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.104241,
      2,
      1,
      NULL,
      2,
      3.127096,
      1,
      3.876301,
      '432',
      '00324340',
      84,
      4,
      NULL,
      1.319567,
      0.589626,
      0,
      1,
      '4220',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      147,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.818068,
      '11-28-1983',
      ' 6- 1-2003',
      ' 8-22-1986',
      3.302219,
      NULL,
      NULL,
      NULL,
      0.600514,
      0,
      NULL,
      1,
      1,
      NULL,
      9.133924,
      7,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295188,
      5,
      4,
      2.999804,
      NULL,
      0,
      1,
      NULL,
      0.341171,
      0,
      NULL,
      0,
      0.616121,
      1,
      1,
      2.961864,
      NULL,
      0.665943,
      3,
      NULL,
      2,
      0.896177,
      NULL,
      NULL,
      0.096332,
      NULL,
      NULL,
      11.626593,
      3.971883,
      1.584057,
      NULL,
      1.976773,
      0,
      0.468254,
      1.847790,
      3.084403,
      NULL,
      1.598461,
      0,
      0.052325,
      0,
      0.264346,
      1.598529,
      2,
      NULL,
      3,
      NULL,
      1.879778,
      0.071996,
      3,
      0,
      2.651448,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.688648,
      NULL,
      1,
      0,
      0,
      4.712451,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0.727572,
      4,
      1,
      1.818547,
      1,
      1.267505,
      1,
      NULL,
      1,
      NULL,
      0.213478,
      3.372303,
      0,
      1.958676,
      NULL,
      9,
      NULL,
      1.072066,
      NULL,
      NULL,
      4,
      2.930060,
      0.348938,
      NULL,
      2,
      0,
      9,
      3,
      1,
      0,
      1.081370,
      8.662878,
      0,
      1,
      1.246928,
      1,
      '10-28-1997',
      332.858737,
      ' 1-20-1985',
      494,
      3,
      NULL,
      NULL,
      2.451003,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.888924,
      0,
      0,
      0,
      1,
      1.356156,
      1.713945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.866428,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.010978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.570920,
      NULL,
      2,
      2,
      1.817457,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.184171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.114175,
      0,
      1,
      1,
      1,
      1,
      NULL,
      4,
      NULL,
      0.773167,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.754379,
      NULL,
      0.785396,
      1.350783,
      0,
      1.700675,
      3,
      2,
      2,
      3.680531,
      3,
      2.430876,
      3.004096,
      NULL,
      1.459098,
      NULL,
      0.230509,
      NULL,
      1.223093,
      0.972218,
      1.757982,
      1,
      1.203217,
      1.939001,
      0,
      NULL,
      NULL,
      0,
      1.289861,
      0.832626,
      11,
      9,
      7.208357,
      NULL,
      9,
      6,
      2.786614,
      3.531630,
      7,
      3,
      NULL,
      NULL,
      32,
      1.408985,
      0.218520,
      57.190859,
      NULL,
      0.317040,
      NULL,
      0.774738,
      NULL,
      0,
      '12202',
      NULL,
      '',
      0.156768,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      2.301764,
      3,
      125.385556,
      10.235451,
      3,
      42,
      5,
      3.185975,
      3,
      0.742937,
      NULL,
      3.866146,
      1.629265,
      NULL,
      NULL,
      1.767736,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.842299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.979753,
      NULL,
      0.272229,
      0,
      0.365522,
      2.454227,
      0,
      1,
      NULL,
      0.689073,
      2.138372,
      1,
      NULL,
      0,
      7,
      4.514327,
      7,
      1.972125,
      1.783361,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.820145,
      0.468239,
      NULL,
      NULL,
      3,
      NULL,
      1.748342,
      NULL,
      NULL,
      1.374127,
      1,
      0.631093,
      2,
      NULL,
      0.284087,
      3,
      0.587016,
      0,
      2,
      NULL,
      0,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.088307,
      6,
      1,
      NULL,
      1.273176,
      0.902811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.050251,
      0.011589,
      0,
      NULL,
      NULL,
      NULL,
      1.865238,
      1.443431,
      3,
      0.994062,
      2.164806,
      0,
      NULL,
      NULL,
      0,
      1,
      2,
      0.955492,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.916255,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131815,
      0,
      0,
      0,
      5,
      0,
      7.806568,
      4.148351,
      5,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.253344,
      2.512506,
      NULL,
      NULL,
      NULL,
      0.520337,
      0,
      0,
      0,
      NULL,
      8,
      1,
      2.516103,
      0.666506,
      2,
      1.756616,
      0.442012,
      3.458140,
      2.599100,
      2.617036,
      2,
      1.235360,
      NULL,
      7,
      NULL,
      0.269431,
      0.115768,
      NULL,
      NULL,
      1,
      2.989838,
      8.838484,
      0,
      0,
      0.621545,
      0.291104,
      0,
      0,
      NULL,
      NULL,
      1.680873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.661763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.483134,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.836197,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.703588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.607492,
      NULL,
      NULL,
      NULL,
      0.406773,
      NULL,
      NULL,
      NULL,
      2.484854,
      NULL,
      NULL,
      NULL,
      2.360742,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.220296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434678,
      NULL,
      NULL,
      NULL,
      0.129894,
      NULL,
      NULL,
      NULL,
      0.565635,
      NULL,
      NULL,
      NULL,
      8.506443,
      NULL,
      NULL,
      NULL,
      NULL,
      3.277778,
      4.385641,
      NULL,
      3,
      130,
      64.724849,
      1.021588,
      20.333663,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.418476,
      0.460975,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.100395,
      4.615557,
      0,
      NULL,
      1.512253,
      1.078090,
      0,
      NULL,
      1,
      0.011218,
      NULL,
      0,
      1,
      1.425221,
      1.200095,
      1,
      1,
      0,
      0.395645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684894,
      NULL,
      1.083323,
      7.276654,
      0.330629,
      5,
      1,
      6.836683,
      17,
      0,
      1,
      1.984732,
      1.297451,
      1.712187,
      NULL,
      0.767359,
      3.929712,
      NULL,
      NULL,
      0.151201,
      NULL,
      NULL,
      1.466423,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.089952,
      NULL,
      NULL,
      3.028087,
      NULL,
      0.904173,
      1,
      NULL,
      0,
      1.581898,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1.666618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.821282,
      3.606116,
      9,
      3.252736,
      0.300376,
      1.823209,
      61.588154,
      42.433873,
      NULL,
      1.606955,
      1.965553,
      '31320',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      NULL);
commit;
end;
/


