set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8430555';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      NULL,
      1,
      1.223390,
      NULL,
      1,
      '2143',
      2.791841,
      NULL,
      NULL,
      NULL,
      ' 9-10-1990',
      107,
      NULL,
      2.903138,
      NULL,
      1,
      ' 7-22-1988',
      77.908339,
      1.565720,
      NULL,
      143.860399,
      2.370616,
      ' 8-10-2003',
      ' 5-26-1998',
      '11-17-1997',
      0.529313,
      1.374238,
      0,
      1,
      NULL,
      2,
      7,
      1,
      0,
      26,
      NULL,
      16.591326,
      8,
      186.028406,
      101.269922,
      NULL,
      11,
      2.467790,
      NULL,
      NULL,
      0.033496,
      1.471628,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0.114404,
      1.451611,
      172,
      10,
      9.742839,
      NULL,
      0.229620,
      1.059363,
      1.990296,
      NULL,
      0.188251,
      NULL,
      NULL,
      1.833239,
      1.168117,
      NULL,
      0,
      1.024200,
      NULL,
      0.598334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.434119,
      0,
      0.924139,
      1.324863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.585147,
      0,
      NULL,
      0,
      1.270349,
      1.682446,
      1,
      NULL,
      0.131373,
      0.608560,
      1.302186,
      0,
      0,
      1.184910,
      0.713828,
      1,
      NULL,
      NULL,
      1,
      1.667725,
      0.859903,
      0,
      NULL,
      0.394113,
      0,
      0,
      NULL,
      1,
      2.256016,
      2,
      1,
      3,
      2.407254,
      0,
      10.208526,
      1.082463,
      2.007468,
      3.934875,
      9.095275,
      NULL,
      3,
      1,
      0.764799,
      1.254618,
      3.153779,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.040629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.476999,
      NULL,
      NULL,
      0.097282,
      1.382987,
      3.340307,
      1.459157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.827811,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.697744,
      NULL,
      NULL,
      1.795718,
      NULL,
      0.701586,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.007786,
      0,
      0,
      1,
      NULL,
      NULL,
      8727.998617,
      1.783790,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1.996775,
      2.297803,
      2,
      NULL,
      2.697749,
      2,
      3,
      2,
      1.565469,
      2,
      17.937198,
      4,
      3.864490,
      0.152490,
      0,
      1,
      NULL,
      1,
      NULL,
      1.424053,
      NULL,
      0.526448,
      1,
      1.214639,
      1.209559,
      2,
      1,
      2.860315,
      2,
      1,
      1.909727,
      NULL,
      2.171023,
      5,
      2.568119,
      NULL,
      3.494092,
      3.864972,
      NULL,
      43,
      1,
      1.028841,
      NULL,
      0,
      25.706684,
      NULL,
      NULL,
      1.961969,
      0,
      '44234',
      '30003',
      NULL,
      NULL,
      '01411',
      '',
      '',
      0.527351,
      '33331',
      '10022',
      NULL,
      1.883697,
      10,
      NULL,
      1,
      0.060101,
      11.046510,
      29.145213,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.404338,
      1.298855,
      NULL,
      NULL,
      1.974934,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.044694,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.576353,
      NULL,
      NULL,
      1.758257,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7,
      3,
      0,
      0.873932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      3,
      1,
      0.733441,
      NULL,
      NULL,
      3,
      1,
      3,
      0.683666,
      1,
      1.743177,
      0,
      1.542110,
      1.343284,
      2,
      0.443726,
      NULL,
      0.156931,
      0.955742,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.027660,
      NULL,
      NULL,
      1.144902,
      NULL,
      NULL,
      2,
      0,
      2,
      0.614159,
      0,
      NULL,
      NULL,
      NULL,
      1.746064,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.577576,
      1.336492,
      0,
      2.935351,
      0,
      NULL,
      1,
      1.837332,
      NULL,
      NULL,
      6.223764,
      5.100278,
      NULL,
      1.393390,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.730575,
      NULL,
      NULL,
      1.327739,
      NULL,
      NULL,
      0.210097,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.321887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.952561,
      0.070664,
      NULL,
      NULL,
      5,
      2,
      3.231371,
      1.791509,
      2,
      2,
      0,
      3.320463,
      1,
      2,
      1.027454,
      4,
      NULL,
      NULL,
      0,
      1.523179,
      2,
      1.476841,
      NULL,
      3.310367,
      3.534516,
      0.604526,
      NULL,
      2.807634,
      2,
      1.999469,
      2.697790,
      NULL,
      5,
      NULL,
      5.002319,
      1.750334,
      NULL,
      0.724036,
      3,
      1.570483,
      1,
      0,
      1.466482,
      0,
      3,
      NULL,
      NULL,
      1.308646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.009890,
      NULL,
      NULL,
      1.722109,
      NULL,
      NULL,
      2.030746,
      NULL,
      NULL,
      4.833186,
      NULL,
      NULL,
      1,
      1,
      0.396667,
      NULL,
      1.124435,
      0,
      1.490544,
      NULL,
      NULL,
      4.151689,
      0.817756,
      NULL,
      NULL,
      2.984385,
      NULL,
      NULL,
      NULL,
      0.642634,
      NULL,
      NULL,
      NULL,
      0.126046,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.082545,
      NULL,
      NULL,
      2.252612,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023086,
      NULL,
      NULL,
      NULL,
      1.751358,
      NULL,
      NULL,
      2.911957,
      1.410931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.785967,
      7,
      NULL,
      NULL,
      NULL,
      17,
      5.321027,
      1,
      1,
      615.523353,
      NULL,
      1.556035,
      1883.518166,
      1734.211794,
      1,
      NULL,
      NULL,
      NULL,
      25,
      2,
      0.608491,
      790.847416,
      1374.673610,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.073710,
      9274,
      117.883126,
      0.807044,
      1,
      1.232430,
      NULL,
      NULL,
      3.497665,
      1,
      1.223810,
      1,
      0,
      NULL,
      0.241648,
      1,
      0.961383,
      0.112658,
      NULL,
      0.342206,
      0.517436,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      151,
      NULL,
      13,
      40,
      21.720791,
      0.148866,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.639248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.570448,
      NULL,
      3.381799,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.850799,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.933099,
      NULL,
      0.806476,
      2,
      0.212066,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.624436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.143988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1.265748,
      NULL,
      NULL,
      NULL,
      1.639177,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.871928,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      4,
      13,
      1.195338,
      2,
      NULL,
      1,
      1,
      1,
      NULL,
      1.252783,
      0.527614,
      1.093131,
      1,
      1.813129,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.594921,
      NULL,
      2.338644,
      2,
      3,
      0,
      NULL,
      NULL,
      2,
      3.109854,
      2.116390,
      1.349006,
      0.768763,
      3.959254,
      2,
      3,
      3.240942,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.220042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.456346,
      1,
      1.277444,
      1.943974,
      NULL,
      0,
      2.693272,
      5,
      3,
      1.191883,
      NULL,
      2.074030,
      38,
      60.237769,
      3.709141,
      1,
      NULL,
      NULL,
      NULL,
      '10133',
      NULL,
      '23040',
      NULL,
      NULL,
      NULL,
      '1341',
      '21031',
      '31111');
commit;
end;
/


