set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9884735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.277988,
      3,
      3.697091,
      0,
      NULL,
      5,
      6.949806,
      NULL,
      '121',
      '20313222',
      67.085642,
      50,
      '4131031',
      0.643633,
      NULL,
      NULL,
      2,
      '3244',
      0,
      NULL,
      NULL,
      NULL,
      ' 8-21-1978',
      108,
      165.586363,
      NULL,
      0,
      1.143966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.517972,
      ' 7- 4-1977',
      NULL,
      ' 9-16-1997',
      NULL,
      NULL,
      NULL,
      0,
      0.528706,
      NULL,
      1,
      1,
      NULL,
      2,
      10,
      18.704528,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.841564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      2,
      NULL,
      0,
      1.954618,
      1,
      0.619642,
      0.694555,
      3.787707,
      5,
      7,
      NULL,
      NULL,
      1,
      NULL,
      1.168058,
      NULL,
      3.852161,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.172811,
      0,
      0.187769,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.396965,
      NULL,
      1.718401,
      0.350393,
      3,
      NULL,
      NULL,
      2,
      3.603703,
      2,
      0.301016,
      NULL,
      0.314653,
      7.369513,
      NULL,
      2.043335,
      3.355002,
      0.536472,
      NULL,
      NULL,
      0.478419,
      NULL,
      NULL,
      1.474779,
      3,
      0.234717,
      0,
      3.459918,
      5,
      5.760059,
      4,
      1.706582,
      0.089567,
      0.026826,
      1.507216,
      1.033267,
      0,
      1,
      1.384146,
      0,
      1,
      0,
      NULL,
      3,
      NULL,
      2,
      0,
      0.500574,
      1.727318,
      2.379277,
      4.509003,
      NULL,
      NULL,
      0,
      1.002120,
      NULL,
      1.570100,
      5.759168,
      NULL,
      9,
      0.645895,
      8,
      0,
      NULL,
      2.270873,
      0,
      3.253872,
      1.854095,
      3,
      1.715605,
      0.456557,
      ' 2- 2-2000',
      135,
      ' 1-10-1985',
      105.988228,
      0.968430,
      1.899226,
      1.871391,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306340,
      0.122114,
      1.873307,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9.456046,
      2.262584,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.611222,
      0.734608,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      0.365802,
      1.256439,
      9.523157,
      0.577974,
      NULL,
      NULL,
      NULL,
      0.474313,
      5.887983,
      0.802240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.499439,
      0.035815,
      NULL,
      0.611160,
      0.514598,
      0.029127,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.972530,
      1,
      2.637763,
      NULL,
      NULL,
      NULL,
      2.179971,
      3.415182,
      1.098505,
      3,
      4,
      NULL,
      NULL,
      NULL,
      0.877515,
      1,
      1.624726,
      0.210761,
      0.493879,
      0.569604,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.666111,
      0.635480,
      NULL,
      NULL,
      0.276355,
      NULL,
      9.102744,
      1,
      5,
      NULL,
      2,
      1,
      NULL,
      1.832900,
      NULL,
      3.031711,
      1,
      6.599779,
      NULL,
      2.725095,
      27.493427,
      NULL,
      NULL,
      59,
      2.645059,
      2.250061,
      1,
      '31344',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1.345459,
      '',
      NULL,
      '',
      3.918145,
      34.584729,
      48,
      8,
      0.260498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.408630,
      2.888293,
      1.776908,
      0.093772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.896780,
      3,
      2.958916,
      2.169671,
      1.699327,
      3,
      2.995921,
      2,
      3,
      3.967853,
      2.415707,
      1,
      0,
      NULL,
      0.066095,
      0.099062,
      NULL,
      NULL,
      3,
      7.666548,
      0.025231,
      0,
      0.438823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.001214,
      1,
      NULL,
      NULL,
      2,
      3.980287,
      1.096992,
      2,
      1.697048,
      1.701065,
      NULL,
      2,
      1,
      0.877739,
      NULL,
      1,
      0.155824,
      NULL,
      NULL,
      0.264518,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.297108,
      NULL,
      NULL,
      1.817041,
      NULL,
      1,
      6.607358,
      4.629443,
      1.526346,
      1.695196,
      0,
      NULL,
      NULL,
      NULL,
      1.407872,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      3,
      0.148886,
      NULL,
      NULL,
      1.513630,
      NULL,
      NULL,
      1.681796,
      4.417418,
      3.513459,
      3.687396,
      1.065331,
      0,
      1.006100,
      NULL,
      NULL,
      7.380751,
      6.092317,
      3,
      0,
      NULL,
      NULL,
      0.490807,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.866117,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.358799,
      3.681556,
      0.722841,
      NULL,
      NULL,
      0,
      3,
      NULL,
      4,
      5.094484,
      0.409253,
      2.421610,
      NULL,
      3.168693,
      2,
      2,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.681415,
      7.950781,
      0.545785,
      2,
      NULL,
      3,
      0,
      NULL,
      2.461064,
      1.210265,
      0,
      NULL,
      3.118861,
      0.829648,
      5,
      0,
      6,
      4,
      7.680999,
      6.191292,
      3.318645,
      NULL,
      2.145977,
      NULL,
      1,
      0,
      0,
      1,
      2.511556,
      NULL,
      NULL,
      1.969770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.783068,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.166742,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.195379,
      NULL,
      1,
      1.145403,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42.019154,
      NULL,
      NULL,
      NULL,
      1.649049,
      NULL,
      NULL,
      NULL,
      1.618266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.144792,
      NULL,
      NULL,
      NULL,
      0.809889,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.405849,
      NULL,
      NULL,
      NULL,
      3.139477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360204,
      NULL,
      NULL,
      NULL,
      0.921472,
      NULL,
      NULL,
      NULL,
      0.900561,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      14,
      3,
      1.158193,
      11,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.666814,
      7.857174,
      1,
      0,
      0.513338,
      1.614610,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      0.245470,
      0.977578,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.677192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.361843,
      5,
      1.702998,
      5,
      2.466888,
      3,
      3.160011,
      NULL,
      6.926034,
      0.654207,
      1.319560,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.764531,
      NULL,
      0,
      0.838114,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.736436,
      NULL,
      1.819190,
      3,
      NULL,
      0.170041,
      1.522369,
      NULL,
      3.082691,
      3.568440,
      NULL,
      0.485348,
      1,
      NULL,
      0,
      3,
      NULL,
      0.349206,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.553720,
      NULL,
      1.720135,
      5,
      9,
      0.452334,
      1.419069,
      2.874642,
      47,
      15.748843,
      3,
      1,
      0.864656,
      NULL,
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      0.607845,
      NULL,
      '',
      '');
commit;
end;
/


