set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9884735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.960233,
      NULL,
      6,
      2,
      0,
      NULL,
      2,
      3.609800,
      NULL,
      '00401434',
      83,
      73.575588,
      '2023022',
      3.933798,
      0.437960,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 7- 5-1987',
      NULL,
      NULL,
      NULL,
      0.674373,
      NULL,
      ' 4-28-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.294496,
      NULL,
      3.095887,
      NULL,
      1.990883,
      0.483407,
      NULL,
      4.990089,
      4,
      1.738184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.125107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5.256156,
      7,
      NULL,
      NULL,
      0.913582,
      0.901430,
      NULL,
      1.273548,
      NULL,
      4.797258,
      4,
      6.932191,
      0,
      NULL,
      NULL,
      4,
      0,
      4,
      2.862840,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.227119,
      1,
      5.422215,
      1.618288,
      1,
      1,
      1.185780,
      2.168722,
      0,
      1.000703,
      1,
      1.139954,
      1,
      1,
      3.138797,
      0.771967,
      0.937639,
      0,
      NULL,
      1.676727,
      0.473971,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      NULL,
      NULL,
      0.977685,
      NULL,
      NULL,
      1.720254,
      5.496868,
      0.034515,
      NULL,
      NULL,
      0.912996,
      0,
      2,
      1,
      0.639734,
      0.169715,
      5.937810,
      NULL,
      1.653661,
      0,
      0.653481,
      0,
      1.955390,
      1.900422,
      NULL,
      0.245295,
      NULL,
      5,
      NULL,
      1.179430,
      0.608718,
      2.829652,
      4.020088,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      2,
      1,
      2,
      0.243785,
      2,
      6,
      7.307892,
      0.264045,
      1.992063,
      NULL,
      7.499755,
      7,
      1.714080,
      2.842028,
      ' 5- 5-1974',
      352.497020,
      NULL,
      NULL,
      0.878551,
      NULL,
      1,
      6.720290,
      1.618201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.737945,
      1.681736,
      NULL,
      5,
      0.994183,
      3.913014,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.903363,
      0.219394,
      2.673441,
      1.543733,
      0.341874,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.543806,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.817274,
      NULL,
      NULL,
      2,
      0.888306,
      2,
      NULL,
      5,
      0,
      0,
      3,
      3,
      5.232814,
      0.312651,
      NULL,
      2.484983,
      2,
      0,
      NULL,
      1,
      NULL,
      1.969722,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.598183,
      1.328717,
      NULL,
      NULL,
      1.173504,
      5,
      8.219426,
      7.937825,
      5,
      9,
      7,
      3.932234,
      2.804492,
      2.446835,
      2.068490,
      1.013171,
      NULL,
      NULL,
      2.137573,
      NULL,
      36.932078,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3.925122,
      '30233',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2.814601,
      NULL,
      NULL,
      43,
      0.338817,
      NULL,
      0.078050,
      3.665489,
      3,
      1,
      NULL,
      2,
      1.090125,
      NULL,
      NULL,
      1.430355,
      NULL,
      NULL,
      2.592094,
      1,
      2.554036,
      0.655747,
      NULL,
      NULL,
      0.731167,
      NULL,
      NULL,
      1.389798,
      3,
      2,
      2.392625,
      0,
      2,
      2.517237,
      NULL,
      3,
      2.709339,
      0.973648,
      1,
      NULL,
      2.994680,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.334755,
      6.704779,
      1.125263,
      0.820785,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.731085,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.202172,
      0.985816,
      1.669111,
      0,
      1,
      0,
      1,
      NULL,
      0.964982,
      0.928368,
      NULL,
      NULL,
      NULL,
      2.221449,
      0.473059,
      1,
      0,
      NULL,
      NULL,
      0.200317,
      NULL,
      NULL,
      0,
      1.767836,
      1,
      1.569778,
      2,
      6.158542,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.562497,
      1.278499,
      1,
      NULL,
      NULL,
      0.763048,
      NULL,
      NULL,
      0,
      5.289217,
      3,
      2,
      NULL,
      2.324603,
      NULL,
      NULL,
      NULL,
      2,
      7.705359,
      5,
      0.493338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.123479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999213,
      2,
      NULL,
      3.810607,
      NULL,
      1,
      3.932199,
      3.217625,
      3.192888,
      NULL,
      5.938631,
      5,
      NULL,
      NULL,
      2.742813,
      NULL,
      3.516940,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.700678,
      3.525628,
      NULL,
      1.975147,
      3,
      2.816513,
      0,
      2.295819,
      0,
      2,
      NULL,
      6,
      NULL,
      4.325152,
      7,
      0,
      6.239114,
      1,
      0.546750,
      0,
      0.177370,
      1.357608,
      1.733663,
      1,
      0.340024,
      3.745380,
      NULL,
      NULL,
      0.361602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311900,
      NULL,
      NULL,
      0.790282,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.897881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.269581,
      NULL,
      NULL,
      0.465730,
      1.759749,
      0,
      NULL,
      NULL,
      1.454694,
      0.003410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      70,
      NULL,
      NULL,
      NULL,
      2.489129,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.968520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.430370,
      NULL,
      NULL,
      NULL,
      0.624213,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.836026,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.582051,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1.576302,
      3,
      9,
      2.264928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.033430,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.925732,
      NULL,
      1.323195,
      0.074896,
      3.110299,
      0.217632,
      0.009595,
      0,
      1,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0.790386,
      NULL,
      NULL,
      0.748981,
      0,
      0.253247,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.352039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.053463,
      2.449364,
      1.316652,
      NULL,
      0.580220,
      6.075156,
      5.749145,
      NULL,
      15.351155,
      3.629102,
      0.883779,
      NULL,
      NULL,
      2.246365,
      NULL,
      0.515618,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2.756372,
      0,
      NULL,
      0.685098,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.752183,
      NULL,
      NULL,
      0.177924,
      NULL,
      3.297701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      5,
      1.296821,
      NULL,
      NULL,
      1.776576,
      0,
      8,
      NULL,
      2.135741,
      4.729404,
      2,
      '00343',
      NULL,
      '',
      1.762614,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


