set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      NULL,
      0.030313,
      1.545404,
      3,
      1,
      '4330',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-24-2000',
      14.644687,
      NULL,
      NULL,
      1,
      3.435911,
      ' 5-28-1991',
      NULL,
      2.387657,
      84,
      45.133034,
      3,
      '11-29-1997',
      ' 4- 9-1982',
      ' 0- 4-1976',
      3.706236,
      NULL,
      2,
      3.463247,
      0.955788,
      2.157570,
      3,
      0.135816,
      NULL,
      NULL,
      NULL,
      7.103550,
      2,
      NULL,
      3,
      6,
      14,
      2.777409,
      5,
      7.703481,
      0,
      NULL,
      5.603237,
      1.681954,
      1.847334,
      0,
      0,
      0.178322,
      1,
      0,
      1,
      3,
      0.596444,
      2.953008,
      0,
      0,
      NULL,
      0.352698,
      NULL,
      NULL,
      0,
      NULL,
      0.252653,
      1,
      NULL,
      0.304459,
      0.887155,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.998634,
      1,
      2.766209,
      0.818737,
      1.169043,
      1.748705,
      0,
      0.492077,
      2.565949,
      0.822707,
      1.253677,
      0,
      1.078503,
      1.187826,
      1,
      2,
      NULL,
      1.599340,
      1.442769,
      1.720353,
      0.387925,
      NULL,
      NULL,
      0.048802,
      NULL,
      1.152072,
      NULL,
      NULL,
      0.145786,
      NULL,
      NULL,
      NULL,
      1.248209,
      1,
      1.508915,
      0,
      NULL,
      1.819902,
      0.761839,
      NULL,
      NULL,
      NULL,
      0,
      0.560329,
      NULL,
      NULL,
      NULL,
      NULL,
      0.998855,
      0.513343,
      NULL,
      0.050021,
      1,
      1.748969,
      0,
      2,
      1,
      NULL,
      0,
      NULL,
      1.183884,
      3.127467,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      6,
      3,
      0,
      0,
      1.483074,
      0,
      1.978610,
      0.597384,
      0.316467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.878362,
      0.374829,
      1.690225,
      0.736241,
      1,
      0.998987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      65,
      1,
      0.207410,
      0.915524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.996498,
      1,
      1,
      0.081938,
      0,
      0,
      7.901006,
      4.327062,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.879607,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.856035,
      1,
      1.895521,
      NULL,
      0,
      1.175083,
      3.896577,
      NULL,
      NULL,
      0.470539,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.797741,
      NULL,
      1,
      0,
      3,
      NULL,
      1.088617,
      1,
      NULL,
      0.888824,
      0.921042,
      NULL,
      1.769153,
      5,
      2.099438,
      3.155231,
      1.197110,
      NULL,
      0.116838,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      0.510111,
      0.153261,
      NULL,
      1.583377,
      0,
      NULL,
      NULL,
      1.138903,
      NULL,
      6.402797,
      6.011063,
      NULL,
      NULL,
      2.082729,
      2.694783,
      2.442488,
      NULL,
      7.090891,
      1.515123,
      2.208508,
      NULL,
      NULL,
      NULL,
      44.949917,
      5,
      1,
      5,
      '31320',
      NULL,
      '',
      1,
      NULL,
      '',
      NULL,
      0.268973,
      '',
      '',
      '',
      3.853142,
      NULL,
      17,
      10.349541,
      0,
      9.714881,
      2.550786,
      5.884068,
      0.164372,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.218180,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823867,
      1.590623,
      1.986065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      1.719469,
      1,
      NULL,
      1,
      1.942871,
      1.664425,
      NULL,
      NULL,
      NULL,
      3.914861,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.060661,
      0.508782,
      0,
      1.993784,
      NULL,
      NULL,
      NULL,
      1.503714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.459331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.285978,
      NULL,
      NULL,
      1.370887,
      NULL,
      NULL,
      0.534298,
      NULL,
      NULL,
      0.519899,
      NULL,
      NULL,
      0.891923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.697366,
      NULL,
      NULL,
      0.121566,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.608241,
      5.168083,
      0.684555,
      0,
      NULL,
      NULL,
      1.927203,
      NULL,
      NULL,
      3.615874,
      2,
      1,
      0.795154,
      NULL,
      NULL,
      1.245940,
      4,
      2.862297,
      2,
      0.825358,
      3.033914,
      1.497504,
      2,
      0.096950,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      1,
      0.941612,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0,
      NULL,
      1,
      1,
      1.081198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333437,
      0,
      NULL,
      1.797119,
      0.864467,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.851975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.142216,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.435831,
      0,
      1,
      0.947605,
      0.534976,
      1.088072,
      0,
      1.778038,
      NULL,
      0.116427,
      0.563290,
      1,
      0,
      0.782950,
      0.006261,
      0.550701,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3.590287,
      NULL,
      0.157686,
      NULL,
      1,
      NULL,
      0,
      NULL,
      23,
      NULL,
      1.158598,
      17,
      NULL,
      0.161668,
      0.554023,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.779580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.796566,
      NULL,
      0.491270,
      NULL,
      1.111830,
      NULL,
      NULL,
      NULL,
      0.978074,
      NULL,
      1.561418,
      NULL,
      0,
      NULL,
      0,
      2,
      3.116199,
      1.128908,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1.748521,
      0.899338,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.953697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      1.907278,
      NULL,
      NULL,
      NULL,
      0,
      0.583742,
      0,
      NULL,
      NULL,
      0,
      0.141789,
      NULL,
      0.458055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1.514079,
      NULL,
      129.047943,
      1,
      2.865857,
      1,
      0.460462,
      1,
      0.340752,
      NULL,
      NULL,
      7,
      3,
      0.124854,
      1.789463,
      2,
      1,
      0,
      3.458108,
      2,
      NULL,
      1,
      2,
      NULL,
      2.022414,
      7.871725,
      1,
      NULL,
      1.598759,
      NULL,
      1.464791,
      NULL,
      0.770652,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.085498,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318781,
      0,
      NULL,
      1,
      1,
      NULL,
      0.701505,
      0,
      NULL,
      1,
      1,
      NULL,
      3.511570,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.104279,
      NULL,
      1.852878,
      NULL,
      0.270944,
      2.626681,
      1,
      0.689528,
      NULL,
      NULL,
      5.446280,
      69,
      0,
      1.523334,
      NULL,
      '12330',
      '41414',
      '',
      0.668950,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


