set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9616418';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '1224141',
      0.446556,
      0,
      0,
      NULL,
      '2444',
      1.202874,
      1.510445,
      NULL,
      NULL,
      ' 2- 1-1975',
      21.793503,
      NULL,
      3.472732,
      NULL,
      3,
      ' 6- 1-1993',
      21.607772,
      1.534427,
      NULL,
      72.199848,
      3,
      ' 6-14-1995',
      ' 2-10-1985',
      NULL,
      1.691808,
      0,
      3.229269,
      3,
      0,
      NULL,
      2,
      0.621687,
      0.885679,
      25.953329,
      NULL,
      14.742151,
      3,
      NULL,
      13.797145,
      5.163012,
      4.201967,
      5.026316,
      1,
      NULL,
      0.117971,
      1,
      NULL,
      1.310876,
      1,
      1.601102,
      NULL,
      1.854156,
      1.055331,
      1.550279,
      1.477281,
      3,
      1,
      2.194321,
      NULL,
      0.034784,
      0.127487,
      0.844207,
      0.517802,
      0.205468,
      NULL,
      0,
      NULL,
      NULL,
      1.516324,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.808940,
      0.693697,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177996,
      1,
      NULL,
      1.089635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.236217,
      4,
      2.591126,
      1.575124,
      0.625386,
      1,
      1,
      0.145810,
      1,
      1.080104,
      0,
      1.002944,
      1.139586,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4.787314,
      1,
      2.327078,
      NULL,
      5.819231,
      0,
      0.555616,
      NULL,
      1.799423,
      0.392033,
      1.667698,
      0.378616,
      3.965148,
      NULL,
      1,
      1,
      3,
      6.591995,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.892897,
      1,
      NULL,
      342.024425,
      ' 5-23-2003',
      NULL,
      3.222786,
      1.661503,
      NULL,
      3.373184,
      1.135340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.813411,
      NULL,
      NULL,
      1.943178,
      1.306190,
      NULL,
      NULL,
      1.891387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.574021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.995796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657300,
      2,
      1.185908,
      NULL,
      NULL,
      2.803371,
      1,
      NULL,
      NULL,
      NULL,
      1.502591,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063195,
      0.223484,
      0.248050,
      0.094426,
      0.778658,
      NULL,
      NULL,
      1.002260,
      NULL,
      2.455619,
      0.966577,
      NULL,
      NULL,
      NULL,
      3.225702,
      0.723860,
      3,
      NULL,
      NULL,
      2.226272,
      0.393312,
      1,
      NULL,
      1.478207,
      NULL,
      0.585646,
      NULL,
      1.669289,
      0,
      NULL,
      1.995075,
      0,
      1,
      NULL,
      0,
      0.000914,
      0,
      NULL,
      NULL,
      1.406652,
      1.329852,
      0,
      1,
      0.572343,
      5.715934,
      1.218966,
      6.846349,
      0,
      1.422400,
      7,
      5.338892,
      6,
      4,
      2,
      2.050864,
      3.132748,
      3,
      0,
      60,
      1.885246,
      0.463673,
      NULL,
      18,
      46,
      14,
      5,
      1,
      NULL,
      '33022',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      3.197932,
      8,
      NULL,
      33.010663,
      2.499157,
      23.329237,
      4.391524,
      2,
      3,
      0.442041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.934766,
      NULL,
      NULL,
      1.014993,
      NULL,
      NULL,
      0.005266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.924615,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.172314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.377406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533346,
      NULL,
      NULL,
      1.677107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509604,
      NULL,
      NULL,
      0.669608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.191343,
      NULL,
      NULL,
      3.635999,
      1,
      2,
      3,
      0,
      NULL,
      5,
      1.776396,
      1,
      1.504101,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.169650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.000352,
      1.448731,
      4.824378,
      0.154932,
      NULL,
      0,
      NULL,
      NULL,
      3.673671,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.457707,
      0,
      1,
      1.556370,
      NULL,
      NULL,
      1.780634,
      5.409921,
      NULL,
      2,
      3.519606,
      NULL,
      NULL,
      1,
      3.333174,
      NULL,
      2,
      NULL,
      1,
      3,
      3.531735,
      NULL,
      2.262274,
      5,
      1,
      NULL,
      NULL,
      NULL,
      2.675600,
      1.135015,
      NULL,
      1.394524,
      2.271116,
      3.080518,
      1.681358,
      1.523551,
      2.157317,
      NULL,
      NULL,
      47,
      NULL,
      NULL,
      2.948880,
      NULL,
      NULL,
      3.088568,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.507885,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.875481,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.947260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.662771,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.205494,
      NULL,
      1,
      3.137582,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      5,
      2.375946,
      3.525754,
      0.171070,
      2.177503,
      0.251686,
      NULL,
      NULL,
      0.985503,
      NULL,
      NULL,
      NULL,
      9.869294,
      16.659923,
      0,
      NULL,
      NULL,
      0.106813,
      NULL,
      1.653318,
      NULL,
      NULL,
      1.539444,
      0,
      1,
      1.835625,
      1.771298,
      NULL,
      1.355552,
      NULL,
      1.593268,
      0,
      1.424656,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.881534,
      2.398906,
      5,
      1.604355,
      3,
      2.837755,
      3.722136,
      2,
      0,
      1.217894,
      NULL,
      0.959986,
      1.466905,
      NULL,
      1.808183,
      0.387701,
      NULL,
      1.235426,
      NULL,
      NULL,
      1.854813,
      1,
      NULL,
      1,
      3.128054,
      NULL,
      0.491382,
      NULL,
      NULL,
      0,
      0.391845,
      NULL,
      3,
      0.209377,
      NULL,
      NULL,
      0.672248,
      NULL,
      3,
      0,
      NULL,
      1,
      0.972167,
      NULL,
      3,
      0,
      1.376466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.702367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.595661,
      NULL,
      1,
      NULL,
      2,
      6,
      NULL,
      1,
      1.868987,
      3,
      68.189960,
      NULL,
      4,
      1.218196,
      1,
      '24003',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


