set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '1410420',
      2,
      0,
      1,
      1,
      NULL,
      0,
      0.504116,
      NULL,
      NULL,
      '10-15-1975',
      18,
      NULL,
      0.722710,
      1,
      0.901151,
      ' 5-15-2003',
      NULL,
      3,
      336.959145,
      118,
      4,
      NULL,
      NULL,
      '10- 5-1997',
      2,
      NULL,
      0.594765,
      0,
      0.076938,
      1.050126,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.947473,
      6,
      22.633709,
      NULL,
      NULL,
      13,
      5.276583,
      0.895161,
      NULL,
      0.731132,
      1,
      0,
      1,
      0.358254,
      1.124694,
      0.972756,
      3.182237,
      3,
      0.938160,
      NULL,
      NULL,
      5.057233,
      6.474024,
      3.429575,
      NULL,
      0.197266,
      1,
      1,
      NULL,
      0,
      5,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      5,
      1.905801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.748947,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472119,
      1.308794,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.954284,
      0.778800,
      0,
      2.875838,
      0,
      0,
      0.143767,
      0.481141,
      NULL,
      3,
      NULL,
      3.455572,
      NULL,
      NULL,
      0.416231,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.381490,
      1.323141,
      0,
      5,
      NULL,
      3,
      0,
      NULL,
      6,
      2.774305,
      5,
      NULL,
      4,
      NULL,
      1.077466,
      3,
      3,
      1.954451,
      2,
      7,
      5,
      NULL,
      NULL,
      6,
      0.002995,
      5,
      0.129055,
      ' 6-12-1994',
      NULL,
      ' 3-23-1981',
      NULL,
      0.976423,
      1,
      1.192613,
      NULL,
      1.225732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0.849741,
      0.128118,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.929018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      5,
      0,
      0.197337,
      NULL,
      1.061975,
      0.176842,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.208655,
      NULL,
      0.465629,
      1.670227,
      NULL,
      1.341456,
      1,
      1.776716,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0.234306,
      NULL,
      1,
      1,
      3,
      1,
      2,
      NULL,
      3,
      3.447855,
      1.614962,
      4,
      1,
      NULL,
      NULL,
      2,
      0.371928,
      1,
      1.294864,
      1,
      1,
      0,
      1.229162,
      1.725335,
      1,
      NULL,
      0,
      6,
      4.884562,
      7.240991,
      8,
      4,
      7,
      5,
      2.878850,
      0,
      1.525181,
      NULL,
      NULL,
      NULL,
      3.332581,
      1.821367,
      46,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      22.090555,
      79.755032,
      11,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.055026,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.466335,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.300823,
      NULL,
      NULL,
      2,
      0.762626,
      0,
      3,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1.959465,
      1.437113,
      NULL,
      NULL,
      1.771899,
      NULL,
      NULL,
      7.521702,
      0.962117,
      3.842672,
      1,
      1.637803,
      NULL,
      NULL,
      NULL,
      3.900838,
      1.694852,
      3,
      NULL,
      3,
      1.029309,
      1,
      3.606212,
      1.782599,
      1,
      1.855781,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      1,
      0.833343,
      2,
      3.979935,
      0.636395,
      1.463874,
      1.651848,
      1,
      0,
      NULL,
      1.764371,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238803,
      NULL,
      NULL,
      1.757132,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.677530,
      1.071953,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3.145450,
      3,
      1.522438,
      1.310667,
      6,
      1.764331,
      1.291105,
      2.083894,
      NULL,
      0,
      0,
      0.165831,
      1,
      NULL,
      0,
      3.011756,
      NULL,
      NULL,
      NULL,
      0.706282,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.098198,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2.832803,
      3,
      NULL,
      NULL,
      3,
      7,
      0.724932,
      1,
      3.773213,
      0,
      0,
      NULL,
      NULL,
      1.659124,
      NULL,
      NULL,
      1,
      0,
      3,
      3,
      2.314153,
      NULL,
      9.213999,
      NULL,
      6.414511,
      NULL,
      NULL,
      NULL,
      1.128889,
      1.752148,
      0.869265,
      3,
      2,
      1,
      3,
      NULL,
      8.158671,
      1.944934,
      4,
      3.908793,
      3,
      0,
      6,
      NULL,
      4.519098,
      7,
      0.412451,
      1,
      0,
      1.084541,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.335415,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.885887,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.592640,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.370603,
      3,
      NULL,
      1.473488,
      0,
      NULL,
      NULL,
      NULL,
      2.657329,
      NULL,
      NULL,
      NULL,
      12,
      1.772237,
      NULL,
      NULL,
      2,
      1.675575,
      NULL,
      NULL,
      0.957138,
      0,
      NULL,
      NULL,
      3.909555,
      2,
      NULL,
      NULL,
      0,
      1.125653,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.130962,
      2,
      NULL,
      NULL,
      2,
      0.079215,
      NULL,
      NULL,
      0,
      1.206742,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.387617,
      3.768912,
      NULL,
      NULL,
      3.548950,
      2.040697,
      NULL,
      NULL,
      1.618029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.040510,
      0.685950,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.025643,
      1,
      NULL,
      NULL,
      NULL,
      2.192824,
      10,
      9,
      1,
      16.818451,
      1.880445,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.787549,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.045089,
      0,
      1,
      1,
      1.175728,
      1.973529,
      0.299192,
      0,
      1,
      NULL,
      3.101084,
      0.760124,
      2,
      0,
      1,
      0.903611,
      1.418243,
      1.019502,
      1.348270,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.431429,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.867903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.349659,
      1.906537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.009285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.196875,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020240,
      3,
      NULL,
      1.003362,
      NULL,
      2.104150,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.134663,
      0.774703,
      NULL,
      23.805818,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.903589,
      1,
      1,
      NULL,
      2,
      1,
      2.313550,
      3,
      9,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.089916,
      NULL,
      1.269243,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.752421,
      3.626545,
      NULL,
      3,
      3.778637,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.141786,
      NULL,
      NULL,
      0.845223,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.733063,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1,
      NULL,
      2.400824,
      NULL,
      1.028978,
      NULL,
      NULL,
      NULL,
      0.969210,
      NULL,
      0,
      NULL,
      2.580519,
      NULL,
      2.623022,
      NULL,
      0,
      NULL,
      0,
      NULL,
      144,
      NULL,
      160,
      0.367757,
      NULL,
      1,
      NULL,
      1.803046,
      NULL,
      7.377583,
      7,
      9,
      1,
      NULL,
      NULL,
      20.935368,
      47.076817,
      1.848120,
      0.615548,
      3,
      '33013',
      '24214',
      '',
      0.998332,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


