set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      2.943257,
      1.608099,
      NULL,
      3,
      NULL,
      0,
      0.506426,
      NULL,
      NULL,
      ' 9- 5-1996',
      29,
      NULL,
      NULL,
      3,
      1.016037,
      NULL,
      8.600011,
      2.577824,
      214.382686,
      59.507287,
      0,
      ' 0- 1-2002',
      ' 8-24-1975',
      '10-16-1985',
      2,
      0,
      0,
      3,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      25,
      25.294500,
      2,
      23.806075,
      5.555224,
      4,
      5,
      1,
      NULL,
      NULL,
      0.776879,
      1.810824,
      NULL,
      1.878790,
      0,
      0.792540,
      0,
      1.640717,
      0,
      2.982231,
      6,
      1,
      6,
      1,
      6,
      1,
      1.106901,
      3,
      1.236804,
      0,
      3.842981,
      0.492312,
      NULL,
      2.319966,
      NULL,
      NULL,
      2.922148,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.079032,
      2,
      0.944152,
      1,
      1,
      3,
      1.598827,
      3,
      NULL,
      0,
      3.101595,
      3.768181,
      1,
      3,
      1,
      0,
      0,
      2.234043,
      0.278507,
      1,
      6,
      0.100955,
      1.532516,
      3,
      1.882884,
      NULL,
      NULL,
      0.138284,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.761370,
      1,
      0,
      3,
      NULL,
      1,
      NULL,
      0,
      3,
      NULL,
      6.195088,
      1.930382,
      0.624358,
      1,
      NULL,
      1,
      NULL,
      1.731131,
      4,
      5.209623,
      1,
      NULL,
      5,
      7.311002,
      3.284378,
      1,
      0,
      2.580753,
      0.570910,
      0,
      0,
      1,
      10,
      5.210286,
      4.710851,
      5,
      3,
      5.404286,
      1.084505,
      6.940503,
      0,
      1,
      5,
      5,
      NULL,
      '10- 8-1996',
      381,
      ' 7- 3-1979',
      256.744917,
      0.668019,
      1.576219,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.678071,
      NULL,
      0.693563,
      NULL,
      NULL,
      1.827771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.613918,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.766652,
      0,
      1.265967,
      0,
      1,
      1.856242,
      1.584314,
      7.579048,
      4,
      1.318204,
      1.038114,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.574308,
      1.108034,
      0.087741,
      1.069413,
      0,
      12,
      0,
      0.235365,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2.924218,
      3,
      1.336714,
      NULL,
      1,
      3.053766,
      3,
      3.405653,
      0,
      3.721944,
      0.288273,
      NULL,
      0,
      NULL,
      1,
      1,
      0.336966,
      0.471739,
      1,
      1,
      1.186799,
      NULL,
      0.765814,
      0.208238,
      1,
      0.261039,
      1.953659,
      NULL,
      NULL,
      2,
      6.914888,
      2,
      5.650585,
      10.940428,
      6.350668,
      5,
      NULL,
      4.743699,
      3.087529,
      3,
      0,
      NULL,
      1,
      3.859129,
      NULL,
      59.678336,
      NULL,
      48.624991,
      4.267253,
      3.277885,
      2.465953,
      '01130',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.492873,
      '',
      '',
      '',
      2,
      6.411014,
      NULL,
      1.164385,
      3,
      24.543759,
      7.241679,
      NULL,
      2,
      0,
      2,
      0,
      0.510877,
      NULL,
      NULL,
      2,
      1,
      3,
      0.317056,
      NULL,
      NULL,
      1.152701,
      NULL,
      NULL,
      3.579589,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.058793,
      0,
      0.024528,
      3.958396,
      1.570994,
      3,
      1,
      NULL,
      NULL,
      0,
      3.806973,
      NULL,
      0.060085,
      NULL,
      NULL,
      NULL,
      6.753712,
      3,
      0.277965,
      1,
      NULL,
      NULL,
      NULL,
      1.943242,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.691855,
      3,
      2.927442,
      0,
      2,
      2.868137,
      0.224705,
      NULL,
      NULL,
      1,
      0,
      3.806370,
      1,
      NULL,
      NULL,
      0.348156,
      NULL,
      1.593079,
      2,
      3,
      NULL,
      1,
      1,
      NULL,
      3,
      2.066669,
      0,
      NULL,
      NULL,
      0.714500,
      NULL,
      NULL,
      5,
      NULL,
      4.399878,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.742997,
      NULL,
      NULL,
      NULL,
      0.708364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.047930,
      0.570748,
      1,
      1.842536,
      NULL,
      NULL,
      2.550189,
      NULL,
      2,
      NULL,
      1,
      0.090976,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.917511,
      NULL,
      NULL,
      NULL,
      2.634783,
      3,
      3.060259,
      0.675868,
      NULL,
      0.156195,
      3,
      NULL,
      4,
      0.458088,
      7,
      1.969877,
      NULL,
      NULL,
      1.399168,
      2,
      1,
      0.146676,
      0,
      3.789951,
      2.169131,
      NULL,
      NULL,
      5.882910,
      1,
      3,
      0,
      NULL,
      2.967233,
      3.492838,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.701594,
      3.278284,
      NULL,
      1,
      1,
      2,
      6,
      NULL,
      6,
      3.354986,
      2.455082,
      7.461859,
      1,
      0.046614,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.853844,
      NULL,
      NULL,
      0.996451,
      NULL,
      NULL,
      1.122053,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987239,
      NULL,
      NULL,
      0.477997,
      1.767693,
      NULL,
      1.384072,
      1,
      0.568421,
      0.197601,
      NULL,
      NULL,
      1.106862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.794154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.713640,
      NULL,
      NULL,
      NULL,
      0.805750,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.771880,
      NULL,
      NULL,
      NULL,
      3.230957,
      NULL,
      NULL,
      NULL,
      2.729031,
      NULL,
      NULL,
      NULL,
      0.653980,
      NULL,
      NULL,
      NULL,
      0.436890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.216137,
      NULL,
      NULL,
      NULL,
      0.064436,
      NULL,
      NULL,
      NULL,
      2.686729,
      32,
      NULL,
      0,
      NULL,
      NULL,
      1.820810,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.441809,
      196.244358,
      9.122639,
      NULL,
      1.302749,
      0,
      0,
      0,
      1.400700,
      1.383056,
      1.657124,
      0,
      0,
      0,
      NULL,
      0.749489,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.813682,
      47,
      45,
      1.838192,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.155251,
      NULL,
      0.336357,
      NULL,
      1.302102,
      NULL,
      0.124796,
      NULL,
      0.541998,
      NULL,
      1.705062,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.133992,
      NULL,
      0.376648,
      NULL,
      0.541206,
      NULL,
      1,
      NULL,
      NULL,
      2.170491,
      0,
      0.128612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.033202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000584,
      0.581005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.426306,
      NULL,
      1.352393,
      NULL,
      1.495448,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.096477,
      0,
      NULL,
      NULL,
      1.986356,
      NULL,
      3,
      7.209684,
      1,
      2.292060,
      0,
      0,
      NULL,
      NULL,
      0.208293,
      NULL,
      NULL,
      1.142338,
      1.120873,
      NULL,
      0,
      NULL,
      NULL,
      1.074775,
      3,
      NULL,
      0,
      0.401331,
      NULL,
      1.992104,
      NULL,
      NULL,
      0.147920,
      1.286176,
      NULL,
      1.577027,
      0,
      NULL,
      3.733812,
      2.356214,
      NULL,
      NULL,
      3.355400,
      NULL,
      2,
      1,
      0.698620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024376,
      NULL,
      1.192034,
      NULL,
      1.463533,
      NULL,
      1,
      4,
      4,
      0.413204,
      NULL,
      NULL,
      39,
      NULL,
      5,
      NULL,
      5,
      '33021',
      '32004',
      NULL,
      1,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


