set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '3204240',
      2,
      0.851471,
      3,
      3,
      '0220',
      2,
      1.006802,
      NULL,
      NULL,
      ' 8-29-1996',
      8.807112,
      NULL,
      3.829071,
      1.993575,
      NULL,
      ' 2-13-1988',
      21,
      2,
      143.124585,
      40.311771,
      2,
      NULL,
      ' 9-24-2002',
      ' 7-13-1991',
      0,
      2,
      2,
      0.326933,
      0,
      NULL,
      2.692965,
      3,
      NULL,
      NULL,
      NULL,
      8.646604,
      NULL,
      24.443069,
      31.170796,
      1,
      12.987755,
      3.502786,
      2.646813,
      5,
      0.756960,
      1,
      0,
      1,
      0,
      1.192301,
      0.556818,
      0,
      0.447819,
      0.996802,
      0.166060,
      0,
      2.933490,
      3.710307,
      2.329955,
      11,
      1,
      NULL,
      0,
      NULL,
      NULL,
      5.466209,
      8,
      0.633920,
      0,
      1,
      1,
      2.770685,
      NULL,
      5.963210,
      0,
      0,
      0.733202,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.421055,
      1.894527,
      1.119523,
      2.859864,
      1,
      0.418749,
      0.039489,
      1.963843,
      1.102451,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1.431875,
      1,
      1,
      0.503157,
      1.577839,
      NULL,
      11.609633,
      1.673013,
      3,
      0.507554,
      0.559373,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      2.427225,
      1,
      1.102965,
      NULL,
      1.584111,
      1,
      0.412776,
      1.312369,
      1,
      1.129775,
      1.214862,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      6.351830,
      0.394548,
      NULL,
      1.563495,
      NULL,
      7.825870,
      8,
      3.015597,
      NULL,
      0,
      5,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.348296,
      5,
      NULL,
      8,
      9,
      6.670405,
      3.180514,
      4,
      7.469543,
      4.963946,
      2,
      '10-20-2001',
      255,
      ' 3-11-1989',
      0,
      NULL,
      0,
      1,
      0.900177,
      1.382436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.089214,
      1,
      0,
      1,
      0.812039,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      217.350748,
      NULL,
      2.808907,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.470903,
      0,
      7.350885,
      1.377500,
      3.142155,
      0.168591,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.352319,
      1.683113,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      55,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.798736,
      1,
      2,
      2,
      2.877264,
      2,
      1,
      0.528408,
      3.867779,
      2.481131,
      NULL,
      3,
      1,
      1.724096,
      1,
      1,
      0.637543,
      NULL,
      1.511561,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.884933,
      0.949526,
      0,
      0.607503,
      NULL,
      2,
      NULL,
      4.180730,
      6,
      7,
      5.980892,
      1.278430,
      5.276784,
      2,
      2.323317,
      1.908909,
      27,
      2,
      NULL,
      NULL,
      1.474029,
      13.085566,
      NULL,
      0,
      4.962964,
      3.709043,
      '44000',
      '',
      '',
      0.602656,
      '',
      '',
      '',
      1.930631,
      '',
      '',
      '',
      1,
      17.396746,
      16.655806,
      41.378089,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.710463,
      0.180775,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947730,
      NULL,
      NULL,
      1.946978,
      NULL,
      NULL,
      0.517062,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.187575,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      5.527941,
      3.616144,
      0.966245,
      1.177299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.865282,
      NULL,
      NULL,
      0.337269,
      NULL,
      NULL,
      0.670318,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215514,
      NULL,
      NULL,
      0.177003,
      NULL,
      NULL,
      1.030694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.388191,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.527397,
      NULL,
      NULL,
      0.613419,
      NULL,
      NULL,
      0,
      5,
      5,
      0.769670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.160377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.945767,
      NULL,
      NULL,
      1.008438,
      NULL,
      NULL,
      1,
      NULL,
      0.739316,
      0.157965,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      4,
      6,
      1.325218,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.745711,
      NULL,
      3.601290,
      1.580438,
      1.243797,
      2,
      0.831675,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.993914,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      3.737420,
      NULL,
      7,
      1.421518,
      4.152741,
      3,
      3,
      3.764462,
      3.190662,
      0,
      1,
      1,
      1,
      0.969406,
      0,
      1.745556,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136758,
      NULL,
      NULL,
      1.027762,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472810,
      NULL,
      NULL,
      NULL,
      0.317393,
      2.827093,
      1.103504,
      NULL,
      0.428665,
      0.202750,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      198.904659,
      NULL,
      NULL,
      NULL,
      0.408433,
      NULL,
      NULL,
      NULL,
      0.384152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.994184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.526900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.694103,
      1.370577,
      NULL,
      2,
      NULL,
      NULL,
      3.853668,
      NULL,
      2.249061,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.976690,
      253,
      NULL,
      0,
      NULL,
      1,
      1.006320,
      1.445852,
      0,
      1.044568,
      1.510351,
      0,
      0,
      1.690563,
      NULL,
      0,
      0.889952,
      1,
      0.815577,
      0,
      0.103823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.457893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.349860,
      2,
      5.861092,
      5.082418,
      5.547181,
      0.550063,
      NULL,
      3.221405,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0.408524,
      NULL,
      1.493163,
      3,
      NULL,
      1,
      0,
      NULL,
      3.495144,
      NULL,
      NULL,
      3,
      1.222496,
      NULL,
      1.557283,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1.685365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      2.461043,
      NULL,
      2.369404,
      NULL,
      NULL,
      NULL,
      0.500859,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.282962,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.993103,
      NULL,
      1,
      NULL,
      11,
      0,
      13,
      0.727792,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.675676,
      4.505883,
      NULL,
      '23132',
      '',
      NULL,
      1.501662,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


