set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9901901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.408633,
      1,
      4.905915,
      3.936497,
      3.033020,
      3.730017,
      2,
      2,
      NULL,
      '14030232',
      57.312053,
      69.051896,
      '3041343',
      0,
      0,
      NULL,
      3,
      '3203',
      6,
      NULL,
      NULL,
      NULL,
      '11-12-1980',
      235,
      66.644995,
      NULL,
      0.249585,
      NULL,
      ' 7-16-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      0.110182,
      NULL,
      ' 2- 5-1992',
      '10-10-2003',
      2.501085,
      3,
      NULL,
      NULL,
      0.303160,
      2.588040,
      5.543730,
      0,
      0,
      109.901086,
      5.969453,
      4,
      0.080054,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3.119308,
      NULL,
      1,
      1.448392,
      2.373578,
      10,
      1.538531,
      0,
      NULL,
      0.456516,
      NULL,
      0.436169,
      NULL,
      6,
      NULL,
      6.876225,
      1,
      1,
      2,
      0.219160,
      0,
      1.773423,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      3,
      8.841591,
      3.825052,
      0.685238,
      NULL,
      1.878071,
      1,
      0,
      NULL,
      2.600436,
      0,
      NULL,
      NULL,
      0.569941,
      0,
      NULL,
      3,
      2.945536,
      0.651767,
      NULL,
      1.703809,
      NULL,
      NULL,
      3.173381,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.999827,
      NULL,
      1.266363,
      2.090456,
      2.455027,
      NULL,
      NULL,
      0.070860,
      0.312576,
      5.247811,
      0.931736,
      NULL,
      NULL,
      1.501551,
      1,
      0,
      1,
      NULL,
      0.598549,
      0.280478,
      5.732184,
      NULL,
      3,
      1,
      3.877920,
      NULL,
      0,
      7,
      0,
      5,
      0.086314,
      5.391307,
      1.168152,
      5,
      6,
      7.930406,
      7.007532,
      2.320614,
      2,
      0,
      NULL,
      8.905436,
      NULL,
      6.852166,
      NULL,
      1.788413,
      ' 6- 5-1988',
      604.002029,
      ' 4- 2-1983',
      10,
      NULL,
      NULL,
      0,
      0.039844,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.075835,
      1.501227,
      0.565486,
      1.123689,
      0,
      1.972577,
      1,
      0.648917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191005,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.741088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.140683,
      3,
      3.630584,
      1.122682,
      6.915229,
      0,
      NULL,
      NULL,
      NULL,
      1.974340,
      5.701286,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.027660,
      0.838757,
      NULL,
      0.332604,
      1.365960,
      0,
      0.547636,
      3,
      24,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.287103,
      3.448642,
      1.595087,
      1,
      3,
      NULL,
      0,
      3,
      3,
      1.078767,
      2.350851,
      1.871361,
      3.542131,
      0,
      2,
      0.340270,
      0.188896,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      4.979401,
      NULL,
      1,
      2,
      1.810816,
      1.126252,
      1.953379,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      3,
      2,
      4.403815,
      0.571537,
      2,
      3,
      62.213921,
      2,
      0,
      23.980031,
      NULL,
      61,
      NULL,
      NULL,
      1.390835,
      3.831660,
      NULL,
      '',
      '',
      0.228368,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      2.460632,
      56,
      0.624027,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.838190,
      NULL,
      NULL,
      1.130345,
      NULL,
      NULL,
      0.259969,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      0.588236,
      3.764551,
      0,
      NULL,
      NULL,
      2,
      0,
      0,
      1.373323,
      NULL,
      NULL,
      0.847449,
      NULL,
      NULL,
      0.077180,
      NULL,
      NULL,
      0,
      5.631561,
      0,
      0.028660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.276578,
      1.130913,
      1.976228,
      0,
      3.983768,
      1,
      1.282424,
      3,
      1.525791,
      1.930548,
      1,
      1.457167,
      0,
      1.099181,
      0,
      1,
      2,
      2,
      0,
      3.448596,
      1.188401,
      2.583275,
      0,
      NULL,
      NULL,
      0.012136,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.005268,
      0.476508,
      0,
      0,
      0.886696,
      NULL,
      NULL,
      NULL,
      0.439365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.714053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.949717,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.251406,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.985658,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.556711,
      0.119062,
      1,
      NULL,
      2.927201,
      5.811798,
      4.976566,
      7.028011,
      NULL,
      1,
      1.106332,
      0,
      2,
      1,
      3,
      2,
      2,
      1.228228,
      0.241820,
      1.130917,
      3.876504,
      3.935618,
      1.527219,
      3.679252,
      0,
      0,
      1.776651,
      NULL,
      NULL,
      1.267663,
      0,
      NULL,
      1,
      NULL,
      3.839170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.223508,
      NULL,
      NULL,
      1.972736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.613924,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.938978,
      0,
      1.147197,
      0,
      1.964245,
      NULL,
      NULL,
      NULL,
      NULL,
      0.809204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.624469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.562584,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.292764,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.393540,
      NULL,
      NULL,
      NULL,
      1.483670,
      3.166618,
      0,
      0.785031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912632,
      NULL,
      NULL,
      1.560009,
      NULL,
      1.233099,
      154.265969,
      1,
      1.845257,
      1.579058,
      NULL,
      0,
      0.856693,
      0.892846,
      1,
      0,
      NULL,
      0.726831,
      0.608015,
      0.593392,
      0.697615,
      NULL,
      NULL,
      1,
      NULL,
      1.011652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.373381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.196318,
      3,
      5,
      0,
      0,
      2,
      1.387765,
      NULL,
      2.827315,
      3,
      1,
      1.247851,
      1.990204,
      NULL,
      1.448410,
      1,
      NULL,
      0.587385,
      2,
      NULL,
      1,
      3,
      NULL,
      1,
      1,
      NULL,
      0,
      0.633149,
      NULL,
      1.765713,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.683029,
      NULL,
      1,
      1,
      NULL,
      1.706827,
      1.104244,
      NULL,
      3.805905,
      1.597623,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.355019,
      NULL,
      0.902331,
      NULL,
      1.800190,
      NULL,
      1,
      7.083900,
      0.180792,
      0.743554,
      NULL,
      NULL,
      52,
      115,
      NULL,
      3.542937,
      3.299990,
      NULL,
      '',
      '',
      1.559164,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


