set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8507236';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '4101',
      NULL,
      NULL,
      3.661433,
      16,
      NULL,
      101,
      NULL,
      NULL,
      0.243601,
      0.370137,
      ' 5- 2-1979',
      14,
      2,
      229,
      86,
      4.274318,
      NULL,
      NULL,
      ' 4-10-1995',
      3.104612,
      1,
      0,
      1,
      NULL,
      0.593017,
      0.890423,
      0.232696,
      0,
      NULL,
      9,
      9.244608,
      6,
      NULL,
      4.975749,
      NULL,
      24,
      NULL,
      0,
      NULL,
      2.401786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      4,
      1.028904,
      4.872343,
      1,
      NULL,
      1,
      1.941006,
      0.981779,
      3.038535,
      0.158448,
      0,
      1.798502,
      0,
      1,
      5.295914,
      NULL,
      NULL,
      1.142387,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.125172,
      1,
      0.582911,
      1.700066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.139358,
      1,
      NULL,
      1,
      NULL,
      0.111461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448994,
      1,
      1,
      1,
      0.521404,
      3.936569,
      6.555580,
      NULL,
      NULL,
      5,
      1,
      5.326326,
      1.906918,
      2,
      0.334855,
      NULL,
      0,
      2.387774,
      0,
      NULL,
      0,
      1,
      NULL,
      1.300018,
      6.094839,
      NULL,
      2,
      4,
      0,
      0,
      NULL,
      2,
      5.884453,
      1.538559,
      1,
      0.023527,
      0.157684,
      3,
      5,
      2,
      6.424787,
      1,
      5,
      3,
      4,
      8.205089,
      7.894544,
      0,
      ' 1-26-1992',
      936,
      ' 6- 1-1992',
      NULL,
      0,
      2.239497,
      NULL,
      6.913887,
      0.422943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937123,
      NULL,
      1.363982,
      0,
      0.199038,
      1.433345,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.087499,
      NULL,
      NULL,
      NULL,
      NULL,
      0.978009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.357070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.849651,
      0.436066,
      0.041669,
      0,
      NULL,
      0.263342,
      NULL,
      NULL,
      NULL,
      0.193416,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.631477,
      1.824556,
      2,
      0.885868,
      0,
      1.720949,
      NULL,
      3.655702,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      2,
      3,
      2,
      3,
      2.644920,
      3.608360,
      1,
      0.932764,
      NULL,
      2,
      2.537734,
      2,
      3,
      3.167984,
      NULL,
      1.905895,
      1.368887,
      0,
      1.584659,
      1.442162,
      NULL,
      NULL,
      1,
      1,
      1.231452,
      1,
      0,
      NULL,
      0.198580,
      3,
      6.088298,
      3.032373,
      NULL,
      0,
      2,
      0.295610,
      NULL,
      6,
      3.006742,
      0.144200,
      1,
      19.252101,
      1.379657,
      1,
      20,
      NULL,
      NULL,
      NULL,
      1.146196,
      1,
      2.024818,
      '11034',
      '',
      '',
      0.412203,
      '',
      '',
      '',
      0.087826,
      NULL,
      '',
      '',
      0.144099,
      NULL,
      359.953068,
      17,
      0.642809,
      22,
      18,
      22.195170,
      5.139927,
      3.260305,
      2.208482,
      2,
      NULL,
      NULL,
      NULL,
      3.951167,
      1.514592,
      NULL,
      3,
      NULL,
      1.785865,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.861890,
      1.227140,
      1.804112,
      NULL,
      NULL,
      1.706883,
      NULL,
      NULL,
      NULL,
      3.216708,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      7,
      3,
      1.156810,
      0.931497,
      NULL,
      NULL,
      0,
      3.137822,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.883476,
      NULL,
      NULL,
      NULL,
      0.035419,
      NULL,
      NULL,
      2.753965,
      0,
      0.118550,
      0,
      0.881699,
      3.266554,
      NULL,
      1,
      0,
      0.471416,
      0,
      0,
      NULL,
      0,
      1,
      1.401261,
      2.276129,
      2.015857,
      0.623420,
      0,
      NULL,
      NULL,
      1.198996,
      NULL,
      NULL,
      0,
      2.823283,
      3.926762,
      3,
      1,
      0,
      0.827614,
      1.308952,
      1.780906,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.013889,
      NULL,
      1,
      1,
      2.809003,
      0.539122,
      3.833283,
      8.708112,
      14.691108,
      6.493801,
      NULL,
      5,
      2.002966,
      0.188405,
      3,
      3,
      0.036360,
      1,
      6.291194,
      4.085320,
      3,
      1.966168,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.243544,
      1.209723,
      1.985126,
      NULL,
      NULL,
      4,
      0,
      0.460568,
      0.665929,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.889489,
      NULL,
      7.460263,
      7.810008,
      NULL,
      1,
      0,
      3.632329,
      2,
      1.212360,
      3.088502,
      2,
      NULL,
      NULL,
      3,
      1.778736,
      2.749599,
      0,
      9.437995,
      3,
      NULL,
      NULL,
      3,
      2,
      3.245234,
      2,
      0.072555,
      2,
      3,
      2.417677,
      2,
      1,
      11,
      2.002069,
      0,
      6,
      3,
      NULL,
      1.305828,
      7.707308,
      NULL,
      0.053256,
      1,
      1.070267,
      2.679132,
      2.529503,
      NULL,
      NULL,
      0.298010,
      NULL,
      33,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.865812,
      NULL,
      NULL,
      3.289461,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.806967,
      0.642461,
      NULL,
      0,
      NULL,
      NULL,
      0.537103,
      0,
      NULL,
      1,
      0,
      NULL,
      2.936114,
      NULL,
      NULL,
      1.731965,
      2.566060,
      NULL,
      NULL,
      5.105512,
      NULL,
      2,
      1.572453,
      NULL,
      1.791915,
      0.302233,
      NULL,
      3.392408,
      0.204465,
      NULL,
      NULL,
      0,
      0.893703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401086,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.929181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112696,
      NULL,
      NULL,
      NULL,
      0.290845,
      1,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.155363,
      3,
      NULL,
      NULL,
      1,
      0.710405,
      NULL,
      NULL,
      2.319625,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.856966,
      5,
      NULL,
      NULL,
      1.832368,
      NULL,
      NULL,
      NULL,
      3.859030,
      NULL,
      55.333875,
      0.341479,
      3.242057,
      1.363399,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      60,
      2,
      108.979984,
      NULL,
      0.058331,
      NULL,
      0,
      1226.786726,
      8,
      NULL,
      0.386445,
      NULL,
      0,
      0,
      3,
      1,
      3.137940,
      1,
      NULL,
      0.493735,
      2,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.764565,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3.021793,
      NULL,
      0.943043,
      NULL,
      22,
      NULL,
      4.802462,
      0,
      23.100712,
      0,
      3.525355,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.977367,
      NULL,
      0.416409,
      NULL,
      0.796545,
      NULL,
      2,
      NULL,
      0.337070,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.391108,
      NULL,
      NULL,
      NULL,
      0.782762,
      NULL,
      NULL,
      2,
      0.297375,
      0.685989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.090591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.731931,
      NULL,
      0,
      NULL,
      0.309416,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.092849,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.635368,
      0.761498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.902947,
      NULL,
      2.078035,
      NULL,
      2,
      NULL,
      122.314963,
      NULL,
      5.692207,
      NULL,
      3.045657,
      NULL,
      2.028785,
      NULL,
      1.664875,
      9,
      1.386166,
      3.038873,
      1,
      1,
      0.521048,
      4.103460,
      NULL,
      2,
      7,
      4.059464,
      5,
      1,
      3,
      NULL,
      1.755768,
      NULL,
      2,
      1.664447,
      0.372646,
      NULL,
      1.010073,
      2.251219,
      NULL,
      0,
      0.662353,
      0,
      1,
      1,
      0,
      1,
      3.855646,
      2.462399,
      1,
      1.986113,
      1,
      NULL,
      3,
      NULL,
      1.913353,
      NULL,
      1,
      0,
      0.188430,
      3,
      0,
      NULL,
      2.732628,
      NULL,
      1.520389,
      NULL,
      0.561010,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1.422804,
      NULL,
      2,
      10.013250,
      4.246532,
      2.780739,
      0.161089,
      NULL,
      NULL,
      10.535681,
      1,
      1,
      6,
      '12400',
      '41344',
      '20431',
      1.154921,
      '',
      NULL,
      '',
      5,
      '2400',
      '1130',
      '');
commit;
end;
/


