set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9697829';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '14',
      '23',
      18,
      24,
      '4132302',
      NULL,
      0,
      0,
      3,
      '1413',
      3.305138,
      0,
      NULL,
      NULL,
      ' 8-19-1990',
      NULL,
      2.696635,
      NULL,
      1.532471,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 3-18-1999',
      ' 0- 3-1984',
      ' 8-20-1980',
      NULL,
      1,
      NULL,
      1.819563,
      0,
      2.366063,
      7.162359,
      NULL,
      1,
      4,
      9.202948,
      17.421667,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7.142498,
      NULL,
      NULL,
      0,
      0,
      0.127947,
      0.358443,
      1,
      1.868809,
      0.526456,
      1,
      1.055499,
      0.972059,
      1,
      0,
      13,
      9,
      0.545529,
      NULL,
      0,
      NULL,
      3.121969,
      0.248791,
      0.318797,
      1,
      4.695834,
      NULL,
      1.264959,
      NULL,
      3.773677,
      NULL,
      0.238356,
      2,
      1,
      3.058235,
      1,
      NULL,
      NULL,
      0.047944,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1.023540,
      0.708279,
      1.101468,
      1.452370,
      0.070472,
      2,
      2.432648,
      2,
      1,
      0.984251,
      NULL,
      1,
      NULL,
      1.243958,
      3,
      3,
      0.451888,
      0,
      1,
      9,
      0.804801,
      4,
      0.453594,
      NULL,
      NULL,
      NULL,
      0.688735,
      NULL,
      NULL,
      0.645909,
      0,
      4.133174,
      1.038876,
      6.297955,
      4,
      5.921501,
      NULL,
      0,
      3.782927,
      2,
      0.845600,
      1,
      0.884468,
      0.477700,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      7.763346,
      0,
      0,
      1,
      5,
      0,
      0,
      0,
      6,
      0,
      1.990709,
      0,
      1,
      1.478700,
      NULL,
      0.539698,
      2.269573,
      NULL,
      5,
      10.068653,
      NULL,
      9.424865,
      1,
      2,
      NULL,
      2,
      NULL,
      17.999088,
      ' 6-17-1977',
      15.690780,
      1,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.747826,
      NULL,
      3.695476,
      1.713745,
      3,
      0.905330,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.086446,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980788,
      NULL,
      0,
      0,
      1,
      0.178611,
      1.452406,
      NULL,
      NULL,
      NULL,
      1.212595,
      1.031673,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.273780,
      0,
      0.313558,
      0.173644,
      NULL,
      1.809164,
      0.817282,
      NULL,
      64.740753,
      2.183981,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.704826,
      NULL,
      2.467657,
      0,
      2,
      2,
      NULL,
      3.645144,
      NULL,
      NULL,
      3.569932,
      NULL,
      0,
      0.649379,
      1.001872,
      1.946516,
      0,
      3.456973,
      NULL,
      0.862566,
      1.310177,
      0.852798,
      0.273834,
      NULL,
      1,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      1.299954,
      7,
      2,
      1.759582,
      1,
      1.857821,
      3,
      4,
      0.871920,
      1.868565,
      NULL,
      19.637101,
      1.613760,
      3.957957,
      22,
      NULL,
      5.847766,
      29,
      0,
      NULL,
      1,
      '40041',
      '',
      '',
      0.660230,
      '',
      '',
      '',
      1.283570,
      NULL,
      '',
      NULL,
      NULL,
      16.069071,
      0.537515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.961702,
      0,
      0,
      0.787483,
      NULL,
      NULL,
      1.185991,
      NULL,
      NULL,
      0.877935,
      NULL,
      NULL,
      0.818084,
      NULL,
      NULL,
      0.267201,
      NULL,
      NULL,
      1,
      NULL,
      0.402818,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1.137731,
      NULL,
      0.845986,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.515625,
      1.007187,
      1.744747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.772273,
      0.584626,
      2.009346,
      1.878282,
      0.831472,
      0.992154,
      3,
      0.652973,
      2,
      NULL,
      3.208757,
      NULL,
      0.642844,
      1.077741,
      0.989789,
      NULL,
      1.078294,
      0.192384,
      1,
      NULL,
      3,
      0,
      1,
      NULL,
      0,
      1.264967,
      0,
      0,
      NULL,
      NULL,
      0.440116,
      1,
      3,
      NULL,
      0.791231,
      2.968901,
      NULL,
      NULL,
      3,
      NULL,
      1.235741,
      1,
      1,
      NULL,
      2,
      0.196248,
      3,
      0.051962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.187599,
      1,
      NULL,
      0.925785,
      0.834966,
      7.905519,
      0.951233,
      3.894748,
      0,
      NULL,
      NULL,
      33.914777,
      85.381461,
      NULL,
      3,
      1,
      '44111',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.164069,
      '',
      '',
      '');
commit;
end;
/


