set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      '1103',
      0.171829,
      0,
      NULL,
      NULL,
      '10-12-1977',
      57,
      NULL,
      5.251624,
      0.791364,
      0.374679,
      ' 9- 1-2000',
      2.794684,
      0,
      54,
      NULL,
      3.930850,
      '11-14-2002',
      ' 9-11-1994',
      ' 5-17-1988',
      1.786357,
      0.971298,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.902315,
      4.455352,
      3,
      3.193717,
      NULL,
      5.682011,
      22,
      7,
      NULL,
      3,
      1.629041,
      4.414731,
      0.704082,
      1,
      1.481713,
      1,
      0.539224,
      1,
      NULL,
      1,
      0.182095,
      2,
      1,
      NULL,
      NULL,
      0,
      2.827804,
      1,
      2.604588,
      0,
      5,
      2,
      3.842231,
      5.239104,
      0.821974,
      4,
      1,
      0.046473,
      1.844216,
      NULL,
      1,
      1,
      1.550567,
      0,
      0.576147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.831885,
      1,
      NULL,
      NULL,
      1,
      1.983465,
      1,
      0.308772,
      1,
      0,
      NULL,
      1.668533,
      1,
      0,
      1,
      3,
      NULL,
      0,
      1,
      5.405857,
      1,
      NULL,
      5,
      3.107134,
      5.723349,
      1.614861,
      NULL,
      NULL,
      NULL,
      1.563182,
      NULL,
      NULL,
      0.602060,
      NULL,
      5.933989,
      0,
      5,
      1.743680,
      4,
      0,
      0.518381,
      6.458004,
      0,
      2,
      1,
      2.316809,
      NULL,
      NULL,
      1,
      0,
      0.853497,
      NULL,
      0.694343,
      1.468990,
      3.777668,
      1.940191,
      0.193358,
      0.519739,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3.382624,
      NULL,
      0,
      0,
      NULL,
      2,
      0,
      NULL,
      0,
      1,
      NULL,
      4,
      8.363175,
      NULL,
      3.073811,
      '11-11-1989',
      1,
      ' 2- 3-1991',
      16,
      2.474829,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.392826,
      NULL,
      0,
      1.276395,
      0,
      0,
      0.764611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.246525,
      NULL,
      2,
      0,
      0,
      1,
      0.611198,
      0.378875,
      3.704798,
      3.002914,
      NULL,
      4.038236,
      3,
      1.255355,
      NULL,
      NULL,
      NULL,
      6,
      0,
      4.318735,
      5,
      NULL,
      4.971664,
      3.930841,
      0,
      0.520376,
      3.912091,
      0.368970,
      7,
      0.852214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.806651,
      NULL,
      1.572919,
      0,
      0.663877,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.955344,
      NULL,
      3,
      NULL,
      0.669451,
      2,
      0.945110,
      3.808650,
      NULL,
      2,
      2.951347,
      0,
      0,
      12.181296,
      0,
      0.396974,
      NULL,
      NULL,
      1,
      0.727400,
      NULL,
      1,
      0,
      1.735891,
      0,
      1.946302,
      1,
      6,
      2.703859,
      0,
      8.768199,
      10,
      7,
      1,
      6.049569,
      0.137729,
      2,
      3,
      4.490084,
      3,
      0,
      NULL,
      NULL,
      1,
      0.901077,
      NULL,
      1,
      38,
      NULL,
      NULL,
      5,
      6.471240,
      NULL,
      '22232',
      '30021',
      1.975623,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.702067,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.457604,
      0,
      NULL,
      NULL,
      0.537680,
      0,
      NULL,
      2.469653,
      NULL,
      0,
      NULL,
      3.673860,
      1,
      0.061313,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      29.812725,
      48,
      3.960814,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.048117,
      1.906223,
      1,
      NULL,
      NULL,
      1.218908,
      0.599268,
      1,
      0,
      NULL,
      1.657413,
      1.514921,
      NULL,
      NULL,
      NULL,
      NULL,
      0.672191,
      NULL,
      NULL,
      0,
      NULL,
      0.131632,
      0.480571,
      0,
      0,
      1.717311,
      0,
      NULL,
      0.257100,
      0,
      0.874999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.901538,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.358704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.966125,
      1,
      3.012717,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.341192,
      NULL,
      0,
      0.935234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.884407,
      NULL,
      1.503761,
      NULL,
      1.164166,
      NULL,
      NULL,
      NULL,
      2.200011,
      3.824222,
      NULL,
      0,
      NULL,
      3.893526,
      NULL,
      601,
      NULL,
      1,
      NULL,
      2.043619,
      NULL,
      1.307948,
      NULL,
      2,
      2.171482,
      11,
      NULL,
      0,
      1.936411,
      0.613221,
      NULL,
      NULL,
      1,
      3.377011,
      4.047681,
      0.344552,
      NULL,
      0,
      2.614135,
      0.510017,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.520769,
      NULL,
      1,
      0.384462,
      NULL,
      1.195123,
      1,
      NULL,
      0.617941,
      0,
      NULL,
      1,
      0.983011,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      2.413780,
      1.873871,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.521215,
      5,
      NULL,
      1.931593,
      NULL,
      NULL,
      96,
      NULL,
      2,
      3.829327,
      0.077332,
      NULL,
      '14321',
      '41140',
      1.861261,
      '',
      '',
      NULL,
      0.602683,
      '',
      '',
      NULL);
commit;
end;
/


