set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.052530,
      1.521353,
      4,
      2.562172,
      2.560156,
      3.930347,
      3,
      0,
      '21',
      '22',
      4,
      2,
      '2111243',
      1.557114,
      NULL,
      1,
      2,
      '4102',
      5,
      0,
      NULL,
      NULL,
      ' 6- 5-1979',
      68,
      56.106705,
      NULL,
      NULL,
      0.787836,
      ' 7-13-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 7-1983',
      NULL,
      NULL,
      1.922673,
      3,
      2.492963,
      2.336353,
      1,
      0.313380,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.224778,
      3,
      NULL,
      1,
      NULL,
      3,
      1.410958,
      0.171419,
      0,
      0,
      0.806885,
      1.019602,
      1,
      1.515617,
      3,
      3.741638,
      1.713472,
      0.588518,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.647601,
      3,
      NULL,
      4.432598,
      4,
      NULL,
      1,
      3.823958,
      1,
      1.274711,
      2.656156,
      NULL,
      0,
      NULL,
      NULL,
      0.918323,
      NULL,
      NULL,
      2.156058,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.802171,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.766931,
      1.607379,
      NULL,
      0.827300,
      1.712506,
      1,
      NULL,
      1,
      0,
      0.385706,
      0.841971,
      1,
      1,
      0.525571,
      1,
      NULL,
      0,
      NULL,
      0,
      0.925444,
      1.543125,
      3,
      0.102192,
      NULL,
      NULL,
      0,
      5.535670,
      NULL,
      0,
      0.756235,
      1,
      0.780210,
      0.817113,
      NULL,
      4.911342,
      5.207525,
      9,
      5.110198,
      1,
      0.242223,
      3.472244,
      0,
      7,
      3,
      NULL,
      2,
      ' 9- 0-1983',
      8,
      ' 8- 4-1994',
      0.096466,
      NULL,
      2,
      1.869219,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654059,
      0,
      NULL,
      0,
      NULL,
      1,
      2.264277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.375049,
      1,
      0.436477,
      NULL,
      0.470337,
      7.711733,
      0,
      0.680236,
      3,
      1,
      1,
      0,
      1.043667,
      0.157419,
      7.466058,
      3.229467,
      1,
      0,
      2.496767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.911906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.144598,
      0,
      NULL,
      0,
      1.873854,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473421,
      1,
      0,
      1,
      NULL,
      NULL,
      3.416300,
      1.591040,
      NULL,
      3,
      2,
      NULL,
      3,
      2.763438,
      1,
      NULL,
      0,
      0,
      1.851311,
      0.681548,
      1,
      1,
      1.988292,
      1.570638,
      0.713414,
      0,
      1.662562,
      NULL,
      0,
      NULL,
      1,
      NULL,
      7,
      NULL,
      6,
      9.903893,
      2.701706,
      4.613813,
      2.196013,
      2,
      0.405970,
      NULL,
      1,
      3.479069,
      25.879604,
      1.739902,
      2.110777,
      20.554858,
      NULL,
      60,
      NULL,
      3,
      5.962278,
      3,
      '00440',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      25.251539,
      47,
      25,
      3,
      30.902164,
      3.729295,
      NULL,
      NULL,
      1,
      1.566251,
      1,
      2.461876,
      0.503126,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.702611,
      3,
      0.530207,
      0,
      NULL,
      NULL,
      0,
      3,
      1,
      2,
      2.697428,
      1.413105,
      2,
      3,
      NULL,
      2,
      1,
      NULL,
      6,
      2,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.833296,
      NULL,
      NULL,
      0.999788,
      NULL,
      NULL,
      1,
      1,
      0,
      0.342223,
      1.486634,
      0,
      1,
      3.200993,
      3,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      1.337834,
      1.280789,
      1,
      2.761119,
      1,
      7,
      0,
      0.183640,
      0,
      1.542460,
      NULL,
      NULL,
      NULL,
      1.882640,
      1.461121,
      NULL,
      1.681226,
      1,
      NULL,
      NULL,
      2.318124,
      NULL,
      1.314364,
      3,
      0,
      1,
      1.791426,
      NULL,
      NULL,
      2.520381,
      4,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.879178,
      NULL,
      NULL,
      0.159586,
      NULL,
      NULL,
      1,
      NULL,
      1.728172,
      1,
      3.859727,
      1,
      NULL,
      5.749139,
      0,
      NULL,
      1.069656,
      1.401621,
      5,
      0.349374,
      0,
      1.189646,
      0,
      NULL,
      2.327295,
      2,
      2.877055,
      3.116379,
      NULL,
      2,
      2.093674,
      2,
      5,
      3.481337,
      2,
      1.322800,
      3,
      0.671118,
      1.448257,
      2,
      NULL,
      3.519219,
      3.789933,
      1.198565,
      3,
      0,
      1.223327,
      0.103972,
      0.910525,
      7.160127,
      NULL,
      1.739113,
      5,
      4,
      1,
      1,
      1.472360,
      0.095322,
      1.219232,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.321589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.436997,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.135117,
      0,
      3.166247,
      NULL,
      1.602971,
      3.721533,
      NULL,
      NULL,
      NULL,
      3,
      3.822011,
      NULL,
      4,
      4,
      NULL,
      NULL,
      NULL,
      1.984326,
      NULL,
      NULL,
      0,
      0.680511,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.694093,
      NULL,
      NULL,
      NULL,
      3,
      0.840818,
      1.628042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.713463,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.613134,
      NULL,
      NULL,
      NULL,
      2.583215,
      3,
      NULL,
      2.096976,
      2.685400,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.909182,
      1.363885,
      NULL,
      NULL,
      0.725986,
      1,
      1.005724,
      NULL,
      12,
      NULL,
      3,
      NULL,
      1.267816,
      1.032295,
      NULL,
      NULL,
      NULL,
      1,
      9.921507,
      6.116001,
      3,
      6,
      NULL,
      1,
      NULL,
      NULL,
      0.890960,
      NULL,
      NULL,
      1.419050,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.530044,
      NULL,
      1.594158,
      NULL,
      13,
      1.281626,
      0.052066,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1.373313,
      0.741555,
      0,
      0,
      NULL,
      0.238487,
      NULL,
      2.006227,
      NULL,
      NULL,
      NULL,
      1.311340,
      NULL,
      1.966835,
      NULL,
      3,
      NULL,
      0.556633,
      NULL,
      94.096679,
      NULL,
      5.103882,
      11,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.666825,
      NULL,
      1.055892,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.558737,
      NULL,
      1.208626,
      NULL,
      NULL,
      NULL,
      1,
      2.980478,
      1.313765,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.953266,
      0.871363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023775,
      1,
      NULL,
      1.800682,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.043613,
      NULL,
      1,
      1,
      3,
      NULL,
      3.538313,
      NULL,
      1.099363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.112677,
      0.812689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.058433,
      2,
      NULL,
      1.974164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0.753514,
      1,
      3,
      NULL,
      NULL,
      75.970186,
      302,
      2.955960,
      0.142791,
      1.826137,
      3,
      0,
      2.817841,
      3.826151,
      0,
      30.665486,
      NULL,
      2,
      0,
      0.970600,
      NULL,
      3.236899,
      1,
      NULL,
      NULL,
      1,
      1,
      2,
      1.422412,
      5.264833,
      3,
      3.019183,
      3,
      1,
      1,
      0.040374,
      1,
      0,
      0,
      0,
      2,
      1.283964,
      1.552627,
      NULL,
      1.745078,
      1,
      NULL,
      0.807353,
      0.068018,
      0.358122,
      1.982743,
      1.889254,
      NULL,
      0,
      1,
      NULL,
      1.628755,
      1.490909,
      0,
      1.171738,
      1.114732,
      0,
      3,
      0.236900,
      1.173254,
      2.805011,
      0,
      0,
      1.903056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.927715,
      0.839487,
      0,
      3,
      0.211377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77.758615,
      0.922602,
      5.212153,
      0.336606,
      '21113',
      '42311',
      '41420',
      0.054974,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


