set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102851';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      '4041',
      0,
      1.141464,
      NULL,
      NULL,
      NULL,
      42,
      NULL,
      NULL,
      1.165041,
      4,
      ' 9-19-1996',
      NULL,
      1,
      116.120422,
      NULL,
      2.550931,
      ' 7- 6-1991',
      ' 0-13-1981',
      ' 3-17-1985',
      2.003710,
      3.625741,
      NULL,
      1,
      1.104425,
      0,
      2,
      NULL,
      0,
      NULL,
      3,
      7.834353,
      2,
      NULL,
      15.154812,
      6,
      NULL,
      0.426148,
      0.291952,
      6,
      1,
      1,
      NULL,
      NULL,
      0.937815,
      NULL,
      1,
      1.740198,
      0,
      1.603261,
      1,
      0.936074,
      3.860646,
      1.558210,
      0.896805,
      NULL,
      0,
      0,
      0,
      1.091746,
      1,
      0.548454,
      NULL,
      1.720647,
      0.313035,
      1.923377,
      NULL,
      3.603727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.224065,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.959680,
      0,
      0.379716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.020716,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.634864,
      0,
      0,
      NULL,
      NULL,
      0,
      0.956518,
      1.849829,
      NULL,
      0,
      NULL,
      0.169965,
      0.023561,
      1.865796,
      1,
      NULL,
      0.439555,
      3.862935,
      1,
      1,
      0,
      6,
      1,
      0,
      2.566778,
      0,
      1.887436,
      0,
      3.904269,
      7,
      11.398676,
      4,
      4.212540,
      NULL,
      1,
      1.424592,
      NULL,
      1.796844,
      NULL,
      '10-21-1985',
      NULL,
      ' 9-25-1993',
      64,
      0.395795,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.900201,
      1.469443,
      NULL,
      NULL,
      NULL,
      1.881204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794979,
      NULL,
      NULL,
      NULL,
      NULL,
      1.556460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.113745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      0,
      0.606084,
      0,
      2,
      0,
      NULL,
      3,
      NULL,
      2.341228,
      1.478626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.505985,
      1.591063,
      NULL,
      0,
      21.166459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      3.032565,
      2.189961,
      0.262306,
      3.254988,
      2,
      2,
      2,
      2.772811,
      3.964592,
      2.178058,
      3.796536,
      5.194990,
      0.571994,
      3,
      NULL,
      0,
      3,
      NULL,
      1.707882,
      0.044774,
      0,
      0.715587,
      1.779430,
      1,
      1.395704,
      1,
      0.268217,
      3.216487,
      0,
      NULL,
      7.557388,
      4,
      NULL,
      10.332100,
      2,
      1.758203,
      0,
      1,
      3.467375,
      0,
      0,
      25,
      1,
      NULL,
      NULL,
      27,
      39,
      66.634699,
      3.742787,
      1.083491,
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.043913,
      13.236263,
      35,
      1.974141,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647496,
      NULL,
      NULL,
      1.985438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.174913,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.568123,
      NULL,
      NULL,
      1.022554,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.313066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.307343,
      NULL,
      NULL,
      1.396465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289158,
      NULL,
      NULL,
      1.910934,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.784230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.873311,
      NULL,
      NULL,
      NULL,
      1.901714,
      2,
      0,
      2,
      1.015795,
      NULL,
      0.688564,
      0.748191,
      NULL,
      7.063637,
      4,
      0.617519,
      NULL,
      NULL,
      0.334111,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.675665,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.904597,
      NULL,
      NULL,
      2,
      0.836011,
      3.926809,
      NULL,
      NULL,
      NULL,
      2.113241,
      2,
      5,
      0,
      0.607485,
      5.528568,
      0.148956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      1,
      2,
      2.479859,
      3,
      1,
      NULL,
      0.763417,
      0.709776,
      1,
      0.850807,
      NULL,
      2.614571,
      1,
      3.891825,
      1.078477,
      9.485556,
      8.183167,
      NULL,
      1,
      NULL,
      NULL,
      0.304058,
      4.960247,
      2.949411,
      1,
      1,
      1.893756,
      0,
      1,
      1,
      NULL,
      NULL,
      1.891171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.388528,
      NULL,
      NULL,
      1.493263,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.388709,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.065815,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.131688,
      NULL,
      0.176535,
      NULL,
      1.602821,
      NULL,
      NULL,
      2.731097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.818234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.510745,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.118582,
      NULL,
      NULL,
      NULL,
      1.584120,
      NULL,
      NULL,
      NULL,
      0.841446,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.290302,
      1.536421,
      1.033757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.913523,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081453,
      NULL,
      0.717752,
      38.065631,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.045309,
      NULL,
      0,
      0.773987,
      NULL,
      1.261047,
      0.304474,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.995756,
      1.361866,
      2,
      5.258077,
      NULL,
      3,
      4.856547,
      NULL,
      11,
      1.465667,
      NULL,
      1,
      1.154557,
      0.206078,
      NULL,
      1.379527,
      1.484287,
      NULL,
      1.815305,
      1.023130,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.644859,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.475868,
      NULL,
      1.902957,
      3,
      NULL,
      0.442827,
      3,
      NULL,
      1.942520,
      2,
      NULL,
      NULL,
      1.428043,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.285627,
      NULL,
      1.977587,
      NULL,
      1,
      NULL,
      2,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      41.315250,
      2.151387,
      NULL,
      1.293422,
      '',
      '',
      '',
      NULL,
      '02424',
      '',
      '',
      1,
      NULL,
      '',
      NULL);
commit;
end;
/


