set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7317977';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-10-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      2.939343,
      1.540002,
      NULL,
      NULL,
      NULL,
      1.594970,
      NULL,
      NULL,
      0.076688,
      NULL,
      ' 5- 5-2001',
      NULL,
      1.806272,
      104,
      34,
      2.315109,
      ' 9-14-2002',
      NULL,
      ' 6- 4-1989',
      1,
      2,
      2,
      3.373809,
      0,
      1,
      3,
      1.651736,
      0,
      11.520826,
      3,
      12.808594,
      0.293716,
      13.569100,
      2,
      2.970582,
      9,
      3,
      1.690101,
      1.612878,
      NULL,
      1,
      1.095773,
      NULL,
      1.671364,
      0.344135,
      1,
      0.930151,
      NULL,
      0.596714,
      26,
      11,
      NULL,
      4,
      2.173395,
      NULL,
      1,
      0,
      2,
      3,
      1,
      5,
      3,
      2.848924,
      4,
      1,
      1.965340,
      7.841484,
      NULL,
      NULL,
      1,
      0.866300,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.944920,
      1,
      3,
      3,
      0.634438,
      1.955289,
      3,
      2,
      NULL,
      3.265411,
      3,
      2.124558,
      3,
      1,
      1.764208,
      2,
      1,
      NULL,
      2,
      1.632551,
      1.568366,
      3,
      11,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.882100,
      NULL,
      NULL,
      0.863620,
      NULL,
      0.784926,
      0,
      0.875657,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.338083,
      0.268805,
      0.552987,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0.598358,
      0.651101,
      0.053322,
      0.759021,
      2,
      0,
      1.717993,
      2,
      7.394459,
      2.718560,
      1.865373,
      NULL,
      NULL,
      5,
      9,
      NULL,
      3.134816,
      7,
      0,
      5,
      2.996751,
      2.371549,
      ' 5-13-1997',
      47,
      ' 8-14-1974',
      3.977412,
      3.346048,
      NULL,
      NULL,
      2.140286,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.221107,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.348897,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.737513,
      NULL,
      39,
      3.580980,
      0.006628,
      3.991716,
      NULL,
      1,
      0,
      1.299633,
      2.387481,
      2.661170,
      0,
      NULL,
      NULL,
      1,
      3,
      1,
      0,
      5,
      4.834889,
      1.705337,
      3.624164,
      1.598892,
      NULL,
      NULL,
      NULL,
      1,
      0.745450,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023948,
      NULL,
      0.332739,
      1.418548,
      1,
      1,
      NULL,
      1.014313,
      1,
      0.469806,
      NULL,
      NULL,
      NULL,
      NULL,
      1.801853,
      3.655405,
      NULL,
      3,
      2,
      NULL,
      1.842323,
      0,
      1.887508,
      0.548147,
      3.600351,
      3,
      0,
      1.934150,
      2,
      1.756869,
      NULL,
      1,
      3,
      0.597125,
      0,
      1.550570,
      0.648028,
      1,
      1.139364,
      NULL,
      0.746970,
      NULL,
      1,
      NULL,
      0,
      5.956356,
      10,
      6,
      1,
      2,
      2,
      5.314377,
      1.489817,
      2.669796,
      3.467641,
      1.752887,
      NULL,
      57,
      1,
      2.855230,
      NULL,
      NULL,
      32.530032,
      24,
      NULL,
      NULL,
      2,
      '00330',
      '',
      '',
      1.108759,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      0.411287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.547206,
      1.493451,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.917757,
      NULL,
      NULL,
      1.845968,
      NULL,
      NULL,
      0.024909,
      NULL,
      NULL,
      1,
      NULL,
      0.122629,
      151.073916,
      5,
      NULL,
      2.638368,
      0.071655,
      3.954768,
      0.604947,
      1.024519,
      0.194481,
      3.313842,
      NULL,
      0,
      1,
      0.515988,
      1,
      1,
      0.717841,
      1,
      0,
      1,
      NULL,
      1.192560,
      NULL,
      0.888817,
      NULL,
      0.265762,
      NULL,
      1.291433,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      0.594110,
      12,
      7.685848,
      1,
      2.136791,
      3,
      NULL,
      0.678972,
      NULL,
      1,
      NULL,
      0.923979,
      NULL,
      1.648692,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.945772,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.817238,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.804602,
      NULL,
      0.093080,
      3.945159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.619392,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.569030,
      NULL,
      0,
      NULL,
      3.762425,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.822175,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.664314,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      590,
      NULL,
      2.081154,
      NULL,
      1.311516,
      NULL,
      1.685160,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.462970,
      NULL,
      2.248423,
      NULL,
      718,
      NULL,
      0.684836,
      1.939287,
      NULL,
      NULL,
      0.934203,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.564709,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      15,
      NULL,
      2.202748,
      0.688796,
      0,
      3,
      0,
      0,
      3,
      5,
      1.573194,
      0.468190,
      2,
      5,
      9.934560,
      NULL,
      1.050778,
      0,
      2,
      0.179140,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.437536,
      0,
      NULL,
      NULL,
      0.834964,
      NULL,
      NULL,
      0.849346,
      NULL,
      0.063638,
      3.103752,
      NULL,
      1,
      1.854735,
      NULL,
      1.197438,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.257646,
      1,
      NULL,
      1.868933,
      1.370757,
      0.051738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      8,
      0.215814,
      NULL,
      NULL,
      67,
      88,
      5,
      NULL,
      NULL,
      '23022',
      '02402',
      NULL,
      1,
      '',
      '',
      '',
      1.101213,
      '',
      '',
      '');
commit;
end;
/


