set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005316';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '4122022',
      NULL,
      1,
      3,
      3,
      '4424',
      1,
      1,
      NULL,
      NULL,
      NULL,
      6.895138,
      NULL,
      3,
      1.713011,
      1,
      ' 8- 2-1975',
      20,
      3.624292,
      193.112832,
      48.027789,
      NULL,
      ' 4-27-1997',
      ' 6- 9-1990',
      '10-20-1981',
      1.570505,
      3,
      3.205369,
      1.148648,
      0,
      NULL,
      0.854202,
      NULL,
      1,
      9,
      0.887963,
      15.941084,
      5,
      4,
      NULL,
      NULL,
      10.757773,
      3.587541,
      2,
      8,
      1.906342,
      NULL,
      0.030174,
      NULL,
      NULL,
      0.965482,
      1.299622,
      0,
      0.889632,
      3.469411,
      1.176005,
      5.292834,
      NULL,
      0,
      0.647106,
      NULL,
      1,
      NULL,
      0.265222,
      NULL,
      2,
      3.355170,
      3,
      1,
      NULL,
      1.704509,
      1,
      2,
      NULL,
      5,
      0.651255,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.665034,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      1.476434,
      0.243554,
      2,
      1.328801,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1.392258,
      1,
      1,
      NULL,
      0.324918,
      4,
      0,
      1,
      0,
      3.126681,
      NULL,
      1,
      0.504824,
      NULL,
      0,
      NULL,
      1.975527,
      1.044647,
      NULL,
      0,
      5.365599,
      1.603930,
      2,
      3.049694,
      NULL,
      NULL,
      7,
      5,
      1.600512,
      3,
      5,
      0,
      9.368980,
      1,
      6,
      8.084931,
      4,
      NULL,
      7,
      4.329063,
      NULL,
      1,
      2.637199,
      NULL,
      NULL,
      606.913650,
      NULL,
      NULL,
      3,
      1,
      1.782653,
      3,
      0.484367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.545593,
      0,
      0.122207,
      0,
      0,
      1,
      0.666503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      NULL,
      0,
      5,
      NULL,
      0.129749,
      NULL,
      NULL,
      4.211986,
      0.630416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.069296,
      2.340068,
      4,
      2.758485,
      NULL,
      NULL,
      3.970623,
      0.486810,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271097,
      NULL,
      1,
      0.746730,
      0,
      NULL,
      0.679509,
      46.539160,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      2.116087,
      5,
      3,
      2.570709,
      2.136356,
      0,
      1.961730,
      NULL,
      0,
      1.495320,
      NULL,
      1,
      NULL,
      4.009270,
      3.979238,
      NULL,
      NULL,
      NULL,
      102.052125,
      1,
      1.286125,
      0,
      0,
      0.683727,
      1,
      1.917075,
      1,
      NULL,
      1.495939,
      0,
      5,
      0,
      5.928822,
      1,
      2.168375,
      4,
      0.286335,
      3.949304,
      2.103145,
      3,
      3.673545,
      42,
      0.165885,
      2.406934,
      NULL,
      33,
      34,
      29,
      5.549877,
      1,
      3,
      '34324',
      NULL,
      '02110',
      1,
      '',
      '',
      '',
      4.945669,
      '34310',
      '23443',
      '',
      NULL,
      30.111619,
      152.147078,
      27.365750,
      2,
      56,
      3.768025,
      1,
      3.963050,
      2.454821,
      0,
      1.898446,
      0.806498,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.607257,
      NULL,
      NULL,
      0.414513,
      NULL,
      NULL,
      0,
      0.787517,
      0.788914,
      0,
      0.910499,
      NULL,
      0,
      NULL,
      NULL,
      0.598012,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.373109,
      NULL,
      NULL,
      1.703427,
      NULL,
      NULL,
      3.564600,
      4.052210,
      5,
      1,
      0.328939,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.092881,
      NULL,
      NULL,
      0.274879,
      NULL,
      NULL,
      1.524038,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.112891,
      NULL,
      NULL,
      1.985292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.663566,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.725839,
      NULL,
      NULL,
      1.260034,
      NULL,
      NULL,
      0.477614,
      NULL,
      NULL,
      1.082720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.592329,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.166571,
      4,
      NULL,
      2,
      3,
      1,
      1,
      NULL,
      NULL,
      2,
      2.236195,
      NULL,
      0.045512,
      NULL,
      NULL,
      1.322029,
      1,
      NULL,
      3.399625,
      3,
      1.480873,
      0.123819,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513911,
      1.994398,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.857186,
      4.534423,
      0.844872,
      1.226142,
      0,
      1,
      0.909292,
      1.100321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433936,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.535363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.086668,
      1.192058,
      1,
      0.197662,
      0.251046,
      0,
      1.234626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.145450,
      NULL,
      NULL,
      NULL,
      1.242907,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.846647,
      2.116982,
      0.504590,
      3.816024,
      2,
      1.798744,
      0,
      NULL,
      NULL,
      NULL,
      0.871440,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.155854,
      NULL,
      1.888135,
      NULL,
      10,
      2,
      1,
      1.408290,
      0,
      1,
      1.035873,
      1.958721,
      0.908539,
      0.223249,
      NULL,
      NULL,
      1.790189,
      NULL,
      0,
      1.177759,
      1.543139,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.683869,
      NULL,
      0.349437,
      NULL,
      0.896434,
      NULL,
      87,
      NULL,
      3.924420,
      NULL,
      54.766177,
      NULL,
      0.289835,
      0.751578,
      NULL,
      1,
      NULL,
      0.422537,
      NULL,
      1.184618,
      NULL,
      NULL,
      NULL,
      0.940597,
      NULL,
      0,
      NULL,
      1.604473,
      NULL,
      0.557561,
      NULL,
      0.670073,
      NULL,
      1.374549,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.184066,
      NULL,
      0.130504,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.717907,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.347116,
      1.432303,
      0.018506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941474,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.708209,
      1,
      NULL,
      2.659232,
      NULL,
      0.547591,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.459346,
      0.354323,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.968153,
      2,
      3.015836,
      6.494538,
      1.507816,
      1.813387,
      NULL,
      5,
      1,
      3,
      1,
      1.418350,
      NULL,
      1,
      NULL,
      1.241049,
      0,
      NULL,
      0.154874,
      1.767464,
      NULL,
      0.802604,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.696024,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0.287882,
      NULL,
      0.997024,
      0.020017,
      NULL,
      1.173664,
      0,
      NULL,
      0.814799,
      NULL,
      NULL,
      2,
      1.543790,
      1.262042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.519505,
      NULL,
      0.507361,
      NULL,
      NULL,
      NULL,
      NULL,
      1.105874,
      NULL,
      0,
      NULL,
      3,
      16.341811,
      57,
      NULL,
      0,
      2.283926,
      '40413',
      '13002',
      NULL,
      0,
      '',
      '',
      NULL,
      3,
      '01022',
      '40414',
      '');
commit;
end;
/


