set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9682902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '13',
      39,
      32,
      '4130141',
      2,
      1,
      2,
      1,
      '0342',
      5.792517,
      1,
      NULL,
      NULL,
      ' 1-15-1989',
      11,
      39.589263,
      NULL,
      3.177769,
      2.401614,
      ' 7-25-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      3.149908,
      ' 2- 2-1993',
      ' 5- 8-1982',
      ' 9-17-2001',
      NULL,
      0.825926,
      NULL,
      1.909588,
      0,
      2.369015,
      0,
      0.822598,
      NULL,
      4.712185,
      5,
      19.350019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.475215,
      7.137735,
      NULL,
      1.666360,
      0,
      0,
      1.571869,
      1.928199,
      0.894186,
      0,
      1,
      0.495129,
      0.086975,
      0.955704,
      2,
      1.251292,
      3,
      NULL,
      11,
      NULL,
      1,
      NULL,
      1.471521,
      4.416495,
      2.348855,
      0.029813,
      1,
      9,
      3.848608,
      9.608574,
      11.821378,
      NULL,
      3.791323,
      2.437731,
      0,
      0,
      NULL,
      NULL,
      2.717859,
      0,
      3,
      0,
      NULL,
      NULL,
      2,
      1,
      0.295102,
      1.817434,
      NULL,
      0.376708,
      1.909802,
      0,
      1.526295,
      3.767220,
      1,
      3.222985,
      1,
      NULL,
      2,
      3,
      0.198068,
      0.296729,
      NULL,
      9.088862,
      1,
      NULL,
      0.956010,
      1.216602,
      NULL,
      NULL,
      2.570526,
      2.056968,
      NULL,
      NULL,
      1.571990,
      NULL,
      0.996031,
      1.090744,
      NULL,
      1,
      0.606628,
      3,
      NULL,
      1.921902,
      1,
      NULL,
      1.624725,
      1,
      NULL,
      1.879342,
      1,
      1,
      NULL,
      4,
      3,
      0.104316,
      0,
      1.749805,
      0,
      7,
      3,
      NULL,
      NULL,
      1,
      5.903379,
      1.324368,
      5.063515,
      1.084750,
      1.576922,
      0,
      3.056124,
      6.311312,
      7.441711,
      NULL,
      5,
      4.006089,
      NULL,
      NULL,
      6,
      5.344830,
      3,
      ' 6- 8-1985',
      23.788708,
      ' 2-12-2003',
      6,
      3,
      1,
      0.182340,
      1.916763,
      1.934453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.563229,
      1.983489,
      0,
      1.062302,
      1.954300,
      0,
      0,
      0.599429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.525748,
      NULL,
      NULL,
      0,
      0.330257,
      3.955279,
      1,
      0,
      NULL,
      1,
      13,
      2,
      0,
      0.211639,
      NULL,
      1,
      3.328522,
      0.003755,
      0.522221,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.439416,
      NULL,
      NULL,
      3.166821,
      9.115658,
      0.700112,
      0.947635,
      1.262524,
      1,
      2.130392,
      ' 0-15-1985',
      12.289964,
      NULL,
      7,
      0,
      0,
      0.643006,
      0,
      1.581649,
      NULL,
      0.641748,
      0,
      1.191296,
      1.955547,
      1.212233,
      NULL,
      0.055485,
      0.071549,
      NULL,
      NULL,
      NULL,
      3.380607,
      0,
      2.267962,
      1.209650,
      0.712107,
      0.513444,
      0,
      2.945579,
      NULL,
      3,
      1,
      2.890137,
      NULL,
      0,
      2,
      0.063633,
      NULL,
      0,
      0.154668,
      1.548393,
      0.941468,
      1.995805,
      1.284222,
      1,
      0,
      0,
      0,
      0.369183,
      1.380472,
      0,
      1.702362,
      1.683383,
      10.258296,
      6,
      0,
      NULL,
      2,
      3,
      NULL,
      1,
      2.485454,
      1,
      0.405556,
      0.633850,
      9.863695,
      NULL,
      2.501635,
      51.165810,
      NULL,
      43.730498,
      42,
      2.920274,
      5.964402,
      3,
      '34010',
      '',
      '',
      1.411443,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.904492,
      16.475274,
      0.922523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.021082,
      0,
      0.555618,
      1.851955,
      1,
      0.642115,
      0,
      NULL,
      NULL,
      1.339012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.559989,
      0.726308,
      1,
      0.016413,
      NULL,
      NULL,
      0,
      1.814824,
      0,
      0,
      0.191197,
      1,
      1.957571,
      0,
      1.248943,
      0,
      1.084244,
      0,
      1.125764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.939025,
      2.941919,
      12.156906,
      1,
      6,
      5,
      1.227849,
      14,
      3.759710,
      NULL,
      1.917791,
      NULL,
      1.101210,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0.219964,
      NULL,
      NULL,
      1.400972,
      3.701989,
      NULL,
      1.472029,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.128814,
      1,
      NULL,
      2.508134,
      0.065985,
      NULL,
      0.135473,
      3,
      NULL,
      2.276781,
      2.391660,
      NULL,
      NULL,
      0.347397,
      1.553326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.423525,
      0,
      NULL,
      3,
      NULL,
      1.950714,
      NULL,
      1,
      NULL,
      3.083644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.932516,
      NULL,
      1,
      NULL,
      0.004834,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.561646,
      NULL,
      1.441834,
      NULL,
      1,
      7,
      8.520767,
      0,
      NULL,
      NULL,
      68.389835,
      90,
      1.150928,
      5,
      5,
      '04022',
      '04143',
      '2044',
      NULL,
      '43344',
      '',
      '',
      0.696579,
      '',
      '',
      NULL);
commit;
end;
/


