set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0130661';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      0.214822,
      4,
      0.973621,
      0.080474,
      0,
      NULL,
      3.796532,
      '210',
      '01103420',
      NULL,
      17,
      '2112014',
      NULL,
      1,
      2,
      1,
      NULL,
      0.513700,
      0,
      NULL,
      NULL,
      ' 3- 5-1975',
      7,
      8.777181,
      NULL,
      NULL,
      3.350262,
      '10-18-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 0-1977',
      3,
      0.770297,
      0,
      2,
      0.755046,
      NULL,
      0,
      0.503546,
      0.938379,
      0,
      10,
      5.051499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.766439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      0,
      4.218426,
      0.387100,
      1.772498,
      0,
      0.371436,
      1,
      NULL,
      1,
      6,
      1,
      0.572213,
      0.459964,
      3,
      0,
      NULL,
      1,
      3.512484,
      0,
      NULL,
      NULL,
      2.594543,
      2.688117,
      4,
      NULL,
      1.078034,
      0.638527,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.399130,
      NULL,
      1.342708,
      3,
      1.773641,
      NULL,
      NULL,
      NULL,
      1.046317,
      NULL,
      1,
      0,
      1,
      NULL,
      0.186928,
      3.164434,
      0.288650,
      0.912670,
      NULL,
      0.459448,
      NULL,
      0,
      0.066910,
      NULL,
      1.917018,
      1.728238,
      NULL,
      1,
      1,
      0,
      NULL,
      0.903218,
      8.870508,
      6,
      NULL,
      NULL,
      1,
      4.980710,
      7.744198,
      4,
      1.364982,
      2.278950,
      0,
      1,
      7,
      NULL,
      0,
      6,
      3.941101,
      5,
      NULL,
      1.468958,
      0,
      NULL,
      6,
      0.967345,
      1.141703,
      1.328051,
      2,
      ' 5-19-1982',
      524,
      ' 4-29-1977',
      NULL,
      2,
      1,
      1,
      5.148035,
      0.246077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.067817,
      0,
      0,
      0.042052,
      NULL,
      0,
      0.589310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      NULL,
      3.249858,
      5,
      NULL,
      0.701939,
      NULL,
      1,
      0,
      5.391152,
      1.007001,
      3,
      1.154000,
      0,
      2.670209,
      0,
      1,
      5.374295,
      5.064694,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      8.806401,
      2.881936,
      NULL,
      0,
      7,
      1.981043,
      NULL,
      81,
      '11-15-1983',
      60,
      0,
      1,
      1,
      2,
      2.198429,
      1.774994,
      0.712059,
      NULL,
      0.213948,
      0.317995,
      NULL,
      NULL,
      3.699128,
      0,
      NULL,
      NULL,
      NULL,
      0.969949,
      0.782307,
      NULL,
      0,
      2,
      5.930133,
      2.890648,
      NULL,
      NULL,
      5,
      2,
      NULL,
      2.073160,
      0,
      0.655203,
      1,
      2.284044,
      0,
      0,
      3.874198,
      1.990316,
      NULL,
      0.554505,
      0,
      0,
      0,
      1.224458,
      1,
      1.474323,
      0.926980,
      5,
      0,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.672748,
      1.129660,
      40.622621,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      '14040',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      2.202650,
      8.101513,
      NULL,
      NULL,
      0.233654,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.851573,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.268338,
      1,
      2.384495,
      NULL,
      NULL,
      NULL,
      2,
      0.317521,
      1.234185,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.440142,
      NULL,
      NULL,
      7.319595,
      1,
      3.625472,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.810927,
      0.596541,
      NULL,
      NULL,
      0.952348,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.198791,
      0,
      0.519958,
      NULL,
      NULL,
      NULL,
      3.965149,
      2,
      3.555294,
      NULL,
      1.355280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.208802,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.041852,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.594366,
      0.888543,
      NULL,
      0.793753,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.329428,
      NULL,
      NULL,
      1.849378,
      NULL,
      NULL,
      0.197730,
      NULL,
      NULL,
      0.196474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      4.059828,
      NULL,
      1.734269,
      2,
      5,
      0,
      1.946439,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.505912,
      3,
      1.734219,
      2,
      3.278386,
      6.607160,
      1,
      0,
      0,
      NULL,
      0.097629,
      2.349823,
      NULL,
      NULL,
      3,
      1.410662,
      0.913477,
      NULL,
      2.144085,
      0.920130,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      6,
      1,
      0.587557,
      1,
      1.236296,
      0.705959,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      2.635206,
      1.412965,
      NULL,
      7.741116,
      3.897267,
      NULL,
      NULL,
      12.319921,
      91,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.091128,
      2,
      NULL,
      NULL,
      0,
      3.990078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.478418,
      NULL,
      NULL,
      0.094492,
      3.969530,
      NULL,
      NULL,
      NULL,
      1.732104,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.254081,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.882825,
      NULL,
      NULL,
      1.401150,
      1.815051,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.878569,
      3,
      NULL,
      NULL,
      NULL,
      1.159162,
      NULL,
      NULL,
      3,
      1.153903,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2.127546,
      NULL,
      NULL,
      NULL,
      0.372856,
      0,
      NULL,
      NULL,
      NULL,
      1.931334,
      3,
      0.550720,
      NULL,
      3.361464,
      1.275174,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.428814,
      NULL,
      NULL,
      0.235000,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315223,
      130,
      0.636407,
      1.774876,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.068404,
      0.303645,
      1,
      1,
      1,
      0,
      0,
      0.616407,
      0,
      0.117413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981068,
      0.133642,
      NULL,
      3,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.543137,
      NULL,
      0,
      1.771612,
      1,
      1.447341,
      0.086934,
      NULL,
      NULL,
      1,
      1.587227,
      0.365309,
      NULL,
      0.281035,
      1.094809,
      3.155526,
      3.656454,
      NULL,
      1,
      2.083379,
      1,
      0,
      NULL,
      0,
      0.059062,
      2.836963,
      NULL,
      0.002240,
      NULL,
      1,
      3.360815,
      2.305143,
      0,
      1.517863,
      0,
      2.684802,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435867,
      1,
      1,
      1.979900,
      0.696659,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      83,
      121,
      0,
      NULL,
      3.216923,
      '32224',
      '',
      '',
      0.898433,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


