set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9134183';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '3204231',
      NULL,
      1.418900,
      3,
      2,
      NULL,
      2,
      0,
      NULL,
      NULL,
      ' 8-20-1983',
      NULL,
      NULL,
      8.123530,
      3.742164,
      0.502860,
      ' 1-17-1987',
      25.018804,
      2.088709,
      85,
      NULL,
      0.536762,
      '10- 1-1995',
      ' 2- 6-1980',
      ' 5- 2-1981',
      3.811361,
      0,
      3.305819,
      0,
      0,
      1.334830,
      3.315013,
      1.924549,
      1,
      0.098780,
      NULL,
      0.058385,
      0.937154,
      NULL,
      5,
      5,
      1,
      5,
      0,
      2,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0.588905,
      1,
      0,
      4,
      4,
      0,
      3.534784,
      4.267230,
      0,
      3.114399,
      7.458812,
      1,
      1,
      1,
      0.109374,
      1,
      NULL,
      1,
      1.539066,
      9,
      0,
      4.337182,
      0.033606,
      3,
      1.073130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.988859,
      NULL,
      3.122035,
      0,
      1.535382,
      1.152899,
      0,
      1,
      1.426472,
      1,
      3.893537,
      1,
      0.831351,
      1.245495,
      2,
      NULL,
      1,
      1.332262,
      0.978606,
      0.118359,
      0,
      10.508876,
      0.183708,
      5,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.507147,
      NULL,
      2,
      1,
      1,
      2.082506,
      3.243594,
      NULL,
      0,
      1.946502,
      1,
      1,
      0.132050,
      NULL,
      NULL,
      NULL,
      1.752135,
      1,
      0,
      NULL,
      NULL,
      5.631580,
      2.700954,
      0,
      0.328422,
      2,
      4.091567,
      0,
      0.746899,
      2.140300,
      NULL,
      1,
      0.984349,
      1.891553,
      3.180998,
      5,
      NULL,
      8.104520,
      5.430901,
      5,
      0.911446,
      NULL,
      5.139102,
      NULL,
      2,
      0,
      5,
      NULL,
      ' 4- 1-1998',
      30.089237,
      NULL,
      294,
      1.596811,
      0,
      3.010526,
      0.754968,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.897423,
      NULL,
      0.844546,
      0.870539,
      0.664598,
      0.341769,
      NULL,
      1.477244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.722967,
      NULL,
      63,
      2.718697,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.844467,
      NULL,
      3.844506,
      1.851904,
      2.038676,
      0.027699,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.490251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.446578,
      1,
      3,
      NULL,
      0.050732,
      0,
      3.241182,
      36,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.419606,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0,
      3.158213,
      2,
      1.203327,
      2.931084,
      3.612566,
      2,
      NULL,
      NULL,
      2,
      1.093915,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1.315082,
      1.161673,
      NULL,
      1.529628,
      1.215514,
      2,
      1,
      4.130662,
      NULL,
      1.953435,
      10,
      6.550044,
      0.282083,
      NULL,
      NULL,
      0.735436,
      NULL,
      2.118379,
      2,
      64.514093,
      NULL,
      NULL,
      NULL,
      63.729384,
      NULL,
      NULL,
      0,
      0,
      3.647092,
      '32120',
      '30300',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      2.014234,
      13,
      3.838972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.826600,
      0.091164,
      NULL,
      1.481124,
      NULL,
      NULL,
      0,
      0.150203,
      0,
      3.228533,
      2,
      3.473879,
      2.261231,
      3.399615,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7.200477,
      3.100076,
      0,
      NULL,
      NULL,
      NULL,
      0.241146,
      3,
      1,
      NULL,
      1.751213,
      1.718670,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.382509,
      3,
      9,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.691981,
      1,
      2,
      1.851590,
      NULL,
      NULL,
      1.636577,
      NULL,
      NULL,
      3.569446,
      0.790901,
      NULL,
      0,
      1.210168,
      2,
      1.602566,
      NULL,
      1,
      NULL,
      1.534299,
      1.302794,
      0.011870,
      NULL,
      1.265223,
      1.008850,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.655776,
      NULL,
      2.233971,
      0.379664,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.097707,
      1,
      2.175172,
      0.091622,
      0,
      3.770630,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.070322,
      NULL,
      3.750443,
      1.332999,
      NULL,
      NULL,
      NULL,
      0.847459,
      1.322150,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.264776,
      NULL,
      1,
      0.049967,
      2.051611,
      2.920397,
      4,
      0,
      7,
      5,
      1,
      7,
      NULL,
      1.592133,
      NULL,
      NULL,
      1.021764,
      1,
      1.476809,
      2,
      1,
      1.496994,
      NULL,
      6,
      4,
      6,
      2.137398,
      2.502764,
      0.338091,
      1.091117,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.807996,
      NULL,
      0,
      4,
      0.189675,
      0.931578,
      4,
      4,
      1,
      1.878947,
      3.726752,
      1.583796,
      1.999287,
      0.086653,
      NULL,
      1.814468,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640297,
      NULL,
      NULL,
      1.815719,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.037534,
      NULL,
      NULL,
      1.958072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      NULL,
      3.647091,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.979281,
      NULL,
      NULL,
      NULL,
      0.295294,
      NULL,
      NULL,
      NULL,
      0.050010,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.050541,
      NULL,
      NULL,
      NULL,
      0.607691,
      NULL,
      NULL,
      NULL,
      1.525787,
      NULL,
      NULL,
      NULL,
      0.188876,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.832877,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.010296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.638771,
      2.069407,
      1.553812,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.620757,
      3,
      0,
      1.234959,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      1.287110,
      1.117662,
      1,
      0.971704,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.300251,
      1.055108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.171599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.397501,
      NULL,
      0.060729,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.445881,
      NULL,
      1.939695,
      0.595776,
      1.304576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.903503,
      2.282396,
      NULL,
      1.906256,
      NULL,
      NULL,
      NULL,
      269.899347,
      NULL,
      1,
      1.165571,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738368,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      11,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      5.570273,
      8.667740,
      2.137474,
      3,
      4.221429,
      1.105744,
      NULL,
      0,
      2.454496,
      NULL,
      1,
      0.428286,
      NULL,
      0.915459,
      1.376832,
      NULL,
      0,
      0.352096,
      NULL,
      0.432630,
      1.523170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.196279,
      NULL,
      NULL,
      1.214628,
      NULL,
      NULL,
      1.625502,
      NULL,
      0,
      1.331699,
      NULL,
      1,
      0.071070,
      NULL,
      0.390332,
      0,
      1.556509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.482738,
      NULL,
      16.660415,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.799567,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      11,
      3.962022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.820339,
      2,
      1.662798,
      NULL,
      NULL,
      10.312303,
      73.372335,
      NULL,
      NULL,
      2.666859,
      '42303',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


