set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7501963';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22',
      '30',
      33,
      19.825367,
      '3421112',
      NULL,
      NULL,
      1,
      2,
      NULL,
      5.009308,
      1.515848,
      NULL,
      NULL,
      NULL,
      NULL,
      22.157266,
      NULL,
      1.357519,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445624,
      '11-28-1998',
      ' 0-24-1991',
      ' 9- 8-1980',
      NULL,
      1.030541,
      0.298922,
      1.737770,
      0.018927,
      0.839440,
      3.519948,
      1,
      1.356990,
      2.888512,
      9.991593,
      18,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.193000,
      1.584072,
      3.368610,
      0,
      1,
      2,
      1,
      0.515968,
      0.763222,
      NULL,
      1,
      2.787979,
      1.601521,
      NULL,
      3,
      1,
      0,
      1.609824,
      1.770727,
      1.735269,
      0.805049,
      0.733168,
      1.462964,
      NULL,
      1,
      1,
      0,
      1.690688,
      0,
      0.783440,
      0.672426,
      1.493452,
      0.947656,
      NULL,
      NULL,
      3,
      2.643127,
      1,
      8.682608,
      0.497344,
      0.892836,
      2,
      1.809624,
      0.469046,
      NULL,
      0.082787,
      1.038509,
      3.300494,
      3.140133,
      0,
      2,
      0.690110,
      0,
      2,
      NULL,
      NULL,
      1.804172,
      NULL,
      1,
      9,
      NULL,
      1,
      4.755385,
      1,
      0,
      NULL,
      NULL,
      2.059995,
      3,
      0,
      1,
      0.659656,
      0.277733,
      1.291061,
      1.236958,
      1.075840,
      0.482074,
      0,
      1.317683,
      0.233238,
      0,
      1.561450,
      1,
      NULL,
      1,
      0,
      1.102546,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      9,
      2.907660,
      NULL,
      1.409143,
      0,
      0,
      5,
      1,
      5,
      NULL,
      6.209367,
      6,
      7,
      1,
      NULL,
      11.284907,
      NULL,
      1,
      NULL,
      1,
      NULL,
      ' 6- 3-1978',
      739.342776,
      ' 6-22-2000',
      130,
      1,
      0.072224,
      0.988081,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.046120,
      0,
      1,
      0.366667,
      0,
      1,
      0,
      0.834902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.085304,
      NULL,
      3.717989,
      NULL,
      0.206978,
      1.117653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      0.443039,
      NULL,
      0.638324,
      0.783009,
      2,
      NULL,
      NULL,
      4.055779,
      2.462094,
      0,
      8,
      3,
      1.703298,
      NULL,
      NULL,
      1,
      4,
      2.719748,
      0,
      1.428319,
      6.043233,
      7.500390,
      NULL,
      NULL,
      NULL,
      4.879778,
      1,
      0,
      1,
      3,
      0.103782,
      0.704309,
      1.563478,
      0.968420,
      1,
      NULL,
      0.272115,
      NULL,
      0,
      1.334179,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3.242913,
      1,
      3,
      0.222180,
      NULL,
      0,
      NULL,
      2,
      2,
      0.659141,
      2.655413,
      3,
      4.654951,
      1,
      1,
      NULL,
      1.257157,
      NULL,
      0,
      1.053944,
      0,
      0,
      NULL,
      1.836094,
      0,
      NULL,
      5.104957,
      1,
      NULL,
      7.766075,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.700525,
      2.098888,
      NULL,
      1.977235,
      NULL,
      NULL,
      NULL,
      3.942234,
      41.276376,
      NULL,
      0.352164,
      69,
      0,
      4.926958,
      4,
      '13023',
      '14440',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.099030,
      4,
      417,
      43,
      NULL,
      46,
      16,
      19,
      0.589666,
      NULL,
      1.631895,
      0.879258,
      1,
      NULL,
      NULL,
      3,
      0.347461,
      0.911261,
      2,
      1.890046,
      0.294126,
      0.928202,
      NULL,
      NULL,
      1.569247,
      NULL,
      NULL,
      0,
      0,
      1.105659,
      1,
      1.015745,
      1.791423,
      0,
      NULL,
      NULL,
      1.719315,
      1,
      0.497112,
      NULL,
      NULL,
      NULL,
      0.303674,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.723340,
      1,
      2.650645,
      1.740175,
      0,
      0.407974,
      3.196409,
      1.022263,
      0,
      NULL,
      3,
      1.693784,
      2.699945,
      0.810873,
      3.298895,
      1.896555,
      0.022935,
      0.022302,
      1,
      NULL,
      0.741757,
      3.306509,
      3,
      3,
      2,
      NULL,
      1.505287,
      0,
      3.387095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.645209,
      0,
      2,
      5,
      5.546305,
      0.734471,
      1.578105,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2.639940,
      NULL,
      NULL,
      NULL,
      NULL,
      1.917731,
      1.355064,
      1.652092,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.106812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.749092,
      NULL,
      NULL,
      0.748978,
      NULL,
      NULL,
      1.718417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.250930,
      NULL,
      NULL,
      5,
      5.568507,
      4,
      1.206429,
      NULL,
      NULL,
      2.667968,
      0,
      3,
      NULL,
      3.885155,
      0.954393,
      NULL,
      3,
      3.860919,
      8,
      3,
      0,
      2.052681,
      2,
      0,
      1,
      2.177280,
      NULL,
      NULL,
      NULL,
      NULL,
      2.832542,
      2.412843,
      3.186859,
      2,
      4.048793,
      7,
      0.624097,
      NULL,
      NULL,
      2.570269,
      NULL,
      3,
      3.215019,
      1.538625,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      0.220884,
      NULL,
      45,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.026901,
      0,
      NULL,
      1,
      1.497760,
      NULL,
      1,
      1,
      NULL,
      2.092215,
      1,
      NULL,
      1.363267,
      NULL,
      NULL,
      1.763992,
      2,
      NULL,
      NULL,
      2.366601,
      NULL,
      3,
      3.863421,
      0.852725,
      1,
      0.008563,
      NULL,
      NULL,
      NULL,
      NULL,
      9.180641,
      1,
      NULL,
      NULL,
      31,
      9.605239,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0.187397,
      NULL,
      NULL,
      NULL,
      1.442905,
      2.761681,
      NULL,
      NULL,
      NULL,
      1.665697,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.782487,
      NULL,
      NULL,
      0.863564,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2.609115,
      0.492172,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2.579923,
      NULL,
      NULL,
      13.798696,
      12,
      NULL,
      NULL,
      3,
      NULL,
      4.633072,
      8,
      2,
      NULL,
      94,
      105,
      0,
      23,
      11.227514,
      0.237993,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      16,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.893938,
      438,
      1.253307,
      NULL,
      1.816860,
      1,
      1.463272,
      1.112180,
      0,
      0.260399,
      NULL,
      NULL,
      0,
      1.222370,
      3,
      NULL,
      0,
      0.541189,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.466084,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      17,
      NULL,
      1,
      NULL,
      57,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257975,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      3,
      NULL,
      2,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0.503584,
      NULL,
      2.685357,
      NULL,
      1.139533,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.697324,
      1.352363,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.721301,
      NULL,
      1,
      NULL,
      0.907709,
      NULL,
      1.822280,
      1.428918,
      3.924315,
      NULL,
      NULL,
      NULL,
      1.555444,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.695254,
      NULL,
      0,
      NULL,
      0.164700,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.232701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.561227,
      0.954944,
      NULL,
      0,
      NULL,
      1.006594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.222559,
      1.196350,
      2.739579,
      1.624944,
      1.899076,
      2.287891,
      3.970149,
      NULL,
      1,
      1.715229,
      NULL,
      1,
      0.508270,
      NULL,
      1,
      0.939676,
      NULL,
      2,
      NULL,
      NULL,
      1.620792,
      0.581506,
      NULL,
      1,
      3.528739,
      NULL,
      NULL,
      NULL,
      NULL,
      2.449400,
      NULL,
      NULL,
      3,
      1.484205,
      NULL,
      1,
      0.887296,
      NULL,
      1.673870,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.829883,
      1,
      3.668563,
      2.065459,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.328418,
      NULL,
      2.938272,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.120629,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.040095,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3.487544,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.814684,
      NULL,
      1.509645,
      NULL,
      NULL,
      NULL,
      1.030337,
      NULL,
      4.059206,
      0,
      NULL,
      0,
      NULL,
      1.651164,
      NULL,
      0.458691,
      NULL,
      NULL,
      2.696730,
      5.472210,
      NULL,
      0,
      2,
      NULL,
      98,
      4.776838,
      0.978419,
      3.277524,
      '20401',
      '41113',
      '34102',
      1,
      '',
      '',
      '',
      0.059542,
      '',
      '',
      '');
commit;
end;
/


