set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9012810';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-4-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '3143314',
      0.546757,
      1.325049,
      1,
      NULL,
      '0202',
      NULL,
      0.222055,
      NULL,
      NULL,
      ' 3-23-1988',
      39,
      NULL,
      NULL,
      2,
      0.797033,
      ' 4- 8-1983',
      NULL,
      1.727297,
      114,
      138,
      3,
      ' 9-25-1987',
      ' 8-26-2003',
      ' 7-12-1994',
      3,
      1.252999,
      2,
      1,
      0,
      1,
      0.295425,
      1.048940,
      NULL,
      72.980125,
      7.759572,
      16.223927,
      6,
      184.943566,
      54,
      3,
      20,
      NULL,
      0.409754,
      2,
      NULL,
      1.450270,
      0,
      1.815343,
      1,
      NULL,
      1.234605,
      0,
      NULL,
      0.496897,
      NULL,
      NULL,
      4,
      0.504671,
      2.781681,
      0,
      0.171763,
      0,
      4,
      NULL,
      0.529435,
      1.259237,
      0,
      NULL,
      3.892574,
      1,
      0,
      NULL,
      0.425046,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.888279,
      3.969712,
      0.764180,
      2,
      0.228116,
      NULL,
      1.886304,
      NULL,
      1.327250,
      0.530061,
      1.147024,
      1,
      1,
      1,
      1,
      1.504864,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      0.395492,
      NULL,
      3,
      2.049704,
      0,
      NULL,
      NULL,
      1.543472,
      NULL,
      NULL,
      3,
      NULL,
      1.852153,
      0,
      5.214208,
      NULL,
      2,
      0,
      1,
      NULL,
      0,
      2,
      NULL,
      2.625222,
      0,
      0,
      1.953762,
      0,
      0.271456,
      NULL,
      0.742498,
      3,
      6.777963,
      0,
      0.437606,
      NULL,
      3.816254,
      4.254114,
      0,
      1.944390,
      0.129957,
      0.905574,
      0.901680,
      0,
      3.778408,
      8,
      NULL,
      0.496017,
      7,
      6.628404,
      1,
      3.203015,
      5,
      NULL,
      1.045103,
      1,
      3.295114,
      3.931837,
      ' 5- 0-1974',
      1193,
      NULL,
      1703.512409,
      NULL,
      0,
      2.560395,
      1,
      1.671812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620130,
      0,
      0.495900,
      0,
      1,
      3.282031,
      0.178659,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.792918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.446111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.873338,
      0,
      0.175075,
      1,
      0.451934,
      NULL,
      NULL,
      NULL,
      NULL,
      1.116157,
      0,
      0.714333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      1.298813,
      0,
      NULL,
      3.355257,
      19803.126473,
      1.219496,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.699998,
      3,
      1,
      0.827216,
      0,
      0,
      1.068021,
      NULL,
      2.984255,
      NULL,
      1,
      NULL,
      1,
      NULL,
      5,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0.639010,
      1.785387,
      1,
      0,
      0,
      0,
      NULL,
      1.979018,
      NULL,
      NULL,
      NULL,
      1,
      7,
      NULL,
      3.731642,
      3,
      6.249671,
      1.979208,
      1,
      0,
      59,
      2,
      3,
      NULL,
      6.033334,
      8,
      9.294825,
      NULL,
      0.950143,
      5.197100,
      '10013',
      '12331',
      NULL,
      1,
      '',
      '',
      '',
      2,
      '3203',
      '4322',
      '4402',
      2.044254,
      20,
      358.413962,
      0.210709,
      0.437732,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.311734,
      0.705108,
      NULL,
      NULL,
      0.001390,
      NULL,
      NULL,
      0.891098,
      NULL,
      0,
      1.175313,
      2.215300,
      0.374646,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.144005,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.384050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.998378,
      4,
      0.036376,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.736429,
      NULL,
      NULL,
      NULL,
      1.204802,
      3,
      0.099973,
      NULL,
      2.903331,
      NULL,
      3.485895,
      NULL,
      NULL,
      3.721462,
      1.650841,
      0.131704,
      1.564723,
      NULL,
      2.169276,
      1,
      2.935805,
      1,
      NULL,
      1.410816,
      NULL,
      0.384840,
      3.193500,
      0.474499,
      0,
      1.960511,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      7.604928,
      4.212366,
      0.283009,
      NULL,
      NULL,
      NULL,
      NULL,
      1.246428,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.878989,
      3.585246,
      3,
      0,
      3,
      0,
      1,
      NULL,
      NULL,
      9.183593,
      10,
      2,
      0,
      NULL,
      1,
      2,
      1.133107,
      1.805204,
      0,
      NULL,
      5.776811,
      1,
      NULL,
      NULL,
      0.135653,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.115608,
      NULL,
      NULL,
      0.612789,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      3,
      NULL,
      2.168579,
      NULL,
      3.753467,
      1,
      0.071220,
      7.996273,
      1,
      4,
      NULL,
      0,
      3,
      2,
      0,
      0,
      0,
      0.869935,
      2.581646,
      1,
      NULL,
      1.297391,
      3.135660,
      0,
      NULL,
      0.326792,
      1,
      NULL,
      NULL,
      1,
      2,
      3,
      NULL,
      3,
      2.089482,
      NULL,
      1.063632,
      4,
      1,
      3.338790,
      NULL,
      NULL,
      2.097076,
      1,
      1,
      1,
      0,
      0.533764,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.543578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.446805,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.051148,
      NULL,
      NULL,
      1.372856,
      NULL,
      NULL,
      0.011963,
      0,
      1.637025,
      1.094892,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.921140,
      NULL,
      NULL,
      NULL,
      1.162738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.851827,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.229781,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835715,
      NULL,
      347,
      1,
      NULL,
      NULL,
      1.071338,
      NULL,
      NULL,
      3,
      15,
      4.485326,
      3,
      11,
      2.881255,
      0,
      NULL,
      NULL,
      0.956060,
      NULL,
      0,
      461.010572,
      7,
      0.097360,
      1.301092,
      1,
      1,
      1,
      1,
      1.109313,
      1,
      1.135193,
      NULL,
      0,
      1,
      0.354341,
      1.211839,
      1.150980,
      NULL,
      1.319014,
      1.330790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.854279,
      0.509732,
      0,
      2.817457,
      1,
      NULL,
      NULL,
      2.259696,
      0.472261,
      3.115589,
      NULL,
      NULL,
      0,
      1.040969,
      NULL,
      1,
      0.821302,
      NULL,
      1,
      2,
      NULL,
      0.347639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536973,
      2.441913,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.804440,
      NULL,
      0.827138,
      0.143384,
      NULL,
      NULL,
      3.284556,
      NULL,
      0.961939,
      0,
      NULL,
      3.658266,
      1,
      1.012041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.969866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.861561,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.544907,
      NULL,
      6.068600,
      1.825382,
      0.237389,
      1,
      25.859497,
      1.601080,
      1,
      0,
      4,
      '22203',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      6.598426,
      '2134',
      '4433',
      '4121');
commit;
end;
/


