set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7836064';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '2044100',
      3.492464,
      1.932812,
      3,
      0,
      '0301',
      1.872626,
      1.190194,
      NULL,
      NULL,
      NULL,
      36,
      NULL,
      0,
      2,
      0,
      ' 4-18-1974',
      112,
      0.977359,
      133,
      NULL,
      1.289803,
      ' 7-10-1984',
      ' 4-23-1975',
      '11-14-1982',
      2,
      1.845622,
      0,
      NULL,
      0.547022,
      1,
      NULL,
      0,
      0,
      1077.843207,
      19.313546,
      NULL,
      4,
      17.032189,
      NULL,
      7.302648,
      7.022596,
      0.258791,
      3,
      3,
      0.860691,
      1.376429,
      0.830624,
      NULL,
      0.987670,
      0.026496,
      0.428219,
      0,
      1,
      0,
      77.258820,
      12.540474,
      NULL,
      3,
      3.214367,
      NULL,
      NULL,
      0.264649,
      NULL,
      NULL,
      1,
      5.654380,
      0,
      7,
      NULL,
      7,
      1,
      NULL,
      1.657026,
      NULL,
      1,
      0.368480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      9,
      1.457635,
      0,
      NULL,
      0,
      2.056442,
      0,
      NULL,
      0.554453,
      NULL,
      0.253748,
      0.865000,
      1.958229,
      0,
      0.076509,
      0,
      0.385307,
      1.888762,
      0.423957,
      1,
      NULL,
      1.102434,
      1.030238,
      0.490899,
      1,
      NULL,
      NULL,
      1.245092,
      NULL,
      NULL,
      0,
      NULL,
      0.461114,
      1,
      0.226547,
      NULL,
      6.126663,
      NULL,
      NULL,
      0,
      1,
      1,
      1.709116,
      7.001218,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      5.217685,
      5,
      1.432001,
      NULL,
      0.341239,
      3.870186,
      7,
      NULL,
      NULL,
      5,
      0.178583,
      0.482782,
      NULL,
      0,
      NULL,
      NULL,
      2.842847,
      3.915182,
      NULL,
      7,
      6.642215,
      2.830565,
      0,
      1.538470,
      1,
      1.362272,
      3.168551,
      NULL,
      1674.820389,
      ' 1- 9-1985',
      1497,
      3.563937,
      1,
      0.433104,
      1.229264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.944224,
      1.448312,
      1.835991,
      NULL,
      3.547190,
      0.778084,
      0.519183,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.278749,
      NULL,
      5,
      0.369663,
      1.062024,
      0.552542,
      0.828420,
      NULL,
      NULL,
      NULL,
      0.477971,
      0.880471,
      0.092435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.535002,
      NULL,
      0.369320,
      NULL,
      1,
      3,
      NULL,
      1,
      1.738670,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0.036897,
      NULL,
      1.515795,
      5.504981,
      0,
      0.279572,
      3.827148,
      NULL,
      0.731667,
      NULL,
      NULL,
      1.668385,
      1.239295,
      NULL,
      NULL,
      1,
      0.267813,
      0.617311,
      1,
      1.544902,
      NULL,
      0,
      0,
      0.038833,
      NULL,
      0.786961,
      7.108279,
      0.141004,
      1.739454,
      9,
      3,
      0.872160,
      3.504232,
      5.265446,
      6.138048,
      5,
      1.691225,
      7.003382,
      2.323464,
      NULL,
      2.328905,
      7.684177,
      NULL,
      3,
      NULL,
      NULL,
      38,
      45.926143,
      3.148514,
      0,
      0,
      NULL,
      '34214',
      '',
      0,
      '',
      '',
      '',
      4.795428,
      '42302',
      '00002',
      '',
      3.918738,
      NULL,
      1105,
      2,
      NULL,
      37.534355,
      5,
      223.287734,
      1,
      1,
      NULL,
      NULL,
      0.507050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.882052,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.139454,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.007640,
      0.784258,
      3.731026,
      NULL,
      1,
      2.764407,
      3.403371,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.981820,
      NULL,
      NULL,
      NULL,
      2.155333,
      0,
      3.234675,
      2.194528,
      1.800986,
      1.432982,
      3,
      1,
      NULL,
      3,
      0.961588,
      1.565971,
      1.127414,
      0.024281,
      0,
      1,
      0.150983,
      3.894439,
      0.882289,
      3.687380,
      0.026674,
      1,
      0,
      0,
      NULL,
      1.590054,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.277020,
      NULL,
      6,
      NULL,
      0.811168,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.203268,
      NULL,
      NULL,
      1,
      1.460274,
      2.891467,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      5.772179,
      3.574413,
      6.791033,
      0.862471,
      1.732036,
      0,
      0.142253,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.629239,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.559411,
      1.884562,
      3,
      1.623083,
      2,
      2,
      3,
      1.198248,
      1,
      0.124160,
      6,
      0,
      NULL,
      NULL,
      1.156203,
      NULL,
      NULL,
      2.257628,
      0,
      3,
      0,
      0.884849,
      1.727675,
      4.983573,
      NULL,
      NULL,
      0.176971,
      0.612735,
      NULL,
      0.194392,
      0.239755,
      1.711067,
      1,
      0.989003,
      0.103935,
      NULL,
      3,
      0,
      6,
      3.274470,
      7.336243,
      1,
      NULL,
      NULL,
      0.862941,
      1.647346,
      NULL,
      1.226475,
      0.677163,
      0,
      1.224002,
      1.733573,
      3.296537,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.648824,
      NULL,
      NULL,
      0.403667,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.935267,
      NULL,
      NULL,
      1.223375,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.142615,
      1,
      1.007187,
      0,
      3,
      1.173917,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.725949,
      NULL,
      NULL,
      NULL,
      1.369795,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.219903,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.266917,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.237634,
      NULL,
      NULL,
      NULL,
      0.231153,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      217,
      1,
      11,
      1,
      1.498869,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      958,
      1,
      75.111311,
      0,
      0.383158,
      1,
      NULL,
      0.832374,
      0,
      1.132019,
      1.989595,
      NULL,
      1,
      0,
      0.060818,
      1.837562,
      0,
      1,
      0,
      1.487891,
      0.273424,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.427598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873025,
      3.392970,
      4.399003,
      10.023239,
      1,
      4,
      0,
      4.962125,
      9,
      0,
      NULL,
      0,
      0.222843,
      1.718715,
      NULL,
      NULL,
      0.816780,
      NULL,
      0,
      1,
      NULL,
      0.858173,
      1,
      NULL,
      0,
      1.912826,
      NULL,
      NULL,
      1.929519,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1.307291,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.261780,
      NULL,
      0.741148,
      NULL,
      0.597005,
      NULL,
      7.273573,
      6.781864,
      5,
      NULL,
      2,
      2.967924,
      12.295879,
      41.922283,
      NULL,
      0.108540,
      NULL,
      NULL,
      '24321',
      '',
      1.737618,
      NULL,
      '',
      '',
      1,
      '30121',
      '33214',
      '');
commit;
end;
/


