set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8312986';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '4121021',
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      ' 1-26-1978',
      33.058092,
      NULL,
      1.042445,
      NULL,
      0.471170,
      ' 8-23-1985',
      91.360613,
      NULL,
      58.046023,
      110,
      0,
      NULL,
      ' 0-20-1998',
      ' 3-19-1984',
      2,
      3.835611,
      NULL,
      1,
      1,
      2.232150,
      NULL,
      NULL,
      0,
      85.464954,
      15.348117,
      NULL,
      3.950210,
      13,
      19,
      6,
      2.491189,
      0.058030,
      0,
      5,
      NULL,
      1,
      NULL,
      1.827630,
      0,
      1,
      0.419598,
      1,
      0.122915,
      1.218698,
      122.546506,
      9.041405,
      5.331540,
      10.338007,
      2.565998,
      4,
      NULL,
      3.083755,
      0,
      1.158352,
      1.449211,
      0,
      0.251937,
      NULL,
      0,
      3,
      0.763508,
      0.371243,
      0.447159,
      5.217350,
      1.130952,
      1,
      0.466754,
      NULL,
      NULL,
      3,
      1,
      1,
      3.524522,
      3.594983,
      8.786823,
      1,
      NULL,
      0,
      NULL,
      1.113631,
      1,
      1,
      0.864733,
      NULL,
      NULL,
      0.673915,
      NULL,
      0,
      1,
      0,
      1,
      3.641272,
      1,
      1,
      0.141519,
      1.022682,
      0,
      3,
      NULL,
      NULL,
      NULL,
      3.542237,
      NULL,
      NULL,
      2,
      NULL,
      2,
      5.652648,
      NULL,
      4,
      5.156700,
      0,
      1,
      1,
      NULL,
      5.044239,
      0,
      2,
      NULL,
      0,
      NULL,
      0.949587,
      0,
      NULL,
      0.110206,
      4.356364,
      9.172470,
      1.656982,
      0.261472,
      8,
      9.671984,
      2.439120,
      4,
      5.323201,
      3,
      6.764578,
      NULL,
      8,
      0.738389,
      7,
      4,
      NULL,
      3,
      5,
      5,
      6,
      1.569650,
      6,
      1.131123,
      7.003773,
      6.396624,
      3.773292,
      ' 6-15-1990',
      107,
      ' 5-29-1984',
      93.333901,
      1.959286,
      1.385255,
      1,
      1.761042,
      1.899192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5.242229,
      1.231167,
      1.202401,
      0.067244,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.740832,
      NULL,
      5.249863,
      1,
      2.904476,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.098268,
      0,
      1,
      0,
      3,
      NULL,
      2.860237,
      0,
      NULL,
      3.284957,
      3.974698,
      4,
      3,
      1.820804,
      NULL,
      NULL,
      2,
      11.342206,
      1.392604,
      3.135307,
      NULL,
      5,
      1.338099,
      NULL,
      1064.590251,
      ' 1- 0-1993',
      13,
      2,
      1,
      0.126752,
      1,
      3,
      0,
      0.873496,
      0,
      NULL,
      1.385975,
      2,
      11281.868485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.799989,
      1,
      3.610339,
      2.282181,
      0.702564,
      1.415216,
      3.662679,
      1.039601,
      2.977298,
      NULL,
      0.407675,
      0,
      NULL,
      5,
      5,
      7.312804,
      143.984970,
      NULL,
      166,
      196,
      72,
      1,
      0.665164,
      1,
      NULL,
      1,
      1,
      3,
      1,
      3.414697,
      0.317019,
      5.255450,
      4,
      NULL,
      NULL,
      10.346026,
      0.655944,
      2.811353,
      3,
      4.634388,
      NULL,
      1.619010,
      0.719425,
      50,
      NULL,
      2.296010,
      NULL,
      46,
      28.733900,
      23,
      1,
      1.932353,
      1,
      '23130',
      NULL,
      NULL,
      0.937623,
      '40344',
      '40131',
      '',
      1.686865,
      NULL,
      '',
      '',
      1.618112,
      43.766985,
      703.014045,
      59,
      0.495404,
      60,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.865255,
      0.025432,
      NULL,
      NULL,
      1.097444,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.808749,
      0.217589,
      NULL,
      1.944525,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1.296473,
      1,
      3,
      0,
      NULL,
      NULL,
      9.006788,
      1.751651,
      NULL,
      0.895551,
      NULL,
      0,
      NULL,
      3.762416,
      3,
      1,
      NULL,
      1.725554,
      1,
      0,
      2.990585,
      1,
      NULL,
      NULL,
      2.032473,
      1,
      NULL,
      2.861997,
      1,
      1,
      3,
      3.667256,
      2,
      0,
      NULL,
      0.436594,
      NULL,
      NULL,
      0,
      1.001073,
      3.847622,
      NULL,
      0.327981,
      0.285286,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.160859,
      0.836129,
      NULL,
      0.926490,
      5,
      0.908204,
      3.405882,
      NULL,
      NULL,
      3,
      NULL,
      1.460749,
      0,
      NULL,
      0.950182,
      NULL,
      NULL,
      0,
      0,
      1.273158,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.558875,
      NULL,
      2.135470,
      0,
      0,
      0.096126,
      1.897788,
      0.204930,
      5.055118,
      NULL,
      0.470312,
      0,
      NULL,
      NULL,
      1.351997,
      NULL,
      NULL,
      1.898988,
      NULL,
      NULL,
      1.750295,
      NULL,
      NULL,
      1.130859,
      NULL,
      NULL,
      0.541700,
      NULL,
      NULL,
      1.425943,
      1.912682,
      1,
      2,
      1.663886,
      1.453498,
      NULL,
      1.792702,
      NULL,
      6,
      NULL,
      2,
      0.053663,
      NULL,
      NULL,
      1,
      0.021298,
      1.857710,
      1,
      0,
      0,
      2,
      1.473822,
      1,
      10.811311,
      NULL,
      NULL,
      0,
      1.143794,
      NULL,
      2.205414,
      1.567960,
      NULL,
      3,
      3,
      2.480248,
      2.182599,
      2,
      0,
      3,
      NULL,
      5,
      7.664140,
      1,
      2.804888,
      1.082954,
      2,
      8.947013,
      1,
      2,
      1,
      1.928109,
      0.433936,
      3,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.808170,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.343805,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.922917,
      NULL,
      0.034259,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3.936572,
      NULL,
      NULL,
      0.928987,
      0,
      NULL,
      5.269608,
      5.689184,
      NULL,
      NULL,
      NULL,
      0,
      3.835620,
      NULL,
      1,
      1.600703,
      3,
      11.873447,
      NULL,
      0.647750,
      NULL,
      6.967291,
      NULL,
      NULL,
      NULL,
      0.019481,
      NULL,
      NULL,
      NULL,
      1.324988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.544595,
      1,
      0,
      NULL,
      1.233143,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.626289,
      0,
      1.116275,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.261717,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.163509,
      NULL,
      2.557690,
      NULL,
      0.898794,
      NULL,
      1.713007,
      0.158532,
      3.296712,
      NULL,
      0.571641,
      2,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.222822,
      NULL,
      1,
      1.961404,
      NULL,
      NULL,
      NULL,
      0,
      12,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.016539,
      3.807447,
      2,
      NULL,
      1,
      381,
      582.399362,
      NULL,
      52.402684,
      5,
      1.155677,
      NULL,
      NULL,
      1.332892,
      NULL,
      2.465452,
      2,
      0.165395,
      1,
      2.776653,
      37,
      0.971383,
      1.831198,
      55,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.368113,
      0.297434,
      0.277946,
      0,
      0,
      1.359370,
      1.626249,
      1.860387,
      0,
      1.164124,
      1.955194,
      1.034775,
      1.483363,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.628383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.407317,
      NULL,
      NULL,
      2.826381,
      0.482166,
      NULL,
      8,
      NULL,
      2.857009,
      3.060207,
      0,
      1.769126,
      0.621986,
      NULL,
      0.780831,
      3.451325,
      0.785027,
      0,
      NULL,
      0.701169,
      NULL,
      NULL,
      1.683706,
      0,
      3,
      0.585366,
      NULL,
      0,
      NULL,
      0,
      2.903380,
      1,
      1.308572,
      0,
      1,
      1.890973,
      0.737687,
      1,
      0,
      1,
      0,
      NULL,
      0,
      2,
      3.330036,
      NULL,
      0.087890,
      0.866805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      0.106820,
      1.018187,
      0.181878,
      1,
      1.865263,
      1,
      1,
      0.174146,
      NULL,
      3.948220,
      0.488985,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.432385,
      0.983347,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.690512,
      1,
      NULL,
      3.896894,
      8.532228,
      NULL,
      NULL,
      1.838323,
      2,
      2.737020,
      31,
      1,
      1.448174,
      3,
      '02104',
      NULL,
      '',
      5.360935,
      '02344',
      NULL,
      '',
      3,
      '4030',
      NULL,
      '');
commit;
end;
/


