set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817415';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '2121040',
      2.708358,
      NULL,
      2,
      NULL,
      '0402',
      2,
      1.507636,
      NULL,
      NULL,
      NULL,
      4.404974,
      NULL,
      0.140801,
      NULL,
      0.841640,
      ' 2- 3-1990',
      56,
      1,
      210.775532,
      57.581825,
      0.655691,
      NULL,
      ' 6-23-1995',
      ' 7-19-1979',
      NULL,
      0,
      2,
      NULL,
      1.854358,
      2,
      NULL,
      0.126838,
      NULL,
      33,
      6,
      NULL,
      14,
      59.072131,
      47.464295,
      7,
      25,
      7.538245,
      1,
      8,
      0.289280,
      0,
      1.986937,
      0,
      1,
      0.983107,
      1.892107,
      NULL,
      1,
      1.126286,
      2.933270,
      NULL,
      8,
      3.661530,
      1,
      0,
      1.207454,
      NULL,
      0.928146,
      1.025176,
      1,
      NULL,
      1.559296,
      0,
      0,
      0.677273,
      0.124403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.985073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015934,
      NULL,
      NULL,
      0.032005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      7.569940,
      8,
      5.331228,
      3,
      5,
      1.927930,
      0,
      1.986179,
      0,
      NULL,
      0,
      1.452262,
      1,
      0.923225,
      1.799446,
      0,
      1.347090,
      NULL,
      NULL,
      1.385682,
      5.691793,
      1.506634,
      NULL,
      0.223067,
      1.082928,
      1,
      0,
      NULL,
      2.595820,
      1,
      0.246571,
      0,
      NULL,
      NULL,
      3.466987,
      0.904816,
      7,
      2.887712,
      1,
      NULL,
      2,
      1.523530,
      NULL,
      NULL,
      3,
      1.211681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.305958,
      0.355547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798829,
      4,
      1,
      NULL,
      NULL,
      4.247057,
      0,
      0.743640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.175912,
      NULL,
      219,
      3.527077,
      0.602313,
      1.848150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.272809,
      1,
      3.187034,
      0,
      1,
      1,
      NULL,
      1.494305,
      6,
      1.244824,
      0.102588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.279758,
      1,
      0,
      3,
      0,
      1.180666,
      NULL,
      3,
      98.132955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.207420,
      6,
      NULL,
      3.738068,
      1.597360,
      3,
      NULL,
      '14244',
      '',
      1.662556,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      7.160097,
      225.963426,
      3.404342,
      NULL,
      17.845009,
      NULL,
      22,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.257588,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.832686,
      NULL,
      NULL,
      0.935003,
      NULL,
      NULL,
      1.814682,
      NULL,
      NULL,
      0.800378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.226728,
      NULL,
      NULL,
      1.185667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.880812,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.101541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856832,
      NULL,
      NULL,
      0,
      2.822704,
      0.918802,
      3,
      3.336533,
      1,
      1,
      0.828655,
      3.503491,
      11.376606,
      5,
      10,
      2.414602,
      NULL,
      1.575178,
      1.349425,
      NULL,
      3,
      6,
      4.319853,
      4.949247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.083628,
      NULL,
      NULL,
      0.101068,
      NULL,
      NULL,
      2.702119,
      0.306278,
      3.110733,
      4,
      5,
      1.819163,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.541707,
      1.499615,
      1.002401,
      2.367516,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.354499,
      1.469307,
      NULL,
      1,
      NULL,
      1,
      0.722222,
      NULL,
      NULL,
      3,
      0.505509,
      NULL,
      4.074268,
      8,
      5.018008,
      6,
      2.338693,
      0.705924,
      NULL,
      NULL,
      NULL,
      0.020845,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.304344,
      1.827643,
      1.351834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.173120,
      4.989973,
      NULL,
      0.952494,
      1.026536,
      309.310313,
      76,
      0,
      27.095255,
      5.266805,
      0.233152,
      NULL,
      NULL,
      1,
      61,
      7.913337,
      0.684242,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      4371,
      NULL,
      1.671065,
      2.496188,
      1.148265,
      0.514755,
      0.762462,
      0.707689,
      1,
      1,
      1,
      1,
      1.592797,
      NULL,
      NULL,
      1.104477,
      1.983785,
      0,
      1,
      1.362990,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.929616,
      NULL,
      0,
      NULL,
      41.835321,
      NULL,
      2,
      26,
      14.755855,
      NULL,
      NULL,
      1.298215,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.364854,
      NULL,
      NULL,
      NULL,
      0.643347,
      NULL,
      0,
      NULL,
      1.664254,
      NULL,
      1.464918,
      NULL,
      0,
      NULL,
      0.968711,
      NULL,
      1.478371,
      NULL,
      1.723908,
      NULL,
      1,
      NULL,
      NULL,
      0.768193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      8,
      2,
      2,
      2.780262,
      3,
      14.007366,
      NULL,
      0,
      NULL,
      1.154425,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.241653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.252926,
      NULL,
      NULL,
      NULL,
      1.570315,
      3,
      0.480336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.636033,
      0.186398,
      8,
      2,
      1.806840,
      3,
      5,
      52.133008,
      NULL,
      0,
      1.847904,
      '00102',
      '04131',
      NULL,
      NULL,
      '',
      '',
      NULL,
      0.744837,
      '',
      NULL,
      '');
commit;
end;
/


