set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131717';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '0044110',
      2.042255,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 7-2001',
      23,
      NULL,
      2.250647,
      NULL,
      1.651215,
      ' 6- 5-1994',
      69.943015,
      NULL,
      310,
      NULL,
      3,
      ' 3-11-1991',
      NULL,
      ' 6-10-1985',
      2,
      3,
      3,
      3,
      NULL,
      2.903956,
      1.380826,
      NULL,
      0.725507,
      15,
      6.876716,
      12,
      NULL,
      17,
      9.816150,
      4,
      NULL,
      1.618202,
      NULL,
      1,
      1.017006,
      0.286317,
      0.601110,
      NULL,
      0,
      1,
      0,
      1.165803,
      0,
      0.908320,
      0.572776,
      NULL,
      4,
      7.708196,
      3,
      3.283946,
      NULL,
      NULL,
      1.231830,
      NULL,
      4,
      1,
      0.398351,
      NULL,
      0.344915,
      0,
      1.787709,
      0.097944,
      0,
      1,
      5.758872,
      3.495127,
      0,
      NULL,
      NULL,
      1.868709,
      NULL,
      NULL,
      1.387597,
      0.042268,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1.457127,
      3.429904,
      NULL,
      NULL,
      1.929368,
      0.475882,
      1,
      1,
      3,
      3,
      0.811248,
      0,
      0.322442,
      NULL,
      1.134596,
      0,
      2.983601,
      1,
      NULL,
      NULL,
      1.904288,
      NULL,
      NULL,
      0.758811,
      0.731657,
      NULL,
      0.428408,
      4,
      1.302085,
      NULL,
      4,
      3.204795,
      1,
      5.639368,
      0,
      0,
      NULL,
      0,
      1.174447,
      NULL,
      NULL,
      1,
      NULL,
      0,
      7.026774,
      6.104110,
      4,
      5.988734,
      0.359727,
      0.239649,
      3,
      1,
      1,
      2.826093,
      0.056927,
      9.411972,
      1.528188,
      2,
      NULL,
      3.964148,
      0,
      0,
      1.076183,
      3.523879,
      6,
      3,
      5,
      NULL,
      9,
      1.408611,
      0,
      ' 4-23-1997',
      668,
      ' 5-19-1977',
      860,
      0,
      0.562660,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.762284,
      3.987161,
      NULL,
      1,
      2,
      1.742017,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.972262,
      1.539406,
      1,
      0.691536,
      NULL,
      NULL,
      0,
      NULL,
      0.953326,
      1,
      1,
      3.505912,
      0,
      NULL,
      NULL,
      NULL,
      0.713076,
      2.605144,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.821804,
      NULL,
      NULL,
      0,
      0,
      0.402385,
      0.459031,
      8,
      0.041450,
      0.014361,
      NULL,
      NULL,
      NULL,
      3.285219,
      NULL,
      2.712878,
      3,
      1.877660,
      0.187590,
      0,
      3.962584,
      2,
      2,
      NULL,
      NULL,
      3.745150,
      3.841005,
      1,
      3,
      1.324928,
      1,
      1.484323,
      3,
      NULL,
      0,
      1,
      0,
      1.344736,
      0,
      1.270457,
      1,
      1.121436,
      NULL,
      5,
      0.914888,
      2.963326,
      4,
      2.386389,
      5.149270,
      1.479269,
      6,
      1.064751,
      1.343901,
      5.055030,
      NULL,
      2,
      2.892566,
      38,
      0,
      0.182248,
      NULL,
      16.381360,
      34,
      65,
      3.280948,
      NULL,
      3.578706,
      '40243',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.265118,
      '',
      '',
      '',
      2,
      25.629111,
      48.997135,
      NULL,
      1,
      36,
      4,
      NULL,
      1,
      NULL,
      1.598848,
      NULL,
      0.154632,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.333211,
      3.971847,
      2.510773,
      2.329150,
      0.180638,
      3.491029,
      NULL,
      NULL,
      0.581026,
      1.544707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.914773,
      NULL,
      3,
      0.587059,
      NULL,
      NULL,
      NULL,
      NULL,
      0.255347,
      NULL,
      NULL,
      NULL,
      1.332987,
      NULL,
      1.849782,
      11,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.909694,
      2,
      NULL,
      2,
      1.459448,
      0,
      1.620213,
      1.047470,
      NULL,
      0.271527,
      3.905576,
      0.277248,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.313975,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.057013,
      NULL,
      NULL,
      NULL,
      0.775595,
      NULL,
      NULL,
      1.601003,
      3.417000,
      3,
      1,
      NULL,
      NULL,
      1.007605,
      NULL,
      NULL,
      2.647755,
      7,
      0,
      3.706557,
      NULL,
      1,
      1,
      0.169139,
      NULL,
      0.569382,
      NULL,
      3.228387,
      0.813458,
      NULL,
      NULL,
      1.036370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.809114,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.545748,
      NULL,
      0,
      2.612767,
      NULL,
      3,
      NULL,
      1.953114,
      NULL,
      3,
      0,
      1.239692,
      7,
      3,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0.827420,
      1,
      0.738423,
      3.596147,
      1,
      NULL,
      9.220856,
      0,
      1.082604,
      0,
      3.084591,
      2.396213,
      1,
      0,
      0.695053,
      2,
      0.875017,
      1.592303,
      3,
      2,
      NULL,
      1,
      4.268355,
      NULL,
      3.156740,
      0,
      2,
      4.571518,
      5,
      NULL,
      0,
      1,
      1.488846,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.868919,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.848534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.059059,
      NULL,
      NULL,
      0.708519,
      0.504627,
      NULL,
      0.527955,
      1,
      3,
      1.395472,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.164597,
      NULL,
      NULL,
      NULL,
      0.220850,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.145418,
      NULL,
      NULL,
      NULL,
      0.327364,
      NULL,
      NULL,
      NULL,
      0.456406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.444647,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      102.808800,
      24,
      0,
      NULL,
      NULL,
      0.860869,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.892602,
      NULL,
      NULL,
      0,
      NULL,
      1.396570,
      5273,
      25,
      1,
      0.600910,
      NULL,
      0.462690,
      1.880875,
      0,
      0,
      1.823446,
      0.708226,
      0.472446,
      1.420959,
      1,
      1,
      NULL,
      1.984232,
      1.160581,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.215904,
      1.002529,
      0.467982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.080780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106800,
      NULL,
      0.233391,
      NULL,
      1.137737,
      NULL,
      0.214946,
      0,
      0.508333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.400746,
      0.532534,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.157302,
      NULL,
      NULL,
      0,
      1.729685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.236006,
      1,
      0,
      0,
      0.996553,
      1.820194,
      NULL,
      1,
      1.264115,
      NULL,
      NULL,
      1.589421,
      NULL,
      NULL,
      1.961397,
      0.811278,
      NULL,
      1,
      1,
      NULL,
      1.526253,
      0,
      NULL,
      0.519097,
      0,
      NULL,
      0.839691,
      0.703796,
      NULL,
      0,
      NULL,
      NULL,
      1.746541,
      NULL,
      NULL,
      0.191329,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.738246,
      0,
      NULL,
      NULL,
      1.540027,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.731870,
      NULL,
      1,
      NULL,
      1,
      NULL,
      8,
      NULL,
      3,
      0,
      NULL,
      NULL,
      28,
      23.335041,
      3.773124,
      1.276605,
      0,
      '21212',
      '',
      '',
      1.804760,
      '',
      '',
      '',
      0.828976,
      '',
      NULL,
      NULL);
commit;
end;
/


