set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102383';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '4142403',
      2,
      1.384207,
      4,
      NULL,
      '2322',
      0.598319,
      1,
      NULL,
      NULL,
      '10-27-1992',
      29,
      NULL,
      0.284188,
      0.994553,
      1.160790,
      ' 0-10-1992',
      NULL,
      3,
      NULL,
      31,
      3.343259,
      ' 6- 4-1998',
      ' 0-24-1995',
      NULL,
      NULL,
      1.140148,
      NULL,
      1.123101,
      0.492057,
      0.488664,
      0,
      NULL,
      NULL,
      9,
      2,
      0,
      4,
      14.360578,
      15,
      NULL,
      NULL,
      3,
      3,
      4,
      NULL,
      1.522948,
      0.032092,
      0.246999,
      NULL,
      1.660577,
      1.548517,
      2.948688,
      0.547040,
      0.332309,
      1,
      1.840849,
      NULL,
      5.960393,
      2.971000,
      NULL,
      1,
      1,
      0.722125,
      NULL,
      7.473326,
      8,
      3,
      0,
      NULL,
      NULL,
      3.808582,
      7,
      1.715344,
      0,
      NULL,
      0.919545,
      1.654464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.771227,
      1.422029,
      1.431652,
      0.420860,
      1.996557,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1.188940,
      1,
      0,
      1.935563,
      0,
      0.304203,
      1,
      1.936410,
      0.837559,
      5.551321,
      1.100688,
      1.021670,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.161409,
      5.935954,
      3,
      0,
      NULL,
      NULL,
      0,
      1.653249,
      0,
      1,
      0,
      0,
      1,
      0.918962,
      0.243936,
      0.856342,
      1.695847,
      1,
      0,
      NULL,
      1,
      5.732013,
      3.318553,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      5.859454,
      NULL,
      0,
      3.408900,
      1,
      1,
      3.341368,
      4,
      0.127030,
      NULL,
      5,
      3.725063,
      NULL,
      2,
      NULL,
      1,
      1,
      1.605193,
      ' 2-19-2001',
      NULL,
      ' 9-24-1999',
      112,
      1,
      0.302592,
      1.273081,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967156,
      NULL,
      0.062247,
      1,
      1.072664,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      3,
      0.597357,
      6,
      0.759074,
      1,
      0,
      3,
      5,
      5.408702,
      1,
      3,
      0.893267,
      0.682586,
      1.430521,
      NULL,
      1,
      7,
      5,
      0,
      0.281670,
      0.218626,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.592527,
      NULL,
      NULL,
      0,
      1.686389,
      0.705702,
      NULL,
      2,
      NULL,
      1.295184,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.075609,
      0,
      1.255882,
      2.764200,
      1.883815,
      0.989389,
      0.331767,
      0,
      3,
      3.761008,
      0.516227,
      0,
      1.308653,
      0.501394,
      1.500430,
      1,
      NULL,
      0,
      0.678238,
      1.823697,
      1,
      0,
      1,
      0.567255,
      0,
      1.358590,
      0.236131,
      0.955289,
      3.966555,
      0.104534,
      7.283022,
      NULL,
      0,
      2.695875,
      1,
      3.469833,
      0.789202,
      0,
      0,
      0,
      NULL,
      NULL,
      31.848095,
      0.432114,
      2.880850,
      NULL,
      44.475645,
      NULL,
      47,
      NULL,
      0.340794,
      3.599791,
      '31403',
      '40404',
      '',
      0.537775,
      '',
      '',
      '',
      1.928546,
      '',
      '',
      NULL,
      1.851288,
      27.822075,
      9.598989,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.291752,
      2,
      1,
      1.018265,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.068057,
      NULL,
      NULL,
      1.595787,
      NULL,
      NULL,
      2,
      2.278228,
      1,
      0,
      2.670368,
      NULL,
      3.048494,
      2.664575,
      4.864327,
      1,
      NULL,
      NULL,
      0.453520,
      1,
      11.668515,
      NULL,
      1.005673,
      NULL,
      2,
      1.261448,
      18,
      9.515975,
      7.139333,
      7.176225,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.011596,
      18.595245,
      0.382849,
      NULL,
      NULL,
      1.197140,
      NULL,
      NULL,
      1,
      0.281311,
      1,
      0,
      1,
      1,
      1.756382,
      NULL,
      0.010409,
      1.501047,
      0,
      1.190078,
      NULL,
      1,
      1.249996,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.649289,
      NULL,
      NULL,
      4,
      2,
      NULL,
      0,
      1.627982,
      NULL,
      NULL,
      NULL,
      1.263297,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.217339,
      3,
      1,
      1.474398,
      NULL,
      NULL,
      0.459845,
      NULL,
      NULL,
      NULL,
      1.896099,
      NULL,
      0.514379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.652323,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.107244,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.384068,
      0,
      0.996917,
      NULL,
      NULL,
      4.868135,
      2.399360,
      4,
      1.778254,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.398187,
      NULL,
      NULL,
      1.733983,
      3,
      NULL,
      3.474904,
      2.644230,
      0,
      9.050835,
      1.469105,
      5.240419,
      1,
      2,
      NULL,
      3,
      NULL,
      0,
      0.602263,
      NULL,
      3.584307,
      3.291820,
      3.680223,
      3.474916,
      6,
      5,
      NULL,
      1,
      NULL,
      NULL,
      3.152277,
      3,
      6,
      1.750815,
      0.758391,
      0,
      0,
      1.154565,
      3.335582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.347521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.926880,
      0.168337,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.534283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.658820,
      NULL,
      NULL,
      NULL,
      0.196019,
      NULL,
      NULL,
      NULL,
      3.138944,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.864371,
      NULL,
      NULL,
      NULL,
      0.648673,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.160176,
      NULL,
      NULL,
      1.491073,
      NULL,
      NULL,
      0.379739,
      NULL,
      NULL,
      NULL,
      NULL,
      1.674840,
      119.146632,
      NULL,
      0.410687,
      1,
      1.437809,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0.554782,
      NULL,
      2.079252,
      NULL,
      0.739270,
      1,
      0,
      NULL,
      3.483897,
      NULL,
      1.772110,
      NULL,
      NULL,
      NULL,
      1.505083,
      NULL,
      NULL,
      NULL,
      3.475413,
      NULL,
      6.268245,
      NULL,
      NULL,
      16.960842,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.456873,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.028177,
      NULL,
      1.797990,
      NULL,
      0.889438,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.535645,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.842248,
      1.590871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      5.287454,
      3,
      0,
      3.617860,
      1,
      NULL,
      0,
      3,
      NULL,
      0.608141,
      1,
      NULL,
      1.052589,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.526532,
      3.238957,
      NULL,
      3,
      2.025849,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.855519,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.847526,
      1,
      NULL,
      1.581679,
      0.630021,
      NULL,
      0.209581,
      0,
      1.991514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.317728,
      NULL,
      1.696389,
      NULL,
      1,
      NULL,
      4,
      5,
      5,
      1,
      NULL,
      NULL,
      NULL,
      108,
      2,
      1,
      5,
      '13040',
      '43422',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


