set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9026442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      3,
      1.371861,
      2,
      0,
      '2123',
      1.162665,
      1,
      NULL,
      NULL,
      ' 7-16-1984',
      5,
      NULL,
      6.500008,
      3.805795,
      NULL,
      ' 3- 2-1976',
      4.833984,
      0.681241,
      240.618124,
      76,
      NULL,
      NULL,
      '10- 1-1998',
      NULL,
      0.278356,
      NULL,
      0.028676,
      NULL,
      0.855962,
      1.557737,
      1.145827,
      1,
      0.558029,
      21.328404,
      NULL,
      17.097589,
      3.284729,
      41,
      197,
      2,
      14.399330,
      7.196983,
      0,
      1,
      0,
      0,
      0.240660,
      0.418905,
      0.761197,
      1.623405,
      0.533482,
      2.300011,
      0.280051,
      0,
      1,
      2.542210,
      NULL,
      3.558073,
      NULL,
      4,
      1.095635,
      NULL,
      NULL,
      1,
      0,
      2,
      0.776786,
      0.220146,
      0.668185,
      1,
      NULL,
      5.853917,
      2,
      0,
      2,
      0.535238,
      NULL,
      NULL,
      NULL,
      0.036474,
      NULL,
      NULL,
      7,
      NULL,
      3.404466,
      NULL,
      NULL,
      NULL,
      1.868298,
      0.744900,
      3,
      0.313078,
      1.430441,
      1.912218,
      3.692963,
      2,
      0.076556,
      0.258822,
      NULL,
      1,
      0,
      1.189103,
      1.292475,
      1.203223,
      2,
      1.677290,
      NULL,
      3,
      1.471467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.296412,
      1.244012,
      2,
      5.461725,
      3.825638,
      1,
      0,
      1,
      1,
      3.865187,
      0.369903,
      1.710824,
      0.381493,
      1,
      1,
      NULL,
      0,
      NULL,
      0.834369,
      6.760367,
      3,
      0,
      5.913660,
      1,
      NULL,
      NULL,
      NULL,
      3.688164,
      0.455089,
      1.908778,
      3.866016,
      2.785584,
      NULL,
      2,
      9.663071,
      1.181080,
      3,
      3.525044,
      5.374951,
      0.329440,
      NULL,
      9.641581,
      NULL,
      3.890926,
      2,
      0.954084,
      NULL,
      397,
      ' 2- 3-1984',
      NULL,
      1,
      1.403656,
      1.881335,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.235749,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.342900,
      NULL,
      18,
      0.943740,
      1,
      0.378692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.069486,
      0.169049,
      1.433766,
      NULL,
      NULL,
      NULL,
      1,
      1.662376,
      5.400408,
      NULL,
      NULL,
      9,
      1.449798,
      NULL,
      NULL,
      NULL,
      1.890582,
      1.646481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.199074,
      0.367929,
      0,
      0,
      0,
      1,
      0.205843,
      2.234369,
      13.089549,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1,
      3.580352,
      NULL,
      NULL,
      1.786224,
      NULL,
      0.478073,
      NULL,
      0.529990,
      2.576326,
      3.607975,
      1,
      0.670865,
      1.416714,
      1,
      1.922818,
      NULL,
      0.280507,
      1,
      0,
      1,
      0.056242,
      0,
      0.973315,
      0.563810,
      0.931461,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.173180,
      NULL,
      47.804403,
      22,
      66,
      2.101109,
      0.439193,
      2,
      '20113',
      '01444',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.269586,
      1,
      0.704009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      162.039130,
      NULL,
      2,
      NULL,
      0,
      0.083210,
      1.129239,
      0,
      0.802869,
      0,
      1,
      1.255176,
      1.421328,
      1.468160,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1.702634,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.377970,
      NULL,
      NULL,
      NULL,
      3.704369,
      NULL,
      NULL,
      1.078853,
      7,
      0.047090,
      2.652575,
      2,
      NULL,
      0,
      NULL,
      0.252214,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084985,
      NULL,
      1,
      NULL,
      1.201561,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.454475,
      NULL,
      1.506939,
      NULL,
      0,
      NULL,
      1,
      3.679161,
      0.471562,
      1.019249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323483,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.139716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.956745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.047320,
      NULL,
      1.199957,
      NULL,
      0.295797,
      1,
      0,
      7,
      0,
      0.492351,
      NULL,
      NULL,
      NULL,
      2.886990,
      7,
      0,
      2.797613,
      5.468129,
      6,
      3,
      2.232410,
      11,
      1,
      0,
      0,
      1.304828,
      NULL,
      NULL,
      0.319061,
      0,
      NULL,
      0.807908,
      0,
      NULL,
      1,
      0.190355,
      NULL,
      0.657782,
      3.451524,
      NULL,
      0.375500,
      1.732732,
      NULL,
      2.978364,
      2,
      NULL,
      0.761692,
      0,
      NULL,
      1,
      0.941381,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.744120,
      1.190655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.104818,
      0.515143,
      NULL,
      2.160409,
      NULL,
      1.739511,
      NULL,
      2.825777,
      NULL,
      NULL,
      NULL,
      1.502895,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2.536175,
      NULL,
      NULL,
      NULL,
      1.540522,
      NULL,
      1.169961,
      NULL,
      0.550987,
      NULL,
      24.422955,
      2.964958,
      NULL,
      0.525586,
      NULL,
      1.553279,
      NULL,
      1,
      NULL,
      1,
      3,
      3,
      1.564905,
      NULL,
      NULL,
      NULL,
      NULL,
      3.053595,
      1,
      3.857450,
      '42302',
      NULL,
      '41301',
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


