set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9650054';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00',
      1,
      NULL,
      '1004012',
      2,
      0.173842,
      3,
      1,
      '3001',
      3,
      0,
      NULL,
      NULL,
      NULL,
      57,
      28.204070,
      NULL,
      0.162148,
      0.079483,
      ' 9- 5-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 3-1997',
      ' 4- 8-1993',
      NULL,
      0,
      2.049849,
      0.199086,
      3,
      1.517007,
      1,
      0,
      0.115668,
      1,
      19,
      2,
      1.350317,
      1.890573,
      NULL,
      NULL,
      NULL,
      NULL,
      0.057434,
      7.881955,
      NULL,
      0,
      0,
      NULL,
      1,
      0.196391,
      1.687460,
      1,
      1.495989,
      0,
      1,
      0,
      3.476340,
      3.344893,
      4,
      NULL,
      1.830296,
      NULL,
      NULL,
      3.329083,
      0.989705,
      8,
      1.160461,
      0.692570,
      1.730140,
      0.238785,
      NULL,
      NULL,
      5.632235,
      0,
      0.665543,
      NULL,
      0,
      0.626688,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.711586,
      NULL,
      1.691888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231596,
      0,
      1.271776,
      1.757366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.413378,
      1,
      4.084279,
      9.188230,
      6.210933,
      NULL,
      0,
      1.466975,
      0,
      1,
      NULL,
      0,
      0.701315,
      1.400399,
      0,
      0,
      2.718956,
      NULL,
      1.192572,
      NULL,
      1,
      0.071878,
      NULL,
      NULL,
      1,
      2.318338,
      0.475918,
      0,
      2.008458,
      0,
      0.066776,
      NULL,
      1.700039,
      6,
      5.943800,
      8.470626,
      6.128291,
      0,
      6.369675,
      2.397084,
      5,
      5,
      0.530440,
      2,
      5,
      NULL,
      ' 2-17-1986',
      412,
      ' 9-14-1985',
      150,
      0,
      1,
      NULL,
      0.403342,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.240657,
      1,
      1.781380,
      1.106838,
      3,
      0,
      0.546852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.451555,
      0.099258,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.498787,
      1.087590,
      0,
      1.246180,
      0.656496,
      NULL,
      NULL,
      NULL,
      0,
      0.525136,
      0.829728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.438073,
      0.203881,
      1.462279,
      0.074497,
      0,
      0,
      1,
      1,
      38,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.724259,
      2.016072,
      2,
      1,
      3.419271,
      0.246778,
      2.582194,
      1.852294,
      0,
      3,
      NULL,
      1,
      2.727712,
      0.495773,
      NULL,
      1,
      0,
      0.643819,
      0,
      0,
      NULL,
      0,
      0.746379,
      1,
      0,
      1,
      NULL,
      0,
      2,
      0,
      2,
      2,
      5.536098,
      NULL,
      6,
      4,
      2.310165,
      3.005517,
      2.915652,
      NULL,
      1,
      2,
      18,
      3,
      1.605362,
      5.337427,
      NULL,
      13,
      4,
      1,
      NULL,
      1.415975,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      3,
      NULL,
      197,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.814644,
      NULL,
      NULL,
      0,
      0.255906,
      NULL,
      1.097587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.204051,
      3,
      2,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.401014,
      NULL,
      1.408944,
      NULL,
      NULL,
      0.665698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.824107,
      NULL,
      5,
      0.505725,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.724946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      3.152613,
      2,
      0.006246,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.380180,
      5.443805,
      3,
      NULL,
      0.732976,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.510651,
      1.551575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.265559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.152700,
      NULL,
      NULL,
      1.065416,
      3.653734,
      0.955624,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.871073,
      3,
      0,
      2,
      2.293115,
      2.743000,
      1,
      0,
      4,
      1,
      3.940913,
      0,
      3.988945,
      2,
      NULL,
      0.855477,
      2,
      3,
      2,
      3.554622,
      3.151360,
      1,
      NULL,
      4,
      5.775684,
      NULL,
      2,
      NULL,
      9,
      7.602334,
      NULL,
      NULL,
      0.605820,
      NULL,
      1.351049,
      0.854882,
      NULL,
      NULL,
      1.723719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057859,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.125680,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.139612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.557430,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.588154,
      NULL,
      NULL,
      NULL,
      0.165807,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.701525,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.499787,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.917530,
      NULL,
      1.961920,
      49.234702,
      0.255162,
      1,
      1.711484,
      0.218299,
      1,
      1.528283,
      1.253784,
      1.415398,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0.759964,
      1,
      1,
      0.760601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.242692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.692369,
      NULL,
      4.120564,
      2,
      NULL,
      0.238695,
      5.636650,
      NULL,
      2.169498,
      3,
      1.147682,
      1,
      NULL,
      NULL,
      1.888461,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.379300,
      0,
      NULL,
      NULL,
      1.259004,
      NULL,
      0.086543,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.444126,
      NULL,
      NULL,
      0.541632,
      0.726163,
      NULL,
      1,
      3,
      NULL,
      0.650988,
      NULL,
      NULL,
      0.207421,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.799373,
      NULL,
      0.019740,
      NULL,
      NULL,
      NULL,
      NULL,
      2.443038,
      2.667911,
      1,
      0,
      NULL,
      29,
      11.244272,
      3,
      NULL,
      3,
      '20122',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      1.007013,
      '',
      NULL,
      '');
commit;
end;
/


