set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9664148';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '20',
      31.091989,
      42.796049,
      '0333442',
      NULL,
      1.035186,
      2,
      0,
      '4304',
      3,
      1,
      NULL,
      NULL,
      ' 7-17-1997',
      137,
      4.035072,
      NULL,
      2.335532,
      0,
      ' 8-17-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 4-16-1984',
      ' 4-24-1974',
      ' 4- 4-2000',
      1,
      NULL,
      3,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      623.750963,
      4.934838,
      19,
      1.200089,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.072776,
      4.576894,
      2.216626,
      11,
      1.288018,
      NULL,
      4.280569,
      NULL,
      1.163489,
      1,
      NULL,
      1,
      2.076951,
      NULL,
      NULL,
      NULL,
      0,
      4.972727,
      NULL,
      2.299122,
      NULL,
      NULL,
      NULL,
      0.168518,
      NULL,
      NULL,
      4,
      2,
      0,
      3.287192,
      2.263135,
      3.045109,
      2.516530,
      1,
      3.034070,
      0.037583,
      3.396179,
      0.331134,
      1,
      0,
      NULL,
      1,
      1.897933,
      NULL,
      2.621454,
      0,
      0,
      0.937318,
      7.434098,
      1.114067,
      NULL,
      3.123383,
      1,
      NULL,
      NULL,
      1.818265,
      NULL,
      NULL,
      1.198046,
      NULL,
      NULL,
      0.636532,
      3,
      NULL,
      0.758521,
      0,
      3,
      0,
      0,
      1,
      0,
      8,
      1.842593,
      0,
      0,
      0,
      0,
      NULL,
      0.253951,
      NULL,
      0,
      0.636493,
      0.653410,
      0,
      2,
      1.794483,
      1.967928,
      1.476036,
      0,
      3,
      5.420436,
      NULL,
      NULL,
      6,
      5,
      1,
      3.524634,
      4,
      4.181960,
      2,
      8,
      5,
      3,
      1,
      0.166958,
      2.692440,
      ' 8-17-1987',
      4177,
      NULL,
      824,
      2,
      NULL,
      1,
      7,
      1.669045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424688,
      2.020198,
      7,
      NULL,
      1.285831,
      NULL,
      1,
      4,
      NULL,
      3.336072,
      0.320550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.666631,
      0.911522,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.907981,
      0.408676,
      1,
      0,
      NULL,
      0.130735,
      1.779344,
      18.124491,
      0.624532,
      1.980098,
      50.988230,
      477,
      124,
      0.198003,
      2.090461,
      1,
      2,
      1,
      7,
      4,
      NULL,
      NULL,
      0,
      0.899893,
      3,
      NULL,
      7.303128,
      NULL,
      NULL,
      NULL,
      0.182546,
      1.613719,
      0.827212,
      1,
      3,
      NULL,
      NULL,
      1.840882,
      0,
      1.825152,
      1.321771,
      NULL,
      2.476703,
      7,
      1,
      0,
      NULL,
      NULL,
      5,
      5,
      2.095542,
      1.545530,
      2.389946,
      NULL,
      2.968330,
      NULL,
      NULL,
      62.700246,
      1.344300,
      1.382071,
      45,
      NULL,
      63.491285,
      47.296773,
      0.371371,
      NULL,
      5,
      '10304',
      '41033',
      '',
      0,
      '',
      '',
      NULL,
      3,
      '01200',
      '42421',
      '',
      3,
      19,
      NULL,
      12.849003,
      2.832429,
      23.465141,
      9.933957,
      22.585927,
      2,
      3,
      0.126647,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.879046,
      3,
      1.131898,
      1.306600,
      1,
      0.835351,
      0,
      0,
      1.528540,
      1,
      NULL,
      0,
      1.865087,
      0.483590,
      NULL,
      2,
      0.936133,
      NULL,
      0.510248,
      3,
      3.157600,
      NULL,
      NULL,
      NULL,
      2.387015,
      2.369590,
      2.388769,
      1,
      3,
      9,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.345412,
      0,
      3.144833,
      NULL,
      NULL,
      1.498860,
      2,
      2,
      1.296788,
      2.705746,
      0,
      1,
      0.309380,
      0.355614,
      0,
      2.578971,
      NULL,
      1.901163,
      1,
      0.569003,
      0,
      2,
      0.313409,
      1.451511,
      2.211647,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      4.540616,
      NULL,
      0.737576,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.785584,
      0.530458,
      0.036047,
      NULL,
      3.466669,
      1.790000,
      2,
      3.581902,
      0.410188,
      0.340628,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3.191051,
      2,
      0,
      0.564210,
      NULL,
      0.935052,
      1.740196,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1.958711,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      1.018587,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.195798,
      NULL,
      NULL,
      NULL,
      NULL,
      0.479384,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.625590,
      NULL,
      2,
      2.564661,
      3.781355,
      NULL,
      0,
      1,
      6,
      5.274155,
      3.047563,
      3,
      1,
      0,
      3,
      NULL,
      0.738520,
      3.491334,
      2.792436,
      3,
      2.436843,
      2.732418,
      3,
      0,
      3,
      1,
      3.896490,
      1,
      0,
      1.226234,
      NULL,
      1,
      0.756134,
      0.762139,
      1.817289,
      1,
      2.835900,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.142366,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.371925,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      2.327213,
      1,
      NULL,
      NULL,
      1.556543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.227499,
      NULL,
      NULL,
      NULL,
      0.444767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.638695,
      NULL,
      NULL,
      NULL,
      1.000585,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.649480,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.396440,
      510,
      NULL,
      3.838828,
      NULL,
      1.731203,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.953399,
      72,
      0,
      149,
      30.549217,
      NULL,
      0.653158,
      NULL,
      0,
      NULL,
      0.113625,
      1.689574,
      0,
      NULL,
      1.657265,
      NULL,
      1,
      0.972343,
      0.265626,
      0.299745,
      1.270413,
      1,
      0,
      NULL,
      0.839221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      119,
      NULL,
      3,
      8.052786,
      0,
      0.708488,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.642913,
      NULL,
      1,
      NULL,
      0.422277,
      NULL,
      1.990861,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.275547,
      0,
      2.810816,
      0.611255,
      NULL,
      1,
      7,
      NULL,
      2.549729,
      1,
      0,
      1.316960,
      NULL,
      1,
      1.870514,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.418269,
      NULL,
      0,
      1,
      NULL,
      1,
      1.755311,
      NULL,
      0,
      1.956143,
      NULL,
      0.050924,
      1,
      NULL,
      0.667785,
      0,
      NULL,
      0,
      1.845794,
      NULL,
      0,
      0.338313,
      NULL,
      3.186091,
      0.775083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.386176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.628146,
      5,
      5.394101,
      1.760790,
      NULL,
      NULL,
      NULL,
      26,
      1,
      NULL,
      1,
      '14212',
      '33004',
      '',
      0.307692,
      NULL,
      '',
      '',
      4.568597,
      '43132',
      NULL,
      NULL);
commit;
end;
/


