set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8700949';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '34',
      '34',
      NULL,
      13.635942,
      '2024142',
      2.772526,
      0.813028,
      2,
      3,
      NULL,
      2.833644,
      0.590823,
      NULL,
      NULL,
      NULL,
      135.129316,
      3,
      NULL,
      1,
      0.691028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569020,
      NULL,
      ' 3-18-2000',
      ' 0- 3-2000',
      NULL,
      2.925488,
      3,
      1,
      1.891858,
      0.346858,
      3,
      NULL,
      0,
      0,
      10,
      15.085447,
      10.752433,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      1,
      1.171626,
      4.080878,
      0.348302,
      3,
      1.269622,
      1,
      0,
      0,
      1.093154,
      1,
      0,
      NULL,
      NULL,
      NULL,
      4,
      7,
      0.008581,
      0,
      3.766531,
      0,
      NULL,
      0.101970,
      1,
      0,
      0.218613,
      1,
      7.640702,
      0.465146,
      NULL,
      0,
      1,
      1.550192,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      1,
      0.137750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.546888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.457840,
      1.788747,
      0.756445,
      0.603338,
      4,
      6.792025,
      5,
      1,
      1.943755,
      0,
      1.280327,
      0.478087,
      1.060428,
      7.291947,
      0.361754,
      1,
      NULL,
      1.747799,
      0.634295,
      NULL,
      NULL,
      1,
      1,
      1.266507,
      1.361558,
      0.519800,
      0.607338,
      2.669551,
      1,
      0,
      0,
      0.919479,
      1,
      1,
      1.684262,
      0,
      9,
      0.966784,
      2.315555,
      NULL,
      1.833789,
      5.612875,
      6,
      3,
      1,
      1,
      1.086594,
      NULL,
      ' 2- 2-1988',
      NULL,
      ' 1-28-1988',
      1094,
      3.005865,
      NULL,
      0,
      7.088673,
      0.790515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.437287,
      0,
      1.386775,
      3,
      NULL,
      1.545835,
      4,
      0.035062,
      NULL,
      0.676614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.612703,
      NULL,
      NULL,
      NULL,
      NULL,
      0.096077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.733312,
      0.910709,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.226205,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473576,
      0,
      1,
      0,
      1,
      1,
      1.682139,
      0,
      NULL,
      3.616681,
      1.081195,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.671539,
      2.706700,
      1,
      1.463976,
      0.682908,
      0,
      2.155070,
      2.504149,
      2,
      NULL,
      NULL,
      0.688573,
      0,
      1.518543,
      0.225074,
      0.863911,
      1,
      4,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      0,
      1.530957,
      0,
      0,
      NULL,
      8,
      NULL,
      5,
      5.792511,
      4,
      NULL,
      1,
      1,
      6.557490,
      2.996837,
      NULL,
      0.160635,
      39,
      NULL,
      2,
      49,
      NULL,
      NULL,
      19,
      1.768268,
      NULL,
      3,
      '11201',
      NULL,
      NULL,
      1.020297,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      40,
      47,
      14,
      NULL,
      35,
      3,
      NULL,
      3,
      3,
      NULL,
      2.507529,
      0,
      NULL,
      1.054227,
      0.538055,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.026672,
      0.300497,
      1,
      0.298763,
      0,
      2.373626,
      0.375399,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.675784,
      NULL,
      NULL,
      0.508027,
      NULL,
      NULL,
      0.512301,
      6.181782,
      5,
      0,
      1.380814,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.907286,
      NULL,
      0.915847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.018842,
      1.919671,
      1.564958,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.083128,
      1.315930,
      1.713415,
      1.175798,
      3.305500,
      0.282335,
      3,
      3,
      1.854539,
      1,
      1,
      NULL,
      NULL,
      3.997169,
      1.572859,
      0,
      9.121968,
      9.986133,
      4.196348,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.327384,
      NULL,
      1.473429,
      3,
      0,
      NULL,
      1.696058,
      NULL,
      NULL,
      5.652221,
      2.853122,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.012034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.134601,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.444909,
      0.392032,
      NULL,
      3.649974,
      NULL,
      NULL,
      3.748242,
      4,
      NULL,
      1.780900,
      1,
      NULL,
      0.173831,
      3,
      3,
      1.268314,
      2,
      2.994530,
      0,
      0.248054,
      6.004118,
      7.615096,
      4,
      0.174113,
      NULL,
      NULL,
      0.409524,
      2,
      0.887899,
      1,
      0.483224,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.300004,
      NULL,
      NULL,
      2.634144,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      0.433324,
      NULL,
      1.616714,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.073305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.884030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.256751,
      NULL,
      NULL,
      NULL,
      0.298040,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.490800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.614808,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.816497,
      NULL,
      NULL,
      98.628860,
      15,
      0,
      0.058951,
      1.176681,
      1,
      1.156918,
      0.687095,
      0,
      0,
      1,
      0,
      0.329030,
      0,
      1.754606,
      NULL,
      1.054559,
      0.792487,
      NULL,
      1.558152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.419167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161707,
      0.016185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.404956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.057836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.109733,
      0.355977,
      1,
      1.735652,
      1,
      NULL,
      NULL,
      0.926133,
      0,
      0.613448,
      NULL,
      0,
      NULL,
      0.546716,
      0.465187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.273264,
      2.128829,
      2,
      15.679729,
      1,
      2.654332,
      4,
      NULL,
      12,
      3.402003,
      0.686190,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.535017,
      NULL,
      0,
      1.437372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      3,
      NULL,
      0,
      0.903580,
      NULL,
      1.877187,
      1.596314,
      NULL,
      0.096919,
      1.333421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.094457,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      5,
      NULL,
      2,
      NULL,
      3,
      46,
      25,
      1.858834,
      4.801948,
      0,
      '33442',
      '',
      '',
      1.529831,
      '',
      '',
      '',
      1.013178,
      '',
      NULL,
      '');
commit;
end;
/


