set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6850715';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      1.006112,
      NULL,
      3,
      2.284475,
      1,
      2.347424,
      1.847265,
      '101',
      '31110102',
      37,
      NULL,
      '0442042',
      3.068279,
      1.698089,
      2,
      2,
      '4024',
      6,
      0.993792,
      NULL,
      NULL,
      '10-13-2001',
      96.819277,
      7.375366,
      NULL,
      0.719318,
      NULL,
      ' 2-17-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 1-29-1989',
      ' 1-18-1987',
      '11- 7-1990',
      NULL,
      1.787775,
      1,
      3,
      0,
      NULL,
      3.360225,
      1.820562,
      0,
      17.438901,
      6.614463,
      1.684804,
      5.896889,
      NULL,
      NULL,
      NULL,
      NULL,
      3.528070,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.691355,
      0,
      1,
      1.088778,
      1,
      1.864327,
      174,
      5.069524,
      2,
      0,
      3,
      3.077545,
      NULL,
      NULL,
      0.801363,
      0,
      5.986521,
      4.672000,
      1.150596,
      0.863401,
      0,
      1,
      NULL,
      10,
      3,
      2.736234,
      1,
      4.135905,
      0.355303,
      NULL,
      NULL,
      3.464426,
      4.118898,
      0,
      5,
      0.918780,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.522521,
      NULL,
      0.120310,
      0,
      1.871327,
      2,
      1.714274,
      2.582574,
      3.730968,
      4.144624,
      0,
      NULL,
      2.553497,
      5.468478,
      0,
      1.156241,
      NULL,
      NULL,
      1.597761,
      3.822069,
      1,
      0,
      NULL,
      1.628604,
      NULL,
      1.720537,
      1.483274,
      3.336739,
      0,
      0,
      8,
      NULL,
      5.425980,
      1.135729,
      1,
      1,
      1,
      0.457720,
      1.028093,
      1,
      NULL,
      0,
      NULL,
      4,
      3,
      1.796002,
      2.783737,
      3,
      4,
      6.703872,
      4.741441,
      4.400687,
      NULL,
      5,
      7.854312,
      0,
      5.134705,
      NULL,
      6.708740,
      NULL,
      9.645375,
      NULL,
      7.360964,
      7.411862,
      11.247959,
      3.628910,
      2.064741,
      4.181877,
      NULL,
      ' 0-28-1985',
      NULL,
      ' 3- 1-1998',
      NULL,
      1,
      4,
      1.557495,
      5,
      0.729967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.568901,
      0.685590,
      0.954193,
      0,
      NULL,
      0.124686,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      0.335291,
      NULL,
      4,
      1.671242,
      0,
      0.927484,
      3,
      2,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2.513613,
      7.752677,
      1,
      5,
      1.473870,
      0,
      6.015205,
      2,
      NULL,
      NULL,
      NULL,
      0,
      8.035639,
      NULL,
      0,
      5.502425,
      2.392983,
      2.623149,
      NULL,
      2190,
      ' 1-20-1974',
      1247.377150,
      3,
      NULL,
      1.818751,
      1.932402,
      0.855120,
      NULL,
      0.186910,
      1,
      0.943668,
      NULL,
      NULL,
      9,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3.923437,
      NULL,
      2.608520,
      3.380485,
      2,
      1,
      3,
      0.023462,
      3.468024,
      3.185819,
      3.367214,
      2,
      0.898360,
      2,
      0.380651,
      3,
      0,
      NULL,
      1,
      1,
      1.338260,
      1,
      NULL,
      1,
      1.087288,
      0,
      NULL,
      NULL,
      NULL,
      1.226377,
      0,
      0,
      4,
      NULL,
      NULL,
      7.763233,
      NULL,
      0.609690,
      3.724253,
      0.697046,
      NULL,
      3,
      NULL,
      1,
      2.933358,
      3.407263,
      1,
      3.161582,
      NULL,
      32,
      37,
      3.418488,
      1.125055,
      3.821630,
      '40312',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      '',
      3,
      NULL,
      98.048907,
      4.025087,
      NULL,
      42.518005,
      13,
      NULL,
      3.733074,
      1,
      2.168283,
      2,
      0,
      NULL,
      NULL,
      3,
      2.204023,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.545247,
      3,
      3.870284,
      NULL,
      2,
      0,
      2,
      NULL,
      0.302244,
      NULL,
      1.488559,
      0.783802,
      NULL,
      NULL,
      0.827042,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.680407,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.018902,
      3.986693,
      0,
      1,
      2,
      1.079830,
      1,
      0.610491,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.916606,
      1,
      2.589870,
      2,
      0.619755,
      0,
      0,
      1.381066,
      0.694176,
      1,
      1,
      0.787488,
      1,
      1.928767,
      0.527994,
      2,
      1.170770,
      3,
      NULL,
      2.721643,
      0.219883,
      NULL,
      3,
      NULL,
      0.258321,
      2.347659,
      NULL,
      NULL,
      1.359925,
      0.126070,
      NULL,
      NULL,
      NULL,
      0.217244,
      2,
      NULL,
      0.248814,
      1.581493,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.426927,
      NULL,
      NULL,
      2.900994,
      NULL,
      1.431523,
      1,
      2.395520,
      0.699457,
      1.219609,
      NULL,
      NULL,
      1.043382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.709473,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.082214,
      NULL,
      1,
      6.139770,
      0.455052,
      5,
      6,
      4.768940,
      2.370758,
      0,
      0.975196,
      0.001919,
      NULL,
      1.802388,
      0.496732,
      NULL,
      NULL,
      NULL,
      2.205470,
      0,
      NULL,
      9,
      NULL,
      5.959653,
      2,
      0.197242,
      3.854671,
      1.485176,
      3.176030,
      0.792468,
      2,
      NULL,
      3.614307,
      3,
      1.579145,
      3,
      4.297435,
      2.385507,
      NULL,
      NULL,
      1,
      0,
      3.893907,
      0,
      3.579635,
      0,
      1.851764,
      NULL,
      0,
      NULL,
      1.142774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.021915,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.655463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.481572,
      NULL,
      NULL,
      NULL,
      2.603391,
      NULL,
      NULL,
      NULL,
      2.120767,
      NULL,
      5,
      NULL,
      160.938086,
      NULL,
      2.713931,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.761159,
      NULL,
      2,
      NULL,
      3.261266,
      NULL,
      0.845294,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.675497,
      NULL,
      1.331478,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.474784,
      NULL,
      0.515401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133534,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.942487,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.009632,
      NULL,
      0,
      NULL,
      0.083853,
      NULL,
      1.864450,
      NULL,
      NULL,
      NULL,
      1.090662,
      NULL,
      NULL,
      NULL,
      0.923847,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      2,
      0.828131,
      1.688877,
      1.364141,
      1.647648,
      NULL,
      NULL,
      2,
      21.358971,
      6.706226,
      1,
      NULL,
      NULL,
      3,
      8.299004,
      3,
      2,
      1.027507,
      1,
      0.320264,
      NULL,
      NULL,
      0.076588,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.183829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.571277,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.397534,
      0,
      NULL,
      0.284705,
      3.693739,
      0,
      1.806541,
      5.468713,
      2,
      3.564439,
      NULL,
      0,
      1.259840,
      NULL,
      1,
      3,
      NULL,
      0.015324,
      NULL,
      NULL,
      2.309838,
      2,
      NULL,
      2.920929,
      0.462672,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.610147,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.369954,
      NULL,
      3,
      1.229067,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.238371,
      NULL,
      2,
      NULL,
      2,
      NULL,
      0.348682,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.784633,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      38.318172,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.850758,
      NULL,
      1,
      2.212899,
      6,
      1.751510,
      NULL,
      NULL,
      NULL,
      35.540504,
      3,
      0,
      5,
      '44141',
      '10343',
      '',
      1,
      '',
      '',
      '',
      1.343082,
      NULL,
      '',
      '');
commit;
end;
/


