set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '4444043',
      NULL,
      NULL,
      NULL,
      0,
      '1124',
      2,
      1,
      NULL,
      NULL,
      ' 9-11-1995',
      54,
      NULL,
      NULL,
      2,
      3.049159,
      '10-12-1993',
      0,
      0.741191,
      167,
      NULL,
      3.591348,
      ' 2- 3-1976',
      NULL,
      ' 7- 0-1998',
      3.455390,
      3.121985,
      NULL,
      2.770934,
      0,
      1,
      3.571698,
      1.110691,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      4,
      17.561570,
      7.831900,
      1,
      9,
      1.327291,
      0.175562,
      NULL,
      1,
      0,
      NULL,
      1,
      1.789893,
      0.373896,
      NULL,
      1,
      2.647170,
      1.600634,
      0.036741,
      NULL,
      11,
      3.019792,
      9.219339,
      0.504382,
      0.411900,
      0.494960,
      0.185036,
      4.860838,
      NULL,
      1.492390,
      1,
      NULL,
      NULL,
      0,
      3.015956,
      0.236822,
      3.185484,
      0,
      1,
      1.261268,
      NULL,
      NULL,
      1.003593,
      NULL,
      NULL,
      6,
      2,
      0,
      0,
      3.954256,
      1.241898,
      1.961343,
      3,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1.537640,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6.861486,
      2,
      1.513144,
      1.099218,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      1,
      1.529226,
      2.098650,
      0,
      1.223373,
      0,
      1,
      1.154396,
      0.629249,
      0,
      1.768088,
      1,
      1.325816,
      1.006957,
      1.807512,
      0.357601,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      3.613130,
      0,
      NULL,
      4.554598,
      7.714119,
      1,
      0,
      2.348303,
      1,
      2,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      NULL,
      3.711014,
      4.862597,
      1.259498,
      1.710563,
      6,
      NULL,
      ' 0- 9-1996',
      5,
      ' 8-26-1993',
      0.304894,
      0,
      0,
      0,
      2,
      1.866104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.444855,
      1.341663,
      NULL,
      1,
      NULL,
      1.238065,
      NULL,
      1.015582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.214783,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.862578,
      NULL,
      3,
      0.123236,
      0,
      0,
      1,
      1,
      0.394906,
      3.594886,
      2.658652,
      0,
      NULL,
      1.711781,
      0.369021,
      5,
      3,
      1.299087,
      NULL,
      NULL,
      0.567598,
      7.291257,
      1.797613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.503579,
      0.773992,
      NULL,
      0.256109,
      1,
      NULL,
      2.237222,
      17,
      2.513353,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906917,
      1.306957,
      NULL,
      3.462063,
      3,
      1,
      3,
      0,
      2,
      NULL,
      3,
      0,
      3,
      0.076587,
      1,
      0,
      0,
      3,
      NULL,
      3.189397,
      0,
      1.163362,
      0,
      1.671863,
      NULL,
      NULL,
      1,
      0.484237,
      NULL,
      1.349124,
      0.697138,
      0.666599,
      5.980201,
      11,
      4.238121,
      8.159069,
      1,
      3,
      3.963703,
      NULL,
      7,
      2,
      3.942240,
      2,
      26,
      1.283131,
      1,
      NULL,
      31,
      41,
      NULL,
      5.094097,
      2.967591,
      2,
      '13010',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      35,
      19.876643,
      32,
      1.849875,
      NULL,
      NULL,
      NULL,
      NULL,
      1.502333,
      NULL,
      NULL,
      1.683163,
      NULL,
      NULL,
      1.034205,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.322556,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.296039,
      NULL,
      NULL,
      1.596080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.372229,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.865880,
      NULL,
      NULL,
      1.870546,
      NULL,
      NULL,
      0.249754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.175658,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.381591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286713,
      NULL,
      NULL,
      0.830522,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.541320,
      NULL,
      NULL,
      1.863502,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.065881,
      NULL,
      1.637350,
      1,
      NULL,
      NULL,
      0.472587,
      2,
      2,
      5.486903,
      3,
      0,
      1,
      NULL,
      NULL,
      0.927772,
      NULL,
      NULL,
      0,
      3,
      3.518706,
      1.504850,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.338884,
      0.069766,
      2.686906,
      NULL,
      2,
      0,
      0,
      3.653327,
      0,
      4.004191,
      4,
      4.247457,
      3.290550,
      NULL,
      0.747538,
      NULL,
      NULL,
      0.351399,
      0.313258,
      1.193495,
      0,
      NULL,
      0.352308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.087436,
      NULL,
      2.968735,
      3.626223,
      0.703392,
      1.433036,
      1.713572,
      3.681214,
      NULL,
      NULL,
      NULL,
      10.267769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.579291,
      NULL,
      NULL,
      NULL,
      0.086373,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.524591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.817768,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.040535,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      3.569037,
      7.429635,
      0,
      0.059588,
      NULL,
      NULL,
      1.214347,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      975.856946,
      20.931790,
      NULL,
      3,
      0.190836,
      0,
      NULL,
      0,
      0,
      1,
      1.185205,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3.274218,
      NULL,
      0,
      0.475979,
      NULL,
      NULL,
      0.301458,
      1,
      NULL,
      1.756696,
      0,
      3,
      0.435949,
      50.380458,
      1.580465,
      2,
      11,
      NULL,
      2,
      3.179771,
      0.370513,
      NULL,
      0.288771,
      NULL,
      1.422957,
      NULL,
      1.822891,
      NULL,
      0.081901,
      NULL,
      0,
      NULL,
      1.836871,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.978124,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.439428,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.314696,
      NULL,
      NULL,
      3.283185,
      NULL,
      3.735580,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.837451,
      NULL,
      0.231974,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.423886,
      NULL,
      0.222990,
      NULL,
      0.964057,
      NULL,
      1.708980,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.931103,
      1,
      0.815080,
      0.111142,
      2.349853,
      NULL,
      NULL,
      1,
      0,
      0.462498,
      0,
      1.628263,
      0,
      0.938401,
      2.779475,
      13.825038,
      NULL,
      2,
      NULL,
      3.462522,
      1,
      NULL,
      0,
      NULL,
      3,
      3.770582,
      1.335152,
      NULL,
      2.387355,
      1.832468,
      3,
      NULL,
      0,
      0.654525,
      1.259195,
      NULL,
      0.259380,
      NULL,
      NULL,
      0.238815,
      0.769365,
      NULL,
      1,
      1.368201,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959935,
      2,
      NULL,
      0.017464,
      3.987178,
      NULL,
      1,
      NULL,
      NULL,
      0.176617,
      1.131870,
      NULL,
      NULL,
      1.272214,
      NULL,
      0,
      1,
      NULL,
      0.514841,
      0.978800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241272,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.149864,
      6,
      0,
      0.902141,
      NULL,
      NULL,
      45,
      100.784606,
      5.520818,
      2.906998,
      1.924707,
      '30144',
      '00243',
      '44114',
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


