set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7403992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-3-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '1142000',
      1,
      0,
      NULL,
      3,
      '0400',
      NULL,
      0,
      NULL,
      NULL,
      ' 0-18-1983',
      49.662755,
      NULL,
      1.021812,
      2,
      NULL,
      ' 2-29-2000',
      6,
      2.142416,
      337,
      NULL,
      0.512683,
      ' 4- 9-2002',
      ' 0- 6-1982',
      ' 5- 7-1994',
      2.057013,
      1.532330,
      0,
      0,
      1.738836,
      3.781176,
      NULL,
      1,
      1.455931,
      35.639770,
      6.266726,
      2.687743,
      NULL,
      NULL,
      27.155384,
      8,
      7,
      3.395650,
      4.545635,
      NULL,
      1,
      1.432897,
      1,
      NULL,
      0.318125,
      1,
      NULL,
      1,
      1,
      1.616905,
      193,
      10.640655,
      3,
      1.053501,
      2,
      4,
      1,
      1.428513,
      1,
      1,
      1,
      NULL,
      0.042088,
      NULL,
      1.435334,
      1.131456,
      1.858807,
      5,
      NULL,
      0.556817,
      NULL,
      1.400279,
      1.339460,
      NULL,
      NULL,
      0.513923,
      NULL,
      NULL,
      1.823172,
      1.158674,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.455454,
      0,
      1,
      1,
      1,
      1,
      0,
      0.787890,
      NULL,
      1.073154,
      NULL,
      1,
      0,
      1,
      0.330023,
      NULL,
      1.819906,
      2.736709,
      NULL,
      1,
      1.331324,
      1,
      NULL,
      1,
      1.865282,
      0,
      4,
      1.869624,
      3.321019,
      5,
      0,
      3.863794,
      NULL,
      NULL,
      2.279345,
      2,
      4,
      6.735584,
      3.731632,
      1.126497,
      NULL,
      5.392634,
      NULL,
      NULL,
      6.039062,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.688516,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.692835,
      0.982364,
      0.414884,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.796252,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.922779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574219,
      1.890193,
      6.453321,
      0.374730,
      1.281930,
      4,
      1.046732,
      NULL,
      NULL,
      NULL,
      0.087109,
      0.882276,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.741150,
      NULL,
      1,
      0.547899,
      1,
      NULL,
      3.858785,
      7.907732,
      2.213282,
      0,
      NULL,
      NULL,
      NULL,
      5.096042,
      1,
      1,
      0.145196,
      5.819481,
      4.283833,
      1.362636,
      4.692816,
      4.640967,
      1,
      4,
      1,
      4,
      NULL,
      NULL,
      NULL,
      8.415284,
      114.309141,
      NULL,
      36,
      79.868846,
      NULL,
      0,
      1,
      0.286211,
      0.826958,
      0,
      0,
      0.523802,
      7.287003,
      12.425473,
      1.860911,
      7.160393,
      1,
      4.810980,
      3,
      2,
      7,
      2.116869,
      0.069050,
      0,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      61,
      47.890128,
      1,
      5.884673,
      1,
      NULL,
      '12304',
      '',
      '',
      NULL,
      '32321',
      '',
      '',
      0,
      '',
      '',
      '',
      1.298138,
      21.217826,
      NULL,
      14.174367,
      2.599323,
      16,
      NULL,
      3,
      2,
      3.679985,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.481996,
      NULL,
      NULL,
      1.698019,
      1,
      0,
      2,
      1.672115,
      1,
      1.348054,
      NULL,
      0.416689,
      2,
      0.977969,
      0,
      1,
      NULL,
      NULL,
      0.684973,
      NULL,
      NULL,
      0.084101,
      NULL,
      NULL,
      0.811394,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.520451,
      7,
      NULL,
      0.718393,
      0,
      NULL,
      NULL,
      NULL,
      1.539765,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.717815,
      NULL,
      NULL,
      0.428590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684301,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583713,
      NULL,
      NULL,
      NULL,
      0,
      1.658679,
      0,
      0,
      1.662608,
      0,
      NULL,
      NULL,
      8.017394,
      3,
      NULL,
      1,
      3.616298,
      1,
      1.802318,
      NULL,
      NULL,
      2.735820,
      3.352005,
      0.596962,
      1.050066,
      NULL,
      NULL,
      0.000698,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3.670826,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.529537,
      5.825941,
      0.354696,
      5.058354,
      1,
      NULL,
      5.041123,
      NULL,
      2,
      0,
      0,
      2,
      3.641500,
      0.393273,
      0.519386,
      0,
      0.219313,
      NULL,
      6.364718,
      NULL,
      2.980952,
      2.624067,
      0.316746,
      0.131313,
      NULL,
      NULL,
      NULL,
      2.496922,
      NULL,
      0,
      0,
      0.761843,
      NULL,
      2,
      6.944000,
      1.343293,
      7,
      NULL,
      2,
      4,
      1.151006,
      0.591932,
      0,
      0,
      1,
      0.759493,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.767354,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.993054,
      NULL,
      NULL,
      0.112956,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.659863,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993939,
      NULL,
      NULL,
      NULL,
      1,
      0.286325,
      NULL,
      0,
      3.196158,
      3.314424,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.817771,
      0,
      NULL,
      NULL,
      NULL,
      1.443555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.430613,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2.524971,
      3.271412,
      NULL,
      NULL,
      0.425688,
      NULL,
      NULL,
      NULL,
      3.192412,
      0.760131,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.426572,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.874611,
      NULL,
      NULL,
      2.518140,
      NULL,
      3.308987,
      1,
      NULL,
      NULL,
      1.924880,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.231571,
      156.724976,
      3.401141,
      0.673027,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0.572632,
      1,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0.431931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.648566,
      0.739449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.405740,
      0.437511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.939727,
      1.326421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634889,
      0.454164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.591387,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.782107,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      6.382544,
      NULL,
      5.570119,
      0.209071,
      0.245185,
      11.888214,
      2,
      1.846286,
      3,
      1.491079,
      1.114931,
      0,
      2,
      1.965310,
      1.636872,
      NULL,
      NULL,
      NULL,
      0.067481,
      0.012483,
      0,
      1,
      1,
      1.258446,
      0.968002,
      0,
      1.673843,
      0.716436,
      NULL,
      0.777990,
      0,
      1.404064,
      0.482655,
      3,
      2.865879,
      2,
      NULL,
      0,
      2.963153,
      1,
      1.356537,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.826836,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.610992,
      NULL,
      0.848771,
      NULL,
      0,
      NULL,
      0.777420,
      NULL,
      0,
      NULL,
      1.324177,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.556062,
      NULL,
      0,
      28.179093,
      0.213714,
      1,
      1,
      NULL,
      0,
      1.699834,
      0.990557,
      1,
      4,
      3,
      NULL,
      2.005152,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      '10430',
      '',
      '',
      2,
      '04423',
      '',
      '',
      0.852666,
      '',
      '',
      NULL);
commit;
end;
/


