set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8205745';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      3.903238,
      1.968689,
      0,
      NULL,
      2,
      3.457278,
      2.330220,
      '432',
      '34341412',
      NULL,
      22.006322,
      '0140113',
      0.574391,
      0.281191,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      ' 9-11-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 5- 2-2000',
      NULL,
      1,
      NULL,
      2,
      0,
      0.169694,
      3.527735,
      1.738160,
      0,
      3,
      10.661799,
      NULL,
      0.259587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.129666,
      NULL,
      0.461511,
      NULL,
      NULL,
      NULL,
      0.070273,
      0.646349,
      1,
      0,
      NULL,
      0.880965,
      0.984192,
      2.686117,
      3,
      1,
      0,
      4,
      1.314435,
      0.606778,
      0,
      5,
      NULL,
      NULL,
      1,
      2.823858,
      5.429269,
      7.503486,
      NULL,
      NULL,
      NULL,
      1.982977,
      1,
      2.244726,
      0.407682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.122127,
      0,
      1.713007,
      0.639145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.154152,
      0.571666,
      5.449963,
      NULL,
      3.848366,
      NULL,
      0.663114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.543054,
      NULL,
      4,
      4.427715,
      1,
      1,
      5,
      1.325415,
      1.064514,
      0,
      0.142414,
      4,
      NULL,
      1.592746,
      0,
      0.273951,
      1.637838,
      1.815995,
      0,
      NULL,
      1,
      0,
      0,
      5,
      1.110202,
      1.613303,
      2,
      NULL,
      NULL,
      1.371833,
      NULL,
      4,
      1.273369,
      3,
      0.146727,
      7,
      4.448508,
      NULL,
      5,
      7,
      3.086160,
      0,
      1,
      7.709208,
      2,
      0.581909,
      1,
      0,
      NULL,
      343.147760,
      ' 2- 7-1992',
      0,
      NULL,
      1.942508,
      1,
      2,
      0.786526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.394178,
      0,
      3.268394,
      2,
      1,
      5.334927,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342595,
      1,
      0.363896,
      0,
      0.350033,
      1.613850,
      0.187666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.198097,
      0.392312,
      5.305171,
      4,
      0.470887,
      3,
      NULL,
      0.594120,
      NULL,
      NULL,
      0,
      1,
      0.897809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649681,
      1,
      NULL,
      0.903833,
      0,
      0,
      0,
      1.147087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.474744,
      0.383662,
      3.001180,
      0.169905,
      1.219201,
      3.690019,
      0,
      1.450622,
      3.179217,
      3.881669,
      1.915711,
      NULL,
      2.322414,
      2,
      0,
      3.398274,
      0,
      NULL,
      4,
      1,
      0,
      0.447795,
      0,
      1.120653,
      0.526076,
      1,
      0,
      1.076134,
      1.543615,
      3,
      1,
      4.713310,
      9,
      NULL,
      NULL,
      1.627415,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2.049359,
      1.331288,
      7.893038,
      3,
      1,
      59.152443,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.747899,
      '40422',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      0,
      '3220',
      '',
      '',
      NULL,
      3,
      133,
      25,
      0.470083,
      NULL,
      NULL,
      NULL,
      NULL,
      0.506853,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.781381,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.164381,
      NULL,
      NULL,
      0.056593,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.578300,
      NULL,
      NULL,
      4.964715,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.332177,
      3.786779,
      NULL,
      NULL,
      NULL,
      1.343303,
      NULL,
      NULL,
      1.922970,
      NULL,
      NULL,
      1.523062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.967926,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.364244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.996958,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.743098,
      NULL,
      NULL,
      2,
      2,
      1,
      2.760304,
      2,
      5,
      1,
      NULL,
      NULL,
      0.780517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436678,
      NULL,
      NULL,
      0.379444,
      NULL,
      NULL,
      1.055788,
      NULL,
      NULL,
      1.068901,
      NULL,
      NULL,
      1.640305,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.985041,
      NULL,
      NULL,
      1.865981,
      NULL,
      NULL,
      1.759893,
      NULL,
      NULL,
      1.013282,
      NULL,
      NULL,
      0.661766,
      NULL,
      NULL,
      3,
      1,
      1.227796,
      3.483959,
      1.356670,
      0.607508,
      0.524363,
      2.036523,
      3,
      2,
      1.851646,
      0.323337,
      3.379648,
      5.324129,
      3,
      1,
      5,
      5.390982,
      0,
      NULL,
      NULL,
      1.875750,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.082297,
      1.558667,
      NULL,
      NULL,
      2.424098,
      0.389176,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      83.452666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.380868,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.835832,
      NULL,
      NULL,
      NULL,
      1.078933,
      NULL,
      NULL,
      NULL,
      0.399373,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.675664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.486412,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6.586899,
      NULL,
      NULL,
      NULL,
      6.695430,
      0.992608,
      NULL,
      NULL,
      NULL,
      3.124121,
      3.285704,
      NULL,
      2.062644,
      60,
      NULL,
      1.743583,
      NULL,
      NULL,
      1.927573,
      NULL,
      NULL,
      1.456853,
      NULL,
      NULL,
      0.737736,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633555,
      350,
      13.883238,
      1.692571,
      0,
      0,
      0.785276,
      0.397855,
      1.822305,
      NULL,
      1.749966,
      0.995577,
      1.952590,
      0,
      1.877422,
      1,
      1.213542,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.589819,
      0.368740,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.113317,
      1.720518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.887022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.343752,
      NULL,
      2,
      NULL,
      3,
      NULL,
      187.515287,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.578439,
      1,
      3.127190,
      13.273276,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.992001,
      NULL,
      1.330074,
      0.716628,
      1.262782,
      3,
      8.380745,
      1,
      NULL,
      3,
      NULL,
      NULL,
      3,
      3.839188,
      1,
      1.966170,
      NULL,
      0.065579,
      2.813503,
      NULL,
      0.241216,
      1,
      1,
      0.995207,
      1.789254,
      0,
      NULL,
      1.414729,
      3,
      1.763030,
      1.980104,
      0.942257,
      1.523592,
      0.565462,
      NULL,
      2,
      0,
      0.616619,
      3,
      1.466627,
      1,
      0,
      0,
      1.463815,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.188915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297365,
      1.813336,
      NULL,
      NULL,
      0.386754,
      1,
      1.208941,
      0.652721,
      7.915286,
      0,
      NULL,
      NULL,
      90.548376,
      42.371445,
      4,
      5,
      0,
      '24202',
      '1112',
      '03212',
      0,
      NULL,
      '',
      NULL,
      0.508627,
      '3124',
      '',
      '');
commit;
end;
/


