set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9404807';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-2-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '0003400',
      2.962725,
      0.657810,
      3,
      3,
      '0141',
      NULL,
      0.124011,
      NULL,
      NULL,
      NULL,
      62,
      NULL,
      3,
      2.951776,
      NULL,
      ' 2- 3-1999',
      11.468350,
      NULL,
      NULL,
      187.852910,
      0,
      ' 5-17-1991',
      NULL,
      ' 9-22-1999',
      2,
      3,
      NULL,
      1.553322,
      0.017459,
      0.276886,
      2.337809,
      2.959059,
      NULL,
      NULL,
      NULL,
      11,
      7.893677,
      7,
      32,
      1,
      0,
      7.675021,
      0,
      3,
      NULL,
      2,
      1.837386,
      NULL,
      0.966801,
      1,
      1.386975,
      1,
      1,
      1,
      0.319141,
      0,
      NULL,
      1,
      3,
      7.105471,
      1,
      NULL,
      0,
      0,
      NULL,
      6.883022,
      5.063864,
      7.712428,
      5,
      0.402925,
      2.851611,
      9,
      3.889003,
      0.145214,
      2.447227,
      1.039971,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      6,
      6,
      2.029157,
      1,
      NULL,
      2.552188,
      0,
      1.688258,
      NULL,
      3.855457,
      1,
      1,
      3,
      NULL,
      1.549875,
      3.807670,
      NULL,
      0.369359,
      0.735941,
      1,
      0,
      0.222466,
      NULL,
      0.867340,
      NULL,
      1.454780,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.468224,
      1,
      NULL,
      NULL,
      1,
      0.836234,
      0,
      NULL,
      0.793726,
      1.432323,
      0,
      0.063870,
      1.741769,
      1,
      NULL,
      5,
      1.937992,
      1.410604,
      0.088661,
      NULL,
      6,
      10.090149,
      10.304815,
      0.858839,
      4,
      1.244958,
      11.580005,
      9.453528,
      3,
      2,
      NULL,
      0,
      0,
      4.073105,
      0,
      7,
      5.145261,
      4,
      NULL,
      0,
      NULL,
      5,
      1.321321,
      7,
      2.178870,
      5,
      2.615559,
      3.740378,
      ' 0- 2-1983',
      13.142700,
      '10-23-1986',
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.296228,
      NULL,
      5.955062,
      0,
      0.833549,
      1,
      1.198511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.516582,
      NULL,
      NULL,
      NULL,
      NULL,
      1.126234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.464089,
      2,
      3.979517,
      1.617219,
      1.039653,
      NULL,
      NULL,
      NULL,
      NULL,
      1.466963,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.443472,
      1,
      NULL,
      0,
      1,
      1.098669,
      NULL,
      45.039286,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.369810,
      1,
      NULL,
      NULL,
      5.803997,
      2.625555,
      0,
      7.911312,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.844536,
      3,
      0,
      1,
      NULL,
      1.205788,
      1,
      1,
      1.763951,
      0,
      1.528603,
      0.762237,
      0.113303,
      0,
      4,
      NULL,
      NULL,
      10.651098,
      7.780604,
      NULL,
      3.477230,
      3.654351,
      0,
      3,
      6.701350,
      NULL,
      2.490947,
      1,
      46,
      1,
      2.620363,
      NULL,
      26,
      9,
      74,
      NULL,
      1,
      1,
      '42103',
      '',
      '',
      1.725762,
      '',
      '',
      '',
      0.251384,
      NULL,
      '',
      '',
      3.630809,
      30.382165,
      15,
      1.190757,
      NULL,
      30,
      0.365010,
      1,
      3,
      2,
      NULL,
      1.057105,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.227327,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.278376,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.944359,
      NULL,
      NULL,
      1.474136,
      NULL,
      NULL,
      0.936599,
      NULL,
      NULL,
      1.224491,
      NULL,
      NULL,
      8.590604,
      2,
      0.467034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.566847,
      NULL,
      NULL,
      1.217471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464349,
      NULL,
      NULL,
      0.145799,
      NULL,
      NULL,
      0.786162,
      NULL,
      NULL,
      0.738379,
      NULL,
      NULL,
      0.062912,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.203970,
      1.260886,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.471758,
      NULL,
      NULL,
      3.517698,
      0,
      1,
      11,
      7,
      1.463398,
      NULL,
      3.328096,
      0.507321,
      3,
      1,
      0.527742,
      1,
      4.142978,
      NULL,
      4.723916,
      NULL,
      1,
      0.779119,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      2,
      1.257446,
      1.187496,
      2,
      1.184092,
      11,
      11.413381,
      NULL,
      3.099944,
      3.930370,
      0.592920,
      NULL,
      0,
      1.534391,
      3,
      3.426187,
      0,
      0,
      3.131312,
      0,
      2,
      10,
      1,
      2.993286,
      NULL,
      0.998209,
      2.624614,
      2,
      1.170616,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.594094,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274653,
      NULL,
      NULL,
      0.659401,
      0.775474,
      1,
      0.802450,
      0,
      NULL,
      1.063737,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315521,
      1.553141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185000,
      0.640116,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0.036533,
      NULL,
      NULL,
      0.573658,
      1,
      NULL,
      NULL,
      0.865896,
      0.168347,
      NULL,
      NULL,
      0,
      1.253587,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.765998,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.003308,
      1,
      NULL,
      NULL,
      0.407455,
      NULL,
      NULL,
      1.952143,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.945251,
      0,
      NULL,
      0.134549,
      0.515274,
      0.535221,
      1,
      0,
      NULL,
      3,
      0,
      1,
      1,
      0,
      0,
      0.521792,
      0,
      1.332411,
      1,
      3,
      3,
      0.762239,
      0,
      0,
      3,
      1.661538,
      NULL,
      0.805952,
      1,
      NULL,
      2.880708,
      1,
      23,
      NULL,
      0.169137,
      11,
      NULL,
      1,
      0.147013,
      NULL,
      NULL,
      NULL,
      NULL,
      1.115371,
      NULL,
      1.331000,
      NULL,
      0.346732,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.191831,
      NULL,
      1,
      NULL,
      0.724288,
      NULL,
      1.908743,
      NULL,
      1.421112,
      NULL,
      0.257202,
      0,
      0.728530,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.968122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.632816,
      2.820363,
      NULL,
      1,
      NULL,
      1.838386,
      NULL,
      NULL,
      NULL,
      1.316655,
      NULL,
      1.765496,
      NULL,
      1,
      NULL,
      1,
      1,
      0.029947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.925133,
      NULL,
      1.363906,
      NULL,
      1.529905,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.723745,
      NULL,
      0.132612,
      NULL,
      0.343507,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.729268,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2.386041,
      0,
      0,
      2.204368,
      1,
      NULL,
      1.097309,
      0,
      NULL,
      1.067001,
      0.051928,
      0,
      1.929690,
      1,
      1.956192,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      1,
      1.467349,
      1,
      1.470255,
      0.345944,
      0,
      0.277239,
      3.866581,
      1,
      1.407651,
      NULL,
      1,
      0.046214,
      2.858048,
      0.365782,
      0,
      NULL,
      1.728698,
      0,
      0,
      0,
      3.037365,
      3,
      1.824386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.877432,
      0,
      NULL,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      58,
      NULL,
      4,
      0.759018,
      3.875295,
      '44131',
      '41421',
      '',
      1.883327,
      '',
      '',
      '',
      0.414878,
      '',
      '',
      NULL);
commit;
end;
/


