set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '1222424',
      2,
      0,
      2,
      1,
      '0322',
      1.598362,
      0.590229,
      NULL,
      NULL,
      ' 8-12-1983',
      19,
      NULL,
      NULL,
      0.917571,
      2,
      ' 6- 6-1997',
      9,
      5.390475,
      171.890744,
      144,
      3.949795,
      ' 1- 6-1983',
      ' 6-10-1974',
      ' 0- 9-1996',
      NULL,
      NULL,
      1,
      1.775346,
      1,
      1.412241,
      8,
      0.701078,
      NULL,
      NULL,
      NULL,
      4,
      7,
      2,
      21,
      3.129763,
      25.673664,
      1.130982,
      2.211052,
      NULL,
      2.639506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.273096,
      NULL,
      9.442275,
      0.790754,
      NULL,
      1,
      NULL,
      1.605056,
      1,
      NULL,
      4,
      1,
      5.044271,
      0,
      5.147044,
      1.871150,
      0.839094,
      2,
      1.291893,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.623192,
      1.344409,
      0.634673,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.695216,
      NULL,
      5.329369,
      1,
      1,
      0.964418,
      1.361888,
      NULL,
      NULL,
      0.630588,
      NULL,
      NULL,
      0,
      0,
      0.102438,
      NULL,
      6,
      NULL,
      NULL,
      1,
      1,
      2.192092,
      0,
      1,
      1,
      5.593151,
      0,
      1.680369,
      0.220052,
      1.462430,
      1.522140,
      NULL,
      1.872495,
      2,
      3.575556,
      1,
      5,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1.631337,
      1,
      NULL,
      1,
      NULL,
      0,
      4,
      6,
      7,
      6.590747,
      1.157948,
      9,
      4,
      4.919233,
      3,
      6.387810,
      NULL,
      NULL,
      30.217626,
      ' 6-13-1976',
      11.098134,
      2.547480,
      1.406562,
      1.012076,
      0.313053,
      1.918760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.903213,
      1,
      0,
      1,
      1.913028,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237864,
      NULL,
      NULL,
      1,
      1,
      5.982601,
      1.383276,
      2.697809,
      1.980389,
      1.442229,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795530,
      1,
      1,
      2.719499,
      NULL,
      5.891629,
      NULL,
      0,
      NULL,
      NULL,
      1.249842,
      NULL,
      0.447382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0.653655,
      1,
      1,
      1.224432,
      2,
      NULL,
      0.330919,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.365082,
      3.322647,
      0.264051,
      2.664209,
      0.341539,
      3.950804,
      2,
      0,
      NULL,
      1,
      3,
      NULL,
      0.997772,
      3,
      1,
      0.151812,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0.690094,
      0,
      0.091203,
      1.208306,
      3.430620,
      1,
      3.977602,
      4,
      NULL,
      3,
      0.764057,
      5.314787,
      4,
      NULL,
      NULL,
      2.570704,
      2.456788,
      1,
      18,
      NULL,
      2,
      NULL,
      70.569521,
      NULL,
      69.874293,
      1.452132,
      NULL,
      0.144569,
      '03113',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      1,
      7.637178,
      14,
      0.975871,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.623922,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.801157,
      1,
      NULL,
      NULL,
      1,
      2,
      1.780120,
      1,
      NULL,
      3.633557,
      2,
      1.867208,
      NULL,
      2,
      0.890235,
      1.154311,
      1.650017,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.892621,
      NULL,
      NULL,
      1.507686,
      NULL,
      NULL,
      3.811927,
      8.414925,
      5.603701,
      1.865711,
      1.791453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432933,
      NULL,
      NULL,
      1.727102,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988612,
      0.794095,
      0.596909,
      0,
      1.351092,
      NULL,
      NULL,
      7.396577,
      4,
      3.577006,
      1,
      3.143140,
      3.370221,
      3.598805,
      2.383059,
      NULL,
      6,
      1,
      0.131904,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.105587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.650032,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3.809576,
      0.069443,
      3,
      1.096175,
      NULL,
      0,
      4,
      2,
      1.252466,
      3.137569,
      0,
      NULL,
      NULL,
      2.527856,
      NULL,
      1,
      2,
      1.417529,
      1.743780,
      NULL,
      1.130090,
      0.763044,
      NULL,
      3.659773,
      0.873716,
      2.352921,
      1,
      0,
      2,
      0.684131,
      3,
      0.278638,
      1.619253,
      0,
      3,
      0,
      1.537968,
      9,
      7,
      6,
      3.930935,
      2.576110,
      NULL,
      0.812218,
      NULL,
      3,
      0.012436,
      0,
      NULL,
      NULL,
      NULL,
      0.614331,
      NULL,
      NULL,
      0.403322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.220035,
      NULL,
      NULL,
      0.506926,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.025913,
      NULL,
      NULL,
      1.584955,
      NULL,
      NULL,
      3.676755,
      2.940419,
      2.751370,
      NULL,
      0,
      0.987423,
      3.774203,
      NULL,
      NULL,
      5.615028,
      4.641207,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      1.358061,
      2.097436,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.969145,
      NULL,
      NULL,
      1,
      0.583908,
      NULL,
      NULL,
      0,
      0.111091,
      NULL,
      NULL,
      2,
      0.523648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.748448,
      NULL,
      NULL,
      NULL,
      3.529244,
      NULL,
      NULL,
      NULL,
      0.031657,
      NULL,
      NULL,
      NULL,
      NULL,
      1.783221,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.279934,
      NULL,
      NULL,
      0,
      2.641720,
      NULL,
      NULL,
      3.310409,
      0.300843,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      0.852882,
      NULL,
      NULL,
      4.909110,
      NULL,
      NULL,
      NULL,
      1.045337,
      NULL,
      NULL,
      NULL,
      1,
      7,
      NULL,
      2.065630,
      NULL,
      3.611552,
      1.516738,
      NULL,
      NULL,
      NULL,
      0,
      2.082452,
      1.105930,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.148562,
      1.642311,
      0,
      0,
      1.547489,
      0.547903,
      1.147172,
      1,
      1.708092,
      NULL,
      0.909761,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.503582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.997118,
      NULL,
      0,
      7.732217,
      2,
      NULL,
      0.349252,
      1.096301,
      5,
      1,
      1.358679,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.625716,
      0,
      0,
      NULL,
      1,
      0,
      0.360169,
      0.559431,
      2,
      2.605685,
      NULL,
      1.977209,
      2.903355,
      0,
      0.524922,
      3,
      1.472948,
      1.216332,
      3.104003,
      NULL,
      1.259097,
      1,
      1,
      0.105197,
      0,
      1.175504,
      NULL,
      NULL,
      NULL,
      NULL,
      0.055951,
      0.445423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      1.162081,
      0,
      0,
      1,
      1.174386,
      3.674618,
      1,
      1,
      2.009661,
      NULL,
      NULL,
      1,
      1,
      2.748419,
      NULL,
      3.449015,
      1.298782,
      2,
      1,
      2,
      1.190969,
      3.967264,
      NULL,
      NULL,
      0.095251,
      NULL,
      NULL,
      1,
      1.072381,
      1.891024,
      0.626663,
      0,
      5.262687,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      29.629611,
      NULL,
      0,
      1,
      '20110',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


